/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.spi;

import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.spi.ServiceProvider;

public abstract class FactoryProvider<I>
implements Comparable<FactoryProvider<?>> {
    private final Class<I> baseInterface;

    protected FactoryProvider(Class<I> baseInterface) {
        this.baseInterface = baseInterface;
    }

    protected Class<I> getBaseInterface() {
        return this.baseInterface;
    }

    protected abstract I getFactoryInstance();

    private int getPrecedence() {
        ServiceProvider annotation = this.getClass().getAnnotation(ServiceProvider.class);
        return annotation != null ? annotation.precedence() : 0;
    }

    @Override
    public int compareTo(FactoryProvider<?> o) {
        int result = this.getBaseInterface().getCanonicalName().compareTo(o.getBaseInterface().getCanonicalName());
        return result != 0 ? result : Integer.compare(this.getPrecedence(), super.getPrecedence());
    }

    public int hashCode() {
        return Objects.hashCode(this.getBaseInterface().getCanonicalName(), this.getPrecedence());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof FactoryProvider)) {
            return false;
        }
        return this.compareTo((FactoryProvider)o) == 0;
    }
}

