/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Stopwatch;
import com.google.appengine.repackaged.com.google.common.base.Ticker;
import com.google.appengine.repackaged.com.google.common.collect.SortedLists;
import com.google.appengine.repackaged.com.google.common.math.LongMath;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Uninterruptibles;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.math.RoundingMode;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@Beta
public abstract class RateLimiter {
    private final SleepingStopwatch stopwatch;
    private volatile Object mutexDoNotUseDirectly;

    public static RateLimiter create(double permitsPerSecond) {
        return RateLimiter.create(SleepingStopwatch.createFromSystemTimer(), permitsPerSecond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GoogleInternal
    public final int latestPermitAgeSec() {
        Object object = this.mutex();
        synchronized (object) {
            return this.doLatestPermitAgeSec(this.stopwatch.readMicros());
        }
    }

    @GoogleInternal
    int doLatestPermitAgeSec(long nowMicros) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GoogleInternal
    public final void setPermitsWithinHorizon(int permitsWithinHorizon) {
        Object object = this.mutex();
        synchronized (object) {
            this.doSetPermitsWithinHorizon(permitsWithinHorizon);
        }
    }

    @GoogleInternal
    void doSetPermitsWithinHorizon(int permitsWithinHorizon) {
        throw new UnsupportedOperationException();
    }

    @VisibleForTesting
    static RateLimiter create(SleepingStopwatch stopwatch, double permitsPerSecond) {
        SmoothBursty rateLimiter = new SmoothBursty(stopwatch, 1.0);
        rateLimiter.setRate(permitsPerSecond);
        return rateLimiter;
    }

    public static RateLimiter create(double permitsPerSecond, long warmupPeriod, TimeUnit unit) {
        return RateLimiter.create(SleepingStopwatch.createFromSystemTimer(), permitsPerSecond, warmupPeriod, unit);
    }

    @VisibleForTesting
    static RateLimiter create(SleepingStopwatch stopwatch, double permitsPerSecond, long warmupPeriod, TimeUnit unit) {
        SmoothWarmingUp rateLimiter = new SmoothWarmingUp(stopwatch, warmupPeriod, unit);
        rateLimiter.setRate(permitsPerSecond);
        return rateLimiter;
    }

    @GoogleInternal
    public static RateLimiter createWithCapacity(double permitsPerSecond, long maxBurstBuildup, TimeUnit unit) {
        return RateLimiter.createWithCapacity(SleepingStopwatch.createFromSystemTimer(), permitsPerSecond, maxBurstBuildup, unit);
    }

    @VisibleForTesting
    static RateLimiter createWithCapacity(SleepingStopwatch stopwatch, double permitsPerSecond, long maxBurstBuildup, TimeUnit unit) {
        double maxBurstSeconds = (double)unit.toNanos(maxBurstBuildup) / 1.0E9;
        SmoothBursty rateLimiter = new SmoothBursty(stopwatch, maxBurstSeconds);
        rateLimiter.setRate(permitsPerSecond);
        return rateLimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object mutex() {
        Object mutex = this.mutexDoNotUseDirectly;
        if (mutex == null) {
            RateLimiter rateLimiter = this;
            synchronized (rateLimiter) {
                mutex = this.mutexDoNotUseDirectly;
                if (mutex == null) {
                    this.mutexDoNotUseDirectly = mutex = new Object();
                }
            }
        }
        return mutex;
    }

    private RateLimiter(SleepingStopwatch stopwatch) {
        this.stopwatch = Preconditions.checkNotNull(stopwatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRate(double permitsPerSecond) {
        Preconditions.checkArgument(permitsPerSecond > 0.0 && !Double.isNaN(permitsPerSecond), "rate must be positive");
        Object object = this.mutex();
        synchronized (object) {
            this.doSetRate(permitsPerSecond, this.stopwatch.readMicros());
        }
    }

    abstract void doSetRate(double var1, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double getRate() {
        Object object = this.mutex();
        synchronized (object) {
            return this.doGetRate();
        }
    }

    abstract double doGetRate();

    public double acquire() {
        return this.acquire(1);
    }

    public double acquire(int permits) {
        long microsToWait = this.reserve(permits);
        this.stopwatch.sleepMicrosUninterruptibly(microsToWait);
        return 1.0 * (double)microsToWait / (double)TimeUnit.SECONDS.toMicros(1L);
    }

    long reserve() {
        return this.reserve(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long reserve(int permits) {
        RateLimiter.checkPermits(permits);
        Object object = this.mutex();
        synchronized (object) {
            return this.reserveNextTicket(permits, this.stopwatch.readMicros());
        }
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) {
        return this.tryAcquire(1, timeout, unit);
    }

    public boolean tryAcquire(int permits) {
        return this.tryAcquire(permits, 0L, TimeUnit.MICROSECONDS);
    }

    public boolean tryAcquire() {
        return this.tryAcquire(1, 0L, TimeUnit.MICROSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) {
        long microsToWait;
        long timeoutMicros = Math.max(unit.toMicros(timeout), 0L);
        RateLimiter.checkPermits(permits);
        Object object = this.mutex();
        synchronized (object) {
            long nowMicros = this.stopwatch.readMicros();
            if (!this.canAcquire(nowMicros, timeoutMicros)) {
                return false;
            }
            microsToWait = this.reserveNextTicket(permits, nowMicros);
        }
        this.stopwatch.sleepMicrosUninterruptibly(microsToWait);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GoogleInternal
    public boolean couldAcquire() {
        Object object = this.mutex();
        synchronized (object) {
            long nowMicros = this.stopwatch.readMicros();
            return this.canAcquire(nowMicros, 0L);
        }
    }

    private boolean canAcquire(long nowMicros, long timeoutMicros) {
        return this.earliestAvailable(nowMicros) - timeoutMicros <= nowMicros;
    }

    abstract long earliestAvailable(long var1);

    abstract long reserveNextTicket(int var1, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GoogleInternal
    public void forceAcquire() {
        Object object = this.mutex();
        synchronized (object) {
            long nowMicros = this.stopwatch.readMicros();
            this.doForceAcquire(nowMicros);
        }
    }

    @GoogleInternal
    void doForceAcquire(long nowMicros) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.format("RateLimiter[stableRate=%3.1fqps]", this.getRate());
    }

    private static int checkPermits(int permits) {
        Preconditions.checkArgument(permits > 0, "Requested permits (%s) must be positive", permits);
        return permits;
    }

    @GoogleInternal
    public static RateLimiter createWithRequestAlignedBuckets(int permitsPerBucket, int periodInMillis) {
        return RateLimiter.createWithRequestAlignedBuckets(SleepingStopwatch.createFromSystemTimer(), permitsPerBucket, periodInMillis);
    }

    @GoogleInternal
    @VisibleForTesting
    static RateLimiter createWithRequestAlignedBuckets(SleepingStopwatch stopwatch, int permitsPerBucket, int periodInMillis) {
        Preconditions.checkArgument(permitsPerBucket >= 0, "permitsPerBucket (%s) must be nonnegative", permitsPerBucket);
        Preconditions.checkArgument(periodInMillis >= 0, "periodInMillis (%s) must be nonnegative", periodInMillis);
        if (permitsPerBucket == 0) {
            return new FixedDelayRateLimiter(stopwatch, periodInMillis);
        }
        return new RequestAlignedBucketsRateLimiter(stopwatch, permitsPerBucket, periodInMillis);
    }

    @GoogleInternal
    public static RateLimiter createWithSecondGranularityHorizon(int permitsWithinHorizon, int horizonSec) {
        return RateLimiter.createWithSecondGranularityHorizon(permitsWithinHorizon, horizonSec, SleepingStopwatch.createFromSystemTimer());
    }

    @GoogleInternal
    @VisibleForTesting
    public static SecondGranularityHorizonRateLimiter createWithSecondGranularityHorizon(int permitsWithinHorizon, int horizonSec, Ticker ticker) {
        return new SecondGranularityHorizonRateLimiter(RateLimiter.createStopwatch(ticker), permitsWithinHorizon, horizonSec);
    }

    @GoogleInternal
    private static SleepingStopwatch createStopwatch(Ticker ticker) {
        final Stopwatch stopwatch = Stopwatch.createStarted(ticker);
        return new SleepingStopwatch(){

            @Override
            void sleepMicrosUninterruptibly(long micros) {
                Preconditions.checkArgument(micros <= 0L, "request to sleep (%s micros) unexpected for Throttle", micros);
            }

            @Override
            long readMicros() {
                return stopwatch.elapsed(TimeUnit.MICROSECONDS);
            }
        };
    }

    @GoogleInternal
    @VisibleForTesting
    static SecondGranularityHorizonRateLimiter createWithSecondGranularityHorizon(int permitsWithinHorizon, int horizonSec, SleepingStopwatch stopwatch) {
        return new SecondGranularityHorizonRateLimiter(stopwatch, permitsWithinHorizon, horizonSec);
    }

    @GoogleInternal
    private static int microsToSec(long micros) {
        return (int)TimeUnit.MICROSECONDS.toSeconds(micros);
    }

    @GoogleInternal
    private static int scalePermitsPerPeriod(double oldPermitsPerSecond, double newPermitsPerSecond, int oldPermits, long oldPeriod) {
        double rateMultiplier = newPermitsPerSecond / oldPermitsPerSecond;
        int newPermits = (int)((double)oldPermits * rateMultiplier);
        Preconditions.checkArgument(newPermits > 0, "underflow changing from permits per period %s/%s to rate %s", oldPermits, oldPeriod, newPermitsPerSecond);
        return newPermits;
    }

    @GoogleInternal
    private static final class SecondGranularityHorizonRateLimiter
    extends RateLimiter {
        private int permitsWithinHorizon;
        private final int horizonSec;
        private final IntArrayList permitGrantsSec = new IntArrayList();
        private Integer latestPermitGrantSec;

        SecondGranularityHorizonRateLimiter(SleepingStopwatch stopwatch, int permitsWithinHorizon, int horizonSec) {
            super(stopwatch);
            this.doSetPermitsWithinHorizon(permitsWithinHorizon);
            Preconditions.checkArgument(horizonSec > 0, "horizonSec (%s) must be positive", horizonSec);
            this.horizonSec = horizonSec;
        }

        @Override
        void doSetRate(double permitsPerSecond, long nowMicros) {
            this.permitsWithinHorizon = RateLimiter.scalePermitsPerPeriod(this.getRate(), permitsPerSecond, this.permitsWithinHorizon, this.horizonSec);
        }

        @Override
        double doGetRate() {
            return (double)this.permitsWithinHorizon / (double)this.horizonSec;
        }

        @Override
        long earliestAvailable(long nowMicros) {
            int nowSec = RateLimiter.microsToSec(nowMicros);
            int nextAvailableTimeSec = this.nextAvailableTimeSec(nowSec);
            return TimeUnit.SECONDS.toMicros(nextAvailableTimeSec);
        }

        @Override
        long reserveNextTicket(int requiredPermits, long nowMicros) {
            int nowSec = RateLimiter.microsToSec(nowMicros);
            int nextAvailableTimeSec = this.nextAvailableTimeSec(nowSec);
            this.recordGrant(nextAvailableTimeSec);
            return TimeUnit.SECONDS.toMicros(nextAvailableTimeSec) - nowMicros;
        }

        private int nextAvailableTimeSec(int nowSec) {
            this.pruneEvents(nowSec);
            return this.permitGrantsSec.size() < this.permitsWithinHorizon ? nowSec : this.permitGrantsSec.getInt(this.permitGrantsSec.size() - this.permitsWithinHorizon) + this.horizonSec;
        }

        private void pruneEvents(int nowSec) {
            int lastTimeOutsideWindow = nowSec - this.horizonSec;
            int index = SortedLists.binarySearch(this.permitGrantsSec, lastTimeOutsideWindow, SortedLists.KeyPresentBehavior.FIRST_AFTER, SortedLists.KeyAbsentBehavior.NEXT_HIGHER);
            this.permitGrantsSec.removeElements(0, index);
        }

        @Override
        int doLatestPermitAgeSec(long nowMicros) {
            Preconditions.checkState(this.latestPermitGrantSec != null, "No permits have been granted yet");
            int nowSec = RateLimiter.microsToSec(nowMicros);
            return nowSec - this.latestPermitGrantSec;
        }

        @Override
        void doForceAcquire(long nowMicros) {
            int nowSec = RateLimiter.microsToSec(nowMicros);
            this.recordGrant(nowSec);
        }

        private void recordGrant(int grantSec) {
            this.permitGrantsSec.add(grantSec);
            this.latestPermitGrantSec = grantSec;
        }

        @Override
        void doSetPermitsWithinHorizon(int permitsWithinHorizon) {
            Preconditions.checkArgument(permitsWithinHorizon > 0, "permitsWithinHorizon (%s) must be positive", permitsWithinHorizon);
            this.permitsWithinHorizon = permitsWithinHorizon;
        }
    }

    @GoogleInternal
    private static final class FixedDelayRateLimiter
    extends RateLimiter {
        private final long fixedDelay;

        FixedDelayRateLimiter(SleepingStopwatch stopwatch, long fixedDelay) {
            super(stopwatch);
            this.fixedDelay = fixedDelay;
        }

        @Override
        void doSetRate(double permitsPerSecond, long nowMicros) {
            throw new UnsupportedOperationException();
        }

        @Override
        double doGetRate() {
            return 0.0;
        }

        @Override
        long earliestAvailable(long nowMicros) {
            return nowMicros + this.fixedDelay;
        }

        @Override
        long reserveNextTicket(int requiredPermits, long nowMicros) {
            return this.fixedDelay;
        }
    }

    @VisibleForTesting
    static abstract class SleepingStopwatch {
        SleepingStopwatch() {
        }

        abstract long readMicros();

        abstract void sleepMicrosUninterruptibly(long var1);

        static final SleepingStopwatch createFromSystemTimer() {
            return new SleepingStopwatch(){
                final Stopwatch stopwatch = Stopwatch.createStarted();

                @Override
                long readMicros() {
                    return this.stopwatch.elapsed(TimeUnit.MICROSECONDS);
                }

                @Override
                void sleepMicrosUninterruptibly(long micros) {
                    if (micros > 0L) {
                        Uninterruptibles.sleepUninterruptibly(micros, TimeUnit.MICROSECONDS);
                    }
                }
            };
        }
    }

    @GoogleInternal
    private static final class RequestAlignedBucketsRateLimiter
    extends RateLimiter {
        private static final int NO_BUCKETS_CREATED_YET = -1;
        private long potentiallyAvailableBucketStartMicros;
        private int permitsAcquiredInBucket = -1;
        private int permitsPerBucket;
        private long periodInMicros;

        RequestAlignedBucketsRateLimiter(SleepingStopwatch stopwatch, int permitsPerBucket, int periodInMillis) {
            super(stopwatch);
            this.permitsPerBucket = permitsPerBucket;
            this.periodInMicros = TimeUnit.MILLISECONDS.toMicros(periodInMillis);
        }

        @Override
        void doSetRate(double newPermitsPerSecond, long nowMicros) {
            this.permitsPerBucket = RateLimiter.scalePermitsPerPeriod(this.getRate(), newPermitsPerSecond, this.permitsPerBucket, this.periodInMicros);
        }

        @Override
        double doGetRate() {
            double periodInSec = (double)this.periodInMicros / 1000000.0;
            return (double)this.permitsPerBucket / periodInSec;
        }

        @Override
        long earliestAvailable(long nowMicros) {
            return this.actuallyAvailableBucketStartMicros(nowMicros);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        long reserveNextTicket(int requiredPermits, long nowMicros) {
            try {
                this.updatePotentialBucketToActual(nowMicros);
                long l = this.timeUntilInAvailableBucket(nowMicros);
                return l;
            }
            finally {
                this.consumePermitsAndBuckets(requiredPermits);
            }
        }

        private void updatePotentialBucketToActual(long nowMicros) {
            long actuallyAvailableBucketStartMicros = this.actuallyAvailableBucketStartMicros(nowMicros);
            if (actuallyAvailableBucketStartMicros != this.potentiallyAvailableBucketStartMicros || this.permitsAcquiredInBucket == -1) {
                this.potentiallyAvailableBucketStartMicros = actuallyAvailableBucketStartMicros;
                this.permitsAcquiredInBucket = 0;
            }
        }

        private long actuallyAvailableBucketStartMicros(long nowMicros) {
            if (nowMicros - this.potentiallyAvailableBucketStartMicros > this.periodInMicros || this.permitsAcquiredInBucket == -1) {
                return nowMicros;
            }
            if (this.permitsAcquiredInBucket + 1 > this.permitsPerBucket) {
                return this.potentiallyAvailableBucketStartMicros + this.periodInMicros;
            }
            return this.potentiallyAvailableBucketStartMicros;
        }

        private long timeUntilInAvailableBucket(long nowMicros) {
            return Math.max(this.potentiallyAvailableBucketStartMicros - nowMicros, 0L);
        }

        private void consumePermitsAndBuckets(int requiredPermits) {
            this.permitsAcquiredInBucket += requiredPermits;
            long extraBucketsContaining = LongMath.divide(this.permitsAcquiredInBucket, this.permitsPerBucket, RoundingMode.CEILING) - 1L;
            this.potentiallyAvailableBucketStartMicros += extraBucketsContaining * this.periodInMicros;
            this.permitsAcquiredInBucket = (int)((long)this.permitsAcquiredInBucket - extraBucketsContaining * (long)this.permitsPerBucket);
        }
    }

    private static final class SmoothBursty
    extends SmoothRateLimiter {
        final double maxBurstSeconds;

        SmoothBursty(SleepingStopwatch stopwatch, double maxBurstSeconds) {
            super(stopwatch);
            this.maxBurstSeconds = maxBurstSeconds;
        }

        @Override
        void doSetRate(double permitsPerSecond, double stableIntervalMicros) {
            double oldMaxPermits = this.maxPermits;
            this.maxPermits = this.maxBurstSeconds * permitsPerSecond;
            this.storedPermits = oldMaxPermits == 0.0 ? 0.0 : this.storedPermits * this.maxPermits / oldMaxPermits;
        }

        @Override
        long storedPermitsToWaitTime(double storedPermits, double permitsToTake) {
            return 0L;
        }
    }

    private static final class SmoothWarmingUp
    extends SmoothRateLimiter {
        final long warmupPeriodMicros;
        private double slope;
        private double halfPermits;

        SmoothWarmingUp(SleepingStopwatch stopwatch, long warmupPeriod, TimeUnit timeUnit) {
            super(stopwatch);
            this.warmupPeriodMicros = timeUnit.toMicros(warmupPeriod);
        }

        @Override
        void doSetRate(double permitsPerSecond, double stableIntervalMicros) {
            double oldMaxPermits = this.maxPermits;
            this.maxPermits = (double)this.warmupPeriodMicros / stableIntervalMicros;
            this.halfPermits = this.maxPermits / 2.0;
            double coldIntervalMicros = stableIntervalMicros * 3.0;
            this.slope = (coldIntervalMicros - stableIntervalMicros) / this.halfPermits;
            this.storedPermits = oldMaxPermits == Double.POSITIVE_INFINITY ? 0.0 : (oldMaxPermits == 0.0 ? this.maxPermits : this.storedPermits * this.maxPermits / oldMaxPermits);
        }

        @Override
        long storedPermitsToWaitTime(double storedPermits, double permitsToTake) {
            double availablePermitsAboveHalf = storedPermits - this.halfPermits;
            long micros = 0L;
            if (availablePermitsAboveHalf > 0.0) {
                double permitsAboveHalfToTake = Math.min(availablePermitsAboveHalf, permitsToTake);
                micros = (long)(permitsAboveHalfToTake * (this.permitsToTime(availablePermitsAboveHalf) + this.permitsToTime(availablePermitsAboveHalf - permitsAboveHalfToTake)) / 2.0);
                permitsToTake -= permitsAboveHalfToTake;
            }
            micros = (long)((double)micros + this.stableIntervalMicros * permitsToTake);
            return micros;
        }

        private double permitsToTime(double permits) {
            return this.stableIntervalMicros + permits * this.slope;
        }
    }

    private static abstract class SmoothRateLimiter
    extends RateLimiter {
        double storedPermits;
        double maxPermits;
        double stableIntervalMicros;
        private long nextFreeTicketMicros = 0L;

        private SmoothRateLimiter(SleepingStopwatch stopwatch) {
            super(stopwatch);
        }

        @Override
        final void doSetRate(double permitsPerSecond, long nowMicros) {
            double stableIntervalMicros;
            this.resync(nowMicros);
            this.stableIntervalMicros = stableIntervalMicros = (double)TimeUnit.SECONDS.toMicros(1L) / permitsPerSecond;
            this.doSetRate(permitsPerSecond, stableIntervalMicros);
        }

        abstract void doSetRate(double var1, double var3);

        @Override
        final double doGetRate() {
            return (double)TimeUnit.SECONDS.toMicros(1L) / this.stableIntervalMicros;
        }

        @Override
        final long earliestAvailable(long nowMicros) {
            return this.nextFreeTicketMicros;
        }

        @Override
        long reserveNextTicket(int requiredPermits, long nowMicros) {
            this.resync(nowMicros);
            long microsToNextFreeTicket = Math.max(0L, this.nextFreeTicketMicros - nowMicros);
            double storedPermitsToSpend = Math.min((double)requiredPermits, this.storedPermits);
            double freshPermits = (double)requiredPermits - storedPermitsToSpend;
            long waitMicros = this.storedPermitsToWaitTime(this.storedPermits, storedPermitsToSpend) + (long)(freshPermits * this.stableIntervalMicros);
            this.nextFreeTicketMicros += waitMicros;
            this.storedPermits -= storedPermitsToSpend;
            return microsToNextFreeTicket;
        }

        abstract long storedPermitsToWaitTime(double var1, double var3);

        private void resync(long nowMicros) {
            if (nowMicros > this.nextFreeTicketMicros) {
                this.storedPermits = Math.min(this.maxPermits, this.storedPermits + (double)(nowMicros - this.nextFreeTicketMicros) / this.stableIntervalMicros);
                this.nextFreeTicketMicros = nowMicros;
            }
        }
    }
}

