/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AppIdNamespace;
import com.google.appengine.api.datastore.DataTypeUtils;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Projection;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Query
implements Serializable {
    @Deprecated
    public static final String KIND_METADATA_KIND = "__kind__";
    @Deprecated
    public static final String PROPERTY_METADATA_KIND = "__property__";
    @Deprecated
    public static final String NAMESPACE_METADATA_KIND = "__namespace__";
    static final long serialVersionUID = 7090652715949085374L;
    private final String kind;
    private final List<SortPredicate> sortPredicates = Lists.newArrayList();
    private final List<FilterPredicate> filterPredicates = Lists.newArrayList();
    private Filter filter;
    private Key ancestor;
    private boolean keysOnly;
    private final Map<String, Projection> projectionMap = Maps.newHashMap();
    private boolean distinct;
    private AppIdNamespace appIdNamespace;
    private transient String fullTextSearch;

    public Query() {
        this(null, null);
    }

    public Query(String kind) {
        this(kind, null);
    }

    Query(Query query) {
        this(query.kind, query.ancestor, query.sortPredicates, query.filter, query.filterPredicates, query.keysOnly, query.appIdNamespace, query.projectionMap.values(), query.distinct, query.fullTextSearch);
    }

    Query(String kind, Key ancestor, Filter filter, boolean keysOnly, AppIdNamespace appIdNamespace, boolean distinct, String fullTextSearch) {
        this.kind = kind;
        this.keysOnly = keysOnly;
        this.appIdNamespace = appIdNamespace;
        this.fullTextSearch = fullTextSearch;
        this.distinct = distinct;
        this.filter = filter;
        if (ancestor != null) {
            this.setAncestor(ancestor);
        }
    }

    Query(String kind, Key ancestor, Collection<SortPredicate> sortPreds, Filter filter, Collection<FilterPredicate> filterPreds, boolean keysOnly, AppIdNamespace appIdNamespace, Collection<Projection> projections, boolean distinct, String fullTextSearch) {
        this(kind, ancestor, filter, keysOnly, appIdNamespace, distinct, fullTextSearch);
        this.sortPredicates.addAll(sortPreds);
        this.filterPredicates.addAll(filterPreds);
        for (Projection projection : projections) {
            this.addProjection(projection);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.appIdNamespace == null) {
            this.appIdNamespace = this.ancestor != null ? this.ancestor.getAppIdNamespace() : new AppIdNamespace(DatastoreApiHelper.getCurrentAppId(), "");
        }
    }

    public Query(Key ancestor) {
        this(null, ancestor);
    }

    public Query(String kind, Key ancestor) {
        this(kind, ancestor, null, false, DatastoreApiHelper.getCurrentAppIdNamespace(), false, null);
    }

    public String getKind() {
        return this.kind;
    }

    AppIdNamespace getAppIdNamespace() {
        return this.appIdNamespace;
    }

    public String getAppId() {
        return this.appIdNamespace.getAppId();
    }

    public String getNamespace() {
        return this.appIdNamespace.getNamespace();
    }

    public Key getAncestor() {
        return this.ancestor;
    }

    public Query setAncestor(Key ancestor) {
        if (ancestor != null && !ancestor.isComplete()) {
            throw new IllegalArgumentException(ancestor + " is incomplete.");
        }
        if (ancestor == null && this.ancestor == null) {
            throw new IllegalArgumentException("Cannot clear ancestor unless ancestor has already been set");
        }
        if (ancestor != null && !ancestor.getAppIdNamespace().equals(this.appIdNamespace)) {
            throw new IllegalArgumentException("Namespace of ancestor key and query must match.");
        }
        this.ancestor = ancestor;
        return this;
    }

    public Query setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public boolean getDistinct() {
        return this.distinct;
    }

    public Query setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Deprecated
    public Query addFilter(String propertyName, FilterOperator operator, Object value) {
        this.filterPredicates.add(operator.of(propertyName, value));
        return this;
    }

    @Deprecated
    public List<FilterPredicate> getFilterPredicates() {
        return this.filterPredicates;
    }

    public Query addSort(String propertyName) {
        return this.addSort(propertyName, SortDirection.ASCENDING);
    }

    public Query addSort(String propertyName, SortDirection direction) {
        this.sortPredicates.add(new SortPredicate(propertyName, direction));
        return this;
    }

    public List<SortPredicate> getSortPredicates() {
        return this.sortPredicates;
    }

    public Query setKeysOnly() {
        this.keysOnly = true;
        return this;
    }

    public Query clearKeysOnly() {
        this.keysOnly = false;
        return this;
    }

    public Query addProjection(Projection projection) {
        Preconditions.checkArgument(!this.projectionMap.containsKey(projection.getName()), "Query already contains projection with name: " + projection.getName());
        this.projectionMap.put(projection.getName(), projection);
        return this;
    }

    public Collection<Projection> getProjections() {
        return this.projectionMap.values();
    }

    public boolean isKeysOnly() {
        return this.keysOnly;
    }

    public Query reverse() {
        ArrayList<SortPredicate> order = new ArrayList<SortPredicate>(this.sortPredicates.size());
        boolean hasKeyOrder = false;
        for (SortPredicate sort : this.sortPredicates) {
            if ("__key__".equals(sort.getPropertyName())) {
                hasKeyOrder = true;
            }
            if (!this.distinct || this.projectionMap.containsKey(sort.getPropertyName())) {
                order.add(sort.reverse());
                continue;
            }
            order.add(sort);
        }
        Preconditions.checkState(hasKeyOrder, "A sort on __key__ is required to reverse a Query");
        return new Query(this.kind, this.ancestor, order, this.filter, this.filterPredicates, this.keysOnly, this.appIdNamespace, this.projectionMap.values(), this.distinct, this.fullTextSearch);
    }

    String getFullTextSearch() {
        return this.fullTextSearch;
    }

    Query setFullTextSearch(String fullTextSearch) {
        this.fullTextSearch = fullTextSearch;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        if (this.keysOnly != query.keysOnly) {
            return false;
        }
        if (!Objects.equals(this.ancestor, query.ancestor)) {
            return false;
        }
        if (!this.appIdNamespace.equals(query.appIdNamespace)) {
            return false;
        }
        if (!Objects.equals(this.filter, query.filter)) {
            return false;
        }
        if (!this.filterPredicates.equals(query.filterPredicates)) {
            return false;
        }
        if (!Objects.equals(this.kind, query.kind)) {
            return false;
        }
        if (!this.sortPredicates.equals(query.sortPredicates)) {
            return false;
        }
        if (!this.projectionMap.equals(query.projectionMap)) {
            return false;
        }
        if (this.distinct != query.distinct) {
            return false;
        }
        return Objects.equals(this.fullTextSearch, query.fullTextSearch);
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.sortPredicates, this.filterPredicates, this.filter, this.ancestor, this.keysOnly, this.appIdNamespace, this.projectionMap, this.distinct, this.fullTextSearch);
    }

    int hashCodeNoFilterValues() {
        int filterHashCode = 1;
        for (FilterPredicate filterPred : this.filterPredicates) {
            filterHashCode = 31 * filterHashCode + filterPred.hashCodeNoFilterValues();
        }
        filterHashCode = 31 * filterHashCode + (this.filter == null ? 0 : this.filter.hashCodeNoFilterValues());
        return Objects.hash(this.kind, this.sortPredicates, filterHashCode, this.ancestor, this.keysOnly, this.appIdNamespace, this.projectionMap, this.distinct, this.fullTextSearch);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("SELECT ");
        if (this.distinct) {
            result.append("DISTINCT ");
        }
        if (!this.projectionMap.isEmpty()) {
            Joiner.on(", ").appendTo(result, (Iterable<?>)this.projectionMap.values());
        } else if (this.keysOnly) {
            result.append("__key__");
        } else {
            result.append('*');
        }
        if (this.kind != null) {
            result.append(" FROM ");
            result.append(this.kind);
        }
        if (this.ancestor != null || !this.filterPredicates.isEmpty() || this.filter != null) {
            result.append(" WHERE ");
            String AND_SEPARATOR = " AND ";
            if (this.filter != null) {
                result.append(this.filter);
            } else if (!this.filterPredicates.isEmpty()) {
                Joiner.on(" AND ").appendTo(result, (Iterable<?>)this.filterPredicates);
            }
            if (this.ancestor != null) {
                if (!this.filterPredicates.isEmpty() || this.filter != null) {
                    result.append(" AND ");
                }
                result.append("__ancestor__ is ");
                result.append(this.ancestor);
            }
        }
        if (!this.sortPredicates.isEmpty()) {
            result.append(" ORDER BY ");
            Joiner.on(", ").appendTo(result, (Iterable<?>)this.sortPredicates);
        }
        return result.toString();
    }

    public static final class FilterPredicate
    extends Filter {
        static final long serialVersionUID = 7681475799401864259L;
        private final String propertyName;
        private final FilterOperator operator;
        private final Object value;

        public FilterPredicate(String propertyName, FilterOperator operator, Object value) {
            if (propertyName == null) {
                throw new NullPointerException("Property name was null");
            }
            if (operator == null) {
                throw new NullPointerException("Operator was null");
            }
            if (operator == FilterOperator.IN) {
                if (!(value instanceof Collection) && value instanceof Iterable) {
                    ArrayList newValue = new ArrayList();
                    Iterables.addAll(newValue, value);
                    value = newValue;
                }
                DataTypeUtils.checkSupportedValue(propertyName, (Object)value, true, true);
            } else {
                DataTypeUtils.checkSupportedValue(propertyName, (Object)value, false, false);
            }
            this.propertyName = propertyName;
            this.operator = operator;
            this.value = value;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public FilterOperator getOperator() {
            return this.operator;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterPredicate that = (FilterPredicate)o;
            if (this.operator != that.operator) {
                return false;
            }
            if (!this.propertyName.equals(that.propertyName)) {
                return false;
            }
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.propertyName, this.operator, this.value});
        }

        @Override
        int hashCodeNoFilterValues() {
            return Objects.hash(new Object[]{this.propertyName, this.operator});
        }

        public String toString() {
            return this.propertyName + " " + (Object)((Object)this.operator) + " " + (this.value != null ? this.value : "NULL");
        }
    }

    public static final class CompositeFilter
    extends Filter {
        static final long serialVersionUID = 7930286402872420509L;
        private final CompositeFilterOperator operator;
        private final ImmutableList<Filter> subFilters;

        public CompositeFilter(CompositeFilterOperator operator, Collection<Filter> subFilters) {
            Preconditions.checkArgument(subFilters.size() >= 2, "At least two sub filters are required.");
            this.operator = Preconditions.checkNotNull(operator);
            this.subFilters = ImmutableList.copyOf(subFilters);
        }

        public CompositeFilterOperator getOperator() {
            return this.operator;
        }

        public List<Filter> getSubFilters() {
            return this.subFilters;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            Joiner.on(" " + (Object)((Object)this.operator) + " ").appendTo(builder, (Iterable<?>)this.subFilters);
            builder.append(')');
            return builder.toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.operator, this.subFilters});
        }

        @Override
        int hashCodeNoFilterValues() {
            int result = 1;
            result = 31 * result + this.operator.hashCode();
            for (Filter filter : this.subFilters) {
                result = 31 * result + filter.hashCodeNoFilterValues();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CompositeFilter)) {
                return false;
            }
            CompositeFilter other = (CompositeFilter)obj;
            if (this.operator != other.operator) {
                return false;
            }
            return this.subFilters.equals(other.subFilters);
        }
    }

    public static abstract class Filter
    implements Serializable {
        static final long serialVersionUID = -845113806195204425L;

        Filter() {
        }

        abstract int hashCodeNoFilterValues();
    }

    public static final class SortPredicate
    implements Serializable {
        static final long serialVersionUID = -623786024456258081L;
        private final String propertyName;
        private final SortDirection direction;

        public SortPredicate(String propertyName, SortDirection direction) {
            if (propertyName == null) {
                throw new NullPointerException("Property name was null");
            }
            if (direction == null) {
                throw new NullPointerException("Direction was null");
            }
            this.propertyName = propertyName;
            this.direction = direction;
        }

        public SortPredicate reverse() {
            return new SortPredicate(this.propertyName, this.direction == SortDirection.ASCENDING ? SortDirection.DESCENDING : SortDirection.ASCENDING);
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public SortDirection getDirection() {
            return this.direction;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SortPredicate that = (SortPredicate)o;
            if (this.direction != that.direction) {
                return false;
            }
            return this.propertyName.equals(that.propertyName);
        }

        public int hashCode() {
            int result = this.propertyName.hashCode();
            result = 31 * result + this.direction.hashCode();
            return result;
        }

        public String toString() {
            return this.propertyName + (this.direction == SortDirection.DESCENDING ? " DESC" : "");
        }
    }

    public static enum CompositeFilterOperator {
        AND,
        OR;


        public static CompositeFilter and(Filter ... subFilters) {
            return CompositeFilterOperator.and(Arrays.asList(subFilters));
        }

        public static CompositeFilter and(Collection<Filter> subFilters) {
            return new CompositeFilter(AND, subFilters);
        }

        public static CompositeFilter or(Filter ... subFilters) {
            return CompositeFilterOperator.or(Arrays.asList(subFilters));
        }

        public static CompositeFilter or(Collection<Filter> subFilters) {
            return new CompositeFilter(OR, subFilters);
        }

        public CompositeFilter of(Filter ... subFilters) {
            return new CompositeFilter(this, Arrays.asList(subFilters));
        }

        public CompositeFilter of(Collection<Filter> subFilters) {
            return new CompositeFilter(this, subFilters);
        }
    }

    public static enum FilterOperator {
        LESS_THAN("<"),
        LESS_THAN_OR_EQUAL("<="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUAL(">="),
        EQUAL("="),
        NOT_EQUAL("!="),
        IN("IN");

        private final String shortName;

        private FilterOperator(String shortName) {
            this.shortName = shortName;
        }

        public String toString() {
            return this.shortName;
        }

        public FilterPredicate of(String propertyName, Object value) {
            return new FilterPredicate(propertyName, this, value);
        }
    }

    public static enum SortDirection {
        ASCENDING,
        DESCENDING;

    }
}

