/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet;

import com.google.apphosting.utils.servlet.MultipartMimeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMultipart;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ParseBlobUploadFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(ParseBlobUploadFilter.class.getName());
    static final String UPLOAD_HEADER = "X-AppEngine-BlobUpload";
    static final String UPLOADED_BLOBKEY_ATTR = "com.google.appengine.api.blobstore.upload.blobkeys";

    public void init(FilterConfig config) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        if (req.getHeader(UPLOAD_HEADER) != null) {
            HashMap<String, String> blobKeys = new HashMap<String, String>();
            HashMap<String, List<String>> otherParams = new HashMap<String, List<String>>();
            try {
                MimeMultipart multipart = MultipartMimeUtils.parseMultipartRequest(req);
                int parts = multipart.getCount();
                for (int i = 0; i < parts; ++i) {
                    BodyPart part = multipart.getBodyPart(i);
                    if (part.getFileName() != null) {
                        ContentType contentType = new ContentType(part.getContentType());
                        if (!"message/external-body".equals(contentType.getBaseType())) continue;
                        String blobKeyString = contentType.getParameter("blob-key");
                        blobKeys.put(MultipartMimeUtils.getFieldName(part), blobKeyString);
                        continue;
                    }
                    String fieldName = MultipartMimeUtils.getFieldName(part);
                    ArrayList<String> values = (ArrayList<String>)otherParams.get(fieldName);
                    if (values == null) {
                        values = new ArrayList<String>();
                        otherParams.put(fieldName, values);
                    }
                    values.add(MultipartMimeUtils.getTextContent(part));
                }
                req.setAttribute(UPLOADED_BLOBKEY_ATTR, blobKeys);
            }
            catch (MessagingException ex) {
                logger.log(Level.WARNING, "Could not parse multipart message:", ex);
            }
            chain.doFilter((ServletRequest)new ParameterServletWrapper(request, otherParams), response);
        } else {
            chain.doFilter(request, response);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterServletWrapper
    extends HttpServletRequestWrapper {
        private final Map<String, List<String>> otherParams;

        ParameterServletWrapper(ServletRequest request, Map<String, List<String>> otherParams) {
            super((HttpServletRequest)request);
            this.otherParams = otherParams;
        }

        public Map getParameterMap() {
            Map parameters = super.getParameterMap();
            if (this.otherParams.isEmpty()) {
                return parameters;
            }
            HashMap<String, String[]> map = new HashMap<String, String[]>(parameters);
            for (Map.Entry<String, List<String>> entry : this.otherParams.entrySet()) {
                map.put(entry.getKey(), entry.getValue().toArray(new String[0]));
            }
            return Collections.unmodifiableMap(map);
        }

        public Enumeration getParameterNames() {
            ArrayList allNames = new ArrayList();
            Enumeration names = super.getParameterNames();
            while (names.hasMoreElements()) {
                allNames.add(names.nextElement());
            }
            allNames.addAll(this.otherParams.keySet());
            return Collections.enumeration(allNames);
        }

        public String[] getParameterValues(String name) {
            if (this.otherParams.containsKey(name)) {
                return this.otherParams.get(name).toArray(new String[0]);
            }
            return super.getParameterValues(name);
        }

        public String getParameter(String name) {
            if (this.otherParams.containsKey(name)) {
                return this.otherParams.get(name).get(0);
            }
            return super.getParameter(name);
        }
    }
}

