/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Supplier;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Iterators;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Multimap;
import com.google.appengine.repackaged.com.google.common.collect.Multimaps;
import com.google.appengine.repackaged.com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GoogleInternal
public final class ConcreteMultimap<K, V, C extends Collection<V>>
implements Multimap<K, V>,
Serializable {
    private final Map<K, C> map;
    private final Supplier<? extends C> factory;
    private transient Set<K> keySet;
    private transient Multiset<K> keys;
    private transient Collection<V> valuesCollection;
    private transient Collection<Map.Entry<K, V>> entries;
    private transient Map<K, Collection<V>> asMap;
    private static final long serialVersionUID = 0L;

    public static <K, V, C extends Collection<V>> ConcreteMultimap<K, V, C> create(Map<K, C> map, Supplier<? extends C> factory) {
        Preconditions.checkArgument(map.isEmpty());
        return new ConcreteMultimap<K, V, C>(map, Preconditions.checkNotNull(factory));
    }

    private ConcreteMultimap(Map<K, C> map, Supplier<? extends C> factory) {
        this.map = map;
        this.factory = factory;
    }

    @Override
    public int size() {
        int size = 0;
        for (Collection collection : this.map.values()) {
            size += collection.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        for (Collection collection : this.map.values()) {
            if (collection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        Collection collection = (Collection)this.map.get(key);
        return collection != null && !collection.isEmpty();
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        for (Collection collection : this.map.values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
        Collection collection = (Collection)this.map.get(key);
        return collection != null && collection.contains(value);
    }

    @Override
    public boolean put(K key, V value) {
        C collection = this.get(key);
        return collection.add(value);
    }

    @Override
    public boolean remove(@Nullable Object key, @Nullable Object value) {
        Collection collection = (Collection)this.map.get(key);
        return collection != null && collection.remove(value);
    }

    @Override
    public boolean putAll(K key, Iterable<? extends V> values) {
        C collection = this.get(key);
        return Iterables.addAll(collection, values);
    }

    @Override
    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        boolean changed = false;
        for (Map.Entry<K, V> entry : multimap.entries()) {
            changed |= this.put(entry.getKey(), entry.getValue());
        }
        return changed;
    }

    public C replaceValues(K key, Iterable<? extends V> values) {
        C collection = this.get(key);
        Collection oldValues = (Collection)this.factory.get();
        oldValues.addAll(collection);
        collection.clear();
        Iterables.addAll(collection, values);
        return (C)oldValues;
    }

    public C removeAll(Object key) {
        Collection collection = (Collection)this.map.get(key);
        Collection output = (Collection)this.factory.get();
        if (collection != null) {
            output.addAll(collection);
            collection.clear();
        }
        return (C)output;
    }

    @Override
    public void clear() {
        for (Collection collection : this.map.values()) {
            collection.clear();
        }
    }

    public C get(K key) {
        Collection collection = (Collection)this.map.get(key);
        if (collection == null) {
            collection = (Collection)this.factory.get();
            this.map.put(key, collection);
        }
        return (C)collection;
    }

    @Override
    public Set<K> keySet() {
        KeySet result = this.keySet;
        return result == null ? (this.keySet = new KeySet()) : result;
    }

    @Override
    public Multiset<K> keys() {
        Multiset<K> result = this.keys;
        if (result == null) {
            this.keys = new Multimaps.Keys<K, V>(){

                @Override
                Multimap<K, V> multimap() {
                    return ConcreteMultimap.this;
                }
            };
            return this.keys;
        }
        return result;
    }

    @Override
    public Collection<V> values() {
        Collection<V> result = this.valuesCollection;
        if (result == null) {
            this.valuesCollection = new Multimaps.Values<K, V>(){

                @Override
                Multimap<K, V> multimap() {
                    return ConcreteMultimap.this;
                }
            };
            return this.valuesCollection;
        }
        return result;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        Collection<Map.Entry<K, V>> result = this.entries;
        return result == null ? (this.entries = this.createEntries()) : result;
    }

    private Collection<Map.Entry<K, V>> createEntries() {
        if (this.factory.get() instanceof Set) {
            return new Multimaps.EntrySet<K, V>(){

                @Override
                Multimap<K, V> multimap() {
                    return ConcreteMultimap.this;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new EntryIterator();
                }
            };
        }
        return new Multimaps.Entries<K, V>(){

            @Override
            Multimap<K, V> multimap() {
                return ConcreteMultimap.this;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }
        };
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        AsMap result = this.asMap;
        return result == null ? (this.asMap = new AsMap()) : result;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Multimap) {
            Multimap that = (Multimap)object;
            return ((Object)this.asMap()).equals(that.asMap());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.asMap()).hashCode();
    }

    public String toString() {
        return this.asMap().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsMapIterator
    implements Iterator<Map.Entry<K, Collection<V>>> {
        final Iterator<Map.Entry<K, C>> entryIterator;
        Map.Entry<K, C> nextEntry;
        Map.Entry<K, C> lastEntry;

        private AsMapIterator() {
            this.entryIterator = ConcreteMultimap.this.map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.nextEntry == null || ((Collection)this.nextEntry.getValue()).isEmpty()) {
                if (!this.entryIterator.hasNext()) {
                    return false;
                }
                this.nextEntry = this.entryIterator.next();
            }
            return true;
        }

        @Override
        public Map.Entry<K, Collection<V>> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastEntry = this.nextEntry;
            this.nextEntry = null;
            return Maps.immutableEntry(this.lastEntry.getKey(), (Collection)this.lastEntry.getValue());
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.lastEntry != null);
            ((Collection)this.lastEntry.getValue()).clear();
            this.lastEntry = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsMap
    extends Multimaps.AsMap<K, V> {
        private AsMap() {
        }

        @Override
        Multimap<K, V> multimap() {
            return ConcreteMultimap.this;
        }

        @Override
        Iterator<Map.Entry<K, Collection<V>>> entryIterator() {
            return new AsMapIterator();
        }

        @Override
        public int size() {
            int size = 0;
            for (Collection collection : ConcreteMultimap.this.map.values()) {
                if (collection.isEmpty()) continue;
                ++size;
            }
            return size;
        }

        @Override
        public C get(Object key) {
            Collection collection = (Collection)ConcreteMultimap.this.map.get(key);
            return collection == null || collection.isEmpty() ? null : collection;
        }

        @Override
        public C remove(Object key) {
            Object collection = ConcreteMultimap.this.removeAll(key);
            return collection.isEmpty() ? null : (Object)collection;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        final Iterator<Map.Entry<K, C>> keyIterator;
        Map.Entry<K, C> nextEntry;
        Iterator<V> nextValueIterator = Iterators.emptyIterator();
        Iterator<V> removeIterator;

        EntryIterator() {
            this.keyIterator = ConcreteMultimap.this.map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            while (!this.nextValueIterator.hasNext()) {
                if (!this.keyIterator.hasNext()) {
                    return false;
                }
                this.nextEntry = this.keyIterator.next();
                this.nextValueIterator = ((Collection)this.nextEntry.getValue()).iterator();
            }
            return true;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removeIterator = this.nextValueIterator;
            return Maps.immutableEntry(this.nextEntry.getKey(), this.nextValueIterator.next());
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.removeIterator != null);
            this.removeIterator.remove();
            this.removeIterator = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends Maps.KeySet<K, Collection<V>> {
        private KeySet() {
        }

        @Override
        Map<K, Collection<V>> map() {
            return ConcreteMultimap.this.asMap();
        }

        @Override
        public boolean remove(Object key) {
            Collection collection = (Collection)ConcreteMultimap.this.map.get(key);
            if (collection != null && !collection.isEmpty()) {
                collection.clear();
                return true;
            }
            return false;
        }
    }
}

