/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.ValidatedQuery;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IndexComponentsOnlyQuery
extends ValidatedQuery {
    private final Set<String> equalityProps = new HashSet<String>();
    private final List<OnestoreEntity.Index.Property> indexProps = new ArrayList<OnestoreEntity.Index.Property>();
    private boolean hasKeyProperty = false;
    private static final Comparator<OnestoreEntity.Index.Property> PROPERTY_NAME_COMPARATOR = new Comparator<OnestoreEntity.Index.Property>(){

        @Override
        public int compare(OnestoreEntity.Index.Property o1, OnestoreEntity.Index.Property o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public IndexComponentsOnlyQuery(DatastorePb.Query query) {
        super(query);
        this.removeNativelySupportedComponents();
        this.categorizeQuery();
    }

    private void removeNativelySupportedComponents() {
        DatastorePb.Query.Order lastOrder;
        boolean hasKeyDescOrder = false;
        if (this.query.orderSize() > 0 && (lastOrder = this.query.getOrder(this.query.orderSize() - 1)).getProperty().equals("__key__")) {
            if (lastOrder.getDirection() == DatastorePb.Query.Order.Direction.ASCENDING.getValue()) {
                this.query.removeOrder(this.query.orderSize() - 1);
            } else {
                hasKeyDescOrder = true;
            }
        }
        if (!hasKeyDescOrder) {
            boolean hasNonKeyInequality = false;
            for (DatastorePb.Query.Filter f : this.query.filters()) {
                if (!ValidatedQuery.INEQUALITY_OPERATORS.contains(f.getOpEnum()) || "__key__".equals(f.getProperty(0).getName())) continue;
                hasNonKeyInequality = true;
                break;
            }
            if (!hasNonKeyInequality) {
                Iterator<DatastorePb.Query.Filter> itr = this.query.filterIterator();
                while (itr.hasNext()) {
                    if (!itr.next().getProperty(0).getName().equals("__key__")) continue;
                    itr.remove();
                }
            }
        }
    }

    private void categorizeQuery() {
        HashSet<String> ineqProps = new HashSet<String>();
        HashSet<String> existsProps = new HashSet<String>();
        this.hasKeyProperty = false;
        for (DatastorePb.Query.Filter filter : this.query.filters()) {
            String propName = filter.getProperty(0).getName();
            switch (filter.getOpEnum()) {
                case EQUAL: {
                    this.equalityProps.add(propName);
                    break;
                }
                case EXISTS: {
                    existsProps.add(propName);
                    break;
                }
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    ineqProps.add(propName);
                }
            }
            if (!propName.equals("__key__")) continue;
            this.hasKeyProperty = true;
        }
        for (String eqProp : this.equalityProps) {
            this.indexProps.add(IndexComponentsOnlyQuery.newIndexProperty(eqProp, OnestoreEntity.Index.Property.Direction.ASCENDING));
        }
        Collections.sort(this.indexProps, PROPERTY_NAME_COMPARATOR);
        if (this.query.orderSize() == 0 && !ineqProps.isEmpty()) {
            this.indexProps.add(IndexComponentsOnlyQuery.newIndexProperty((String)ineqProps.iterator().next(), OnestoreEntity.Index.Property.Direction.ASCENDING));
        }
        for (DatastorePb.Query.Order order : this.query.orders()) {
            if (order.getProperty().equals("__key__")) {
                this.hasKeyProperty = true;
            }
            this.indexProps.add(IndexComponentsOnlyQuery.newIndexProperty(order.getProperty(), OnestoreEntity.Index.Property.Direction.valueOf(order.getDirection())));
        }
        for (String existsProp : existsProps) {
            if (IndexComponentsOnlyQuery.indexPropertyWithNameExists(existsProp, this.indexProps)) continue;
            this.indexProps.add(IndexComponentsOnlyQuery.newIndexProperty(existsProp, OnestoreEntity.Index.Property.Direction.ASCENDING));
        }
    }

    private static boolean indexPropertyWithNameExists(String propName, List<OnestoreEntity.Index.Property> indexProperties) {
        for (OnestoreEntity.Index.Property indexProperty : indexProperties) {
            if (!indexProperty.getName().equals(propName)) continue;
            return true;
        }
        return false;
    }

    private static OnestoreEntity.Index.Property newIndexProperty(String name, OnestoreEntity.Index.Property.Direction direction) {
        OnestoreEntity.Index.Property indexProperty = new OnestoreEntity.Index.Property();
        indexProperty.setName(name);
        indexProperty.setDirection(direction);
        return indexProperty;
    }

    public Set<String> getEqualityProps() {
        return this.equalityProps;
    }

    public boolean hasKeyProperty() {
        return this.hasKeyProperty;
    }

    public List<OnestoreEntity.Index.Property> getIndexProps() {
        return this.indexProps;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexComponentsOnlyQuery that = (IndexComponentsOnlyQuery)o;
        return this.query.equals(that.query);
    }

    @Override
    public int hashCode() {
        return this.query.hashCode();
    }
}

