/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.conversion;

import com.google.appengine.api.conversion.ConversionHelper;
import com.google.appengine.api.conversion.Document;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;

public final class Conversion {
    private final Document input;
    private final String outputMimeType;

    public Conversion(Document input, String outputMimeType) {
        this.input = ConversionHelper.validateInputDoc(input);
        this.outputMimeType = Preconditions.checkNotNull(outputMimeType).toLowerCase();
        Preconditions.checkArgument(!this.outputMimeType.isEmpty(), "Output mime type should not be empty");
    }

    public Document getInputDoc() {
        return this.input;
    }

    public String getOutputMimeType() {
        return this.outputMimeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Conversion other = (Conversion)o;
        return Objects.equal(this.input, other.getInputDoc()) && Objects.equal(this.outputMimeType, other.getOutputMimeType());
    }

    public int hashCode() {
        return Objects.hashCode(this.input, this.outputMimeType);
    }
}

