/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore;

public final class UploadOptions {
    private Long maxUploadSizeBytesPerBlob;
    private Long maxUploadSizeBytes;

    private UploadOptions() {
    }

    public UploadOptions maxUploadSizeBytesPerBlob(long maxUploadSizeBytesPerBlob) {
        if (maxUploadSizeBytesPerBlob < 1L) {
            throw new IllegalArgumentException("maxUploadSizeBytesPerBlob must be positive.");
        }
        this.maxUploadSizeBytesPerBlob = maxUploadSizeBytesPerBlob;
        return this;
    }

    boolean hasMaxUploadSizeBytesPerBlob() {
        return this.maxUploadSizeBytesPerBlob != null;
    }

    long getMaxUploadSizeBytesPerBlob() {
        if (this.maxUploadSizeBytesPerBlob == null) {
            throw new IllegalStateException("maxUploadSizeBytesPerBlob has not been set.");
        }
        return this.maxUploadSizeBytesPerBlob;
    }

    public UploadOptions maxUploadSizeBytes(long maxUploadSizeBytes) {
        if (maxUploadSizeBytes < 1L) {
            throw new IllegalArgumentException("maxUploadSizeBytes must be positive.");
        }
        this.maxUploadSizeBytes = maxUploadSizeBytes;
        return this;
    }

    boolean hasMaxUploadSizeBytes() {
        return this.maxUploadSizeBytes != null;
    }

    long getMaxUploadSizeBytes() {
        if (this.maxUploadSizeBytes == null) {
            throw new IllegalStateException("maxUploadSizeBytes has not been set.");
        }
        return this.maxUploadSizeBytes;
    }

    public int hashCode() {
        int hash = 17;
        if (this.maxUploadSizeBytesPerBlob != null) {
            hash = hash * 37 + this.maxUploadSizeBytesPerBlob.hashCode();
        }
        if (this.maxUploadSizeBytes != null) {
            hash = hash * 37 + this.maxUploadSizeBytes.hashCode();
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (object instanceof UploadOptions) {
            UploadOptions key = (UploadOptions)object;
            if (this.hasMaxUploadSizeBytesPerBlob() != key.hasMaxUploadSizeBytesPerBlob()) {
                return false;
            }
            if (this.hasMaxUploadSizeBytesPerBlob() && !this.maxUploadSizeBytesPerBlob.equals(key.getMaxUploadSizeBytesPerBlob())) {
                return false;
            }
            if (this.hasMaxUploadSizeBytes() != key.hasMaxUploadSizeBytes()) {
                return false;
            }
            return !this.hasMaxUploadSizeBytes() || this.maxUploadSizeBytes.equals(key.getMaxUploadSizeBytes());
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("UploadOptions: maxUploadSizeBytes=");
        if (this.maxUploadSizeBytes != null) {
            buffer.append(this.maxUploadSizeBytes);
        } else {
            buffer.append("unlimited");
        }
        buffer.append(", maxUploadSizeBytesPerBlob=");
        if (this.maxUploadSizeBytesPerBlob != null) {
            buffer.append(this.maxUploadSizeBytesPerBlob);
        } else {
            buffer.append("unlimited");
        }
        buffer.append(".");
        return buffer.toString();
    }

    public static final class Builder {
        public static UploadOptions withMaxUploadSizeBytes(long maxUploadSizeBytes) {
            return Builder.withDefaults().maxUploadSizeBytes(maxUploadSizeBytes);
        }

        public static UploadOptions withMaxUploadSizeBytesPerBlob(long maxUploadSizeBytesPerBlob) {
            return Builder.withDefaults().maxUploadSizeBytesPerBlob(maxUploadSizeBytesPerBlob);
        }

        public static UploadOptions withDefaults() {
            return new UploadOptions();
        }

        private Builder() {
        }
    }
}

