/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.images;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.images.Composite;
import com.google.appengine.api.images.Image;
import com.google.appengine.api.images.ImagesService;
import com.google.appengine.api.images.ImagesServiceFactory;
import com.google.appengine.api.images.ImagesServiceFailureException;
import com.google.appengine.api.images.ImagesServicePb;
import com.google.appengine.api.images.OutputSettings;
import com.google.appengine.api.images.Transform;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImagesServiceImpl
implements ImagesService {
    static final String PACKAGE = "images";

    ImagesServiceImpl() {
    }

    @Override
    public Image applyTransform(Transform transform, Image image) {
        return this.applyTransform(transform, image, ImagesService.OutputEncoding.PNG);
    }

    @Override
    public Future<Image> applyTransformAsync(Transform transform, Image image) {
        return this.applyTransformAsync(transform, image, ImagesService.OutputEncoding.PNG);
    }

    @Override
    public Image applyTransform(Transform transform, Image image, ImagesService.OutputEncoding encoding) {
        return this.applyTransform(transform, image, new OutputSettings(encoding));
    }

    @Override
    public Future<Image> applyTransformAsync(Transform transform, Image image, ImagesService.OutputEncoding encoding) {
        return this.applyTransformAsync(transform, image, new OutputSettings(encoding));
    }

    @Override
    public Image applyTransform(Transform transform, Image image, OutputSettings settings) {
        ImagesServicePb.ImagesTransformRequest.Builder request = this.generateImagesTransformRequest(transform, image, settings);
        ImagesServicePb.ImagesTransformResponse.Builder response = ImagesServicePb.ImagesTransformResponse.newBuilder();
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, "Transform", request.build().toByteArray());
            response.mergeFrom(responseBytes);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new ImagesServiceFailureException("Invalid protocol buffer:", ex);
        }
        catch (ApiProxy.ApplicationException ex) {
            throw this.convertApplicationException(request, ex);
        }
        image.setImageData(response.getImage().getContent().toByteArray());
        return image;
    }

    @Override
    public Future<Image> applyTransformAsync(Transform transform, final Image image, OutputSettings settings) {
        final ImagesServicePb.ImagesTransformRequest.Builder request = this.generateImagesTransformRequest(transform, image, settings);
        Future<byte[]> responseBytes = ApiProxy.makeAsyncCall(PACKAGE, "Transform", request.build().toByteArray());
        return new FutureWrapper<byte[], Image>(responseBytes){

            @Override
            protected Image wrap(byte[] responseBytes) throws IOException {
                ImagesServicePb.ImagesTransformResponse.Builder response = (ImagesServicePb.ImagesTransformResponse.Builder)ImagesServicePb.ImagesTransformResponse.newBuilder().mergeFrom(responseBytes);
                image.setImageData(response.getImage().getContent().toByteArray());
                return image;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                if (cause instanceof ApiProxy.ApplicationException) {
                    return ImagesServiceImpl.this.convertApplicationException(request, (ApiProxy.ApplicationException)cause);
                }
                return cause;
            }
        };
    }

    @Override
    public Image composite(Collection<Composite> composites, int width, int height, long color) {
        return this.composite(composites, width, height, color, ImagesService.OutputEncoding.PNG);
    }

    @Override
    public Image composite(Collection<Composite> composites, int width, int height, long color, ImagesService.OutputEncoding encoding) {
        return this.composite(composites, width, height, color, new OutputSettings(encoding));
    }

    @Override
    public Image composite(Collection<Composite> composites, int width, int height, long color, OutputSettings settings) {
        ImagesServicePb.ImagesCompositeRequest.Builder request = ImagesServicePb.ImagesCompositeRequest.newBuilder();
        ImagesServicePb.ImagesCompositeResponse.Builder response = ImagesServicePb.ImagesCompositeResponse.newBuilder();
        if (composites.size() > 16) {
            throw new IllegalArgumentException("A maximum of 16 composites can be applied in a single request");
        }
        if (width > 4000 || width <= 0 || height > 4000 || height <= 0) {
            throw new IllegalArgumentException("Width and height must <= 4000 and > 0");
        }
        if (color > 0xFFFFFFFFL || color < 0L) {
            throw new IllegalArgumentException("Color must be in the range [0, 0xffffffff]");
        }
        if (color >= Integer.MIN_VALUE) {
            color -= 0x100000000L;
        }
        int fixedColor = (int)color;
        ImagesServicePb.ImagesCanvas.Builder canvas = ImagesServicePb.ImagesCanvas.newBuilder();
        canvas.setWidth(width);
        canvas.setHeight(height);
        canvas.setColor(fixedColor);
        canvas.setOutput(this.convertOutputSettings(settings));
        request.setCanvas(canvas);
        HashMap<Image, Integer> imageIdMap = new HashMap<Image, Integer>();
        for (Composite composite : composites) {
            composite.apply(request, imageIdMap);
        }
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, "Composite", request.build().toByteArray());
            response.mergeFrom(responseBytes);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new ImagesServiceFailureException("Invalid protocol buffer:", ex);
        }
        catch (ApiProxy.ApplicationException ex) {
            ImagesServicePb.ImagesServiceError.ErrorCode code = ImagesServicePb.ImagesServiceError.ErrorCode.valueOf(ex.getApplicationError());
            if (code != null && code != ImagesServicePb.ImagesServiceError.ErrorCode.UNSPECIFIED_ERROR) {
                throw new IllegalArgumentException(ex.getErrorDetail());
            }
            throw new ImagesServiceFailureException(ex.getErrorDetail());
        }
        return ImagesServiceFactory.makeImage(response.getImage().getContent().toByteArray());
    }

    @Override
    public int[][] histogram(Image image) {
        int i;
        ImagesServicePb.ImagesHistogramRequest.Builder request = ImagesServicePb.ImagesHistogramRequest.newBuilder();
        ImagesServicePb.ImagesHistogramResponse.Builder response = ImagesServicePb.ImagesHistogramResponse.newBuilder();
        request.setImage(ImagesServiceImpl.convertImageData(image));
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, "Histogram", request.build().toByteArray());
            response.mergeFrom(responseBytes);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new ImagesServiceFailureException("Invalid protocol buffer:", ex);
        }
        catch (ApiProxy.ApplicationException ex) {
            ImagesServicePb.ImagesServiceError.ErrorCode code = ImagesServicePb.ImagesServiceError.ErrorCode.valueOf(ex.getApplicationError());
            if (code != null && code != ImagesServicePb.ImagesServiceError.ErrorCode.UNSPECIFIED_ERROR) {
                throw new IllegalArgumentException(ex.getErrorDetail());
            }
            throw new ImagesServiceFailureException(ex.getErrorDetail());
        }
        ImagesServicePb.ImagesHistogram histogram = response.getHistogram();
        int[][] result = new int[3][];
        for (i = 0; i < 3; ++i) {
            result[i] = new int[256];
        }
        for (i = 0; i < 256; ++i) {
            result[0][i] = histogram.getRed(i);
            result[1][i] = histogram.getGreen(i);
            result[2][i] = histogram.getBlue(i);
        }
        return result;
    }

    @Override
    public String getServingUrl(BlobKey blobKey) {
        ImagesServicePb.ImagesGetUrlBaseRequest.Builder request = ImagesServicePb.ImagesGetUrlBaseRequest.newBuilder();
        ImagesServicePb.ImagesGetUrlBaseResponse.Builder response = ImagesServicePb.ImagesGetUrlBaseResponse.newBuilder();
        if (blobKey == null) {
            throw new NullPointerException();
        }
        request.setBlobKey(blobKey.getKeyString());
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, "GetUrlBase", request.build().toByteArray());
            response.mergeFrom(responseBytes);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new ImagesServiceFailureException("Invalid protocol buffer:", ex);
        }
        catch (ApiProxy.ApplicationException ex) {
            ImagesServicePb.ImagesServiceError.ErrorCode code = ImagesServicePb.ImagesServiceError.ErrorCode.valueOf(ex.getApplicationError());
            if (code != null && code != ImagesServicePb.ImagesServiceError.ErrorCode.UNSPECIFIED_ERROR) {
                throw new IllegalArgumentException(ex.getErrorDetail());
            }
            throw new ImagesServiceFailureException(ex.getErrorDetail());
        }
        return response.getUrl();
    }

    @Override
    public String getServingUrl(BlobKey blobKey, int imageSize, boolean crop) {
        if (imageSize > 1600 || imageSize < 0) {
            throw new IllegalArgumentException("Unsupported size: " + imageSize + ". Valid sizes must be between 0 and  " + 1600);
        }
        StringBuilder url = new StringBuilder(this.getServingUrl(blobKey));
        url.append("=s");
        url.append(imageSize);
        if (crop) {
            url.append("-c");
        }
        return url.toString();
    }

    static ImagesServicePb.ImageData convertImageData(Image image) {
        ImagesServicePb.ImageData.Builder builder = ImagesServicePb.ImageData.newBuilder();
        BlobKey blobKey = image.getBlobKey();
        if (blobKey != null) {
            builder.setBlobKey(image.getBlobKey().getKeyString());
            builder.setContent(ByteString.EMPTY);
        } else {
            builder.setContent(ByteString.copyFrom(image.getImageData()));
        }
        return builder.build();
    }

    private ImagesServicePb.ImagesTransformRequest.Builder generateImagesTransformRequest(Transform transform, Image image, OutputSettings settings) throws IllegalArgumentException {
        ImagesServicePb.ImagesTransformRequest.Builder request = ImagesServicePb.ImagesTransformRequest.newBuilder().setImage(ImagesServiceImpl.convertImageData(image)).setOutput(this.convertOutputSettings(settings));
        transform.apply(request);
        if (request.getTransformCount() > 10) {
            throw new IllegalArgumentException("A maximum of 10 basic transforms can be requested in a single transform request");
        }
        return request;
    }

    private ImagesServicePb.OutputSettings convertOutputSettings(OutputSettings settings) {
        ImagesServicePb.OutputSettings.Builder pbSettings = ImagesServicePb.OutputSettings.newBuilder();
        switch (settings.getOutputEncoding()) {
            case PNG: {
                pbSettings.setMimeType(ImagesServicePb.OutputSettings.MIME_TYPE.PNG);
                break;
            }
            case JPEG: {
                pbSettings.setMimeType(ImagesServicePb.OutputSettings.MIME_TYPE.JPEG);
                int quality = settings.getQuality();
                if (quality < 1 || quality > 100) break;
                pbSettings.setQuality(quality);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid output encoding requested");
            }
        }
        return pbSettings.build();
    }

    private RuntimeException convertApplicationException(ImagesServicePb.ImagesTransformRequest.Builder request, ApiProxy.ApplicationException ex) {
        ImagesServicePb.ImagesServiceError.ErrorCode errorCode = ImagesServicePb.ImagesServiceError.ErrorCode.valueOf(ex.getApplicationError());
        if (errorCode != null && errorCode != ImagesServicePb.ImagesServiceError.ErrorCode.UNSPECIFIED_ERROR) {
            return new IllegalArgumentException(ex.getErrorDetail());
        }
        return new ImagesServiceFailureException(ex.getErrorDetail());
    }
}

