/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.api.datastore.TransactionStack;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import java.util.concurrent.Future;
import java.util.logging.Logger;

abstract class BaseDatastoreServiceImpl {
    static final long ARBITRARY_FAILOVER_READ_MS = -1L;
    final DatastoreServiceConfig datastoreServiceConfig;
    final ApiProxy.ApiConfig apiConfig;
    final TransactionStack defaultTxnProvider;
    final Logger logger = Logger.getLogger(this.getClass().getName());

    BaseDatastoreServiceImpl(DatastoreServiceConfig datastoreServiceConfig, TransactionStack defaultTxnProvider) {
        this.datastoreServiceConfig = datastoreServiceConfig;
        this.apiConfig = this.createApiConfig(datastoreServiceConfig);
        this.defaultTxnProvider = defaultTxnProvider;
    }

    private ApiProxy.ApiConfig createApiConfig(DatastoreServiceConfig config) {
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        apiConfig.setDeadlineInSeconds(config.getDeadline());
        return apiConfig;
    }

    GetOrCreateTransactionResult getOrCreateTransaction() {
        Transaction currentTxn = this.getCurrentTransaction(null);
        if (currentTxn != null) {
            return new GetOrCreateTransactionResult(false, currentTxn);
        }
        switch (this.datastoreServiceConfig.getImplicitTransactionManagementPolicy()) {
            case NONE: {
                return new GetOrCreateTransactionResult(false, null);
            }
            case AUTO: {
                return new GetOrCreateTransactionResult(true, this.beginTransactionInternal());
            }
        }
        String msg = "Unexpected Transaction Creation Policy: " + (Object)((Object)this.datastoreServiceConfig.getImplicitTransactionManagementPolicy());
        this.logger.severe(msg);
        throw new IllegalArgumentException(msg);
    }

    static DatastorePb.Transaction localTxnToRemoteTxn(Transaction local) {
        DatastorePb.Transaction remote = new DatastorePb.Transaction();
        remote.setApp(local.getApp());
        remote.setHandle(Long.parseLong(local.getId()));
        return remote;
    }

    Transaction beginTransactionInternal() {
        DatastorePb.Transaction remoteTxn = new DatastorePb.Transaction();
        DatastorePb.BeginTransactionRequest request = new DatastorePb.BeginTransactionRequest();
        request.setApp(DatastoreApiHelper.getCurrentAppId());
        Future<DatastorePb.Transaction> future = DatastoreApiHelper.makeAsyncCall(this.apiConfig, "BeginTransaction", request, remoteTxn);
        TransactionImpl localTxn = new TransactionImpl(this.apiConfig, request.getApp(), future, this.defaultTxnProvider);
        this.defaultTxnProvider.push(localTxn);
        return localTxn;
    }

    public Transaction getCurrentTransaction() {
        return this.defaultTxnProvider.peek();
    }

    public Transaction getCurrentTransaction(Transaction returnedIfNoTxn) {
        return this.defaultTxnProvider.peek(returnedIfNoTxn);
    }

    static final class GetOrCreateTransactionResult {
        private final boolean isNew;
        private final Transaction txn;

        GetOrCreateTransactionResult(boolean isNew, Transaction txn) {
            this.isNew = isNew;
            this.txn = txn;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public Transaction getTransaction() {
            return this.txn;
        }
    }
}

