/*
 * Decompiled with CFR 0.152.
 */
package edu.ufl.cise.klu.tdouble;

import edu.ufl.cise.klu.common.KLU_common;
import edu.ufl.cise.klu.common.KLU_numeric;
import edu.ufl.cise.klu.common.KLU_symbolic;
import edu.ufl.cise.klu.tdouble.Dklu_dump;
import edu.ufl.cise.klu.tdouble.Dklu_internal;
import edu.ufl.cise.klu.tdouble.Dklu_memory;
import edu.ufl.cise.klu.tdouble.Dklu_scale;

public class Dklu_refactor
extends Dklu_internal {
    public static int klu_refactor(int[] Ap, int[] Ai, double[] Ax, KLU_symbolic Symbolic, KLU_numeric Numeric, KLU_common Common) {
        int i;
        double ukk;
        double[] Li;
        double[] Lx;
        double ujk;
        int j;
        int up;
        double[] Ui;
        double[] Ux;
        double[] LU;
        int Ulen_offset;
        int[] Ulen;
        int Uip_offset;
        int[] Uip;
        int Llen_offset;
        int[] Llen;
        int Lip_offset;
        int[] Lip;
        int newrow;
        int p;
        double s;
        int pend;
        int oldcol;
        int nk;
        int k1;
        int k2;
        int block;
        int k;
        int[] ulen = new int[1];
        int[] Ui_offset = new int[1];
        int[] Ux_offset = new int[1];
        int[] llen = new int[1];
        int[] Li_offset = new int[1];
        int[] Lx_offset = new int[1];
        if (Common == null) {
            return 0;
        }
        Common.status = 0;
        if (Numeric == null) {
            Common.status = -3;
            return 0;
        }
        Common.numerical_rank = -1;
        Common.singular_col = -1;
        double[] Az = Ax;
        int n = Symbolic.n;
        int[] Q = Symbolic.Q;
        int[] R = Symbolic.R;
        int nblocks = Symbolic.nblocks;
        int maxblock = Symbolic.maxblock;
        int[] Pnum = Numeric.Pnum;
        int[] Offp = Numeric.Offp;
        int[] Offi = Numeric.Offi;
        double[] Offx = Numeric.Offx;
        double[][] LUbx = Numeric.LUbx;
        int scale = Common.scale;
        if (scale > 0) {
            if (Numeric.Rs == null) {
                Numeric.Rs = Dklu_memory.klu_malloc_dbl(n, Common);
                if (Common.status < 0) {
                    Common.status = -2;
                    return 0;
                }
            }
        } else {
            Numeric.Rs = null;
        }
        double[] Rs = Numeric.Rs;
        int[] Pinv = Numeric.Pinv;
        double[] X = Numeric.Xwork;
        Common.nrealloc = 0;
        double[] Udiag = Numeric.Udiag;
        int nzoff = Symbolic.nzoff;
        if (scale >= 0 && Dklu_scale.klu_scale(scale, n, Ap, Ai, Ax, Rs, null, Common) == 0) {
            return 0;
        }
        for (k = 0; k < maxblock; ++k) {
            Dklu_refactor.CLEAR(X, k);
        }
        int poff = 0;
        if (scale <= 0) {
            for (block = 0; block < nblocks; ++block) {
                k2 = R[block + 1];
                k1 = R[block];
                nk = k2 - k1;
                if (nk == 1) {
                    oldcol = Q[k1];
                    pend = Ap[oldcol + 1];
                    s = 0.0;
                    for (p = Ap[oldcol]; p < pend; ++p) {
                        newrow = Pinv[Ai[p]] - k1;
                        if (newrow < 0 && poff < nzoff) {
                            Offx[poff] = Az[p];
                            ++poff;
                            continue;
                        }
                        s = Az[p];
                    }
                    Udiag[k1] = s;
                    continue;
                }
                Lip = Numeric.Lip;
                Lip_offset = k1;
                Llen = Numeric.Llen;
                Llen_offset = k1;
                Uip = Numeric.Uip;
                Uip_offset = k1;
                Ulen = Numeric.Ulen;
                Ulen_offset = k1;
                LU = LUbx[block];
                for (k = 0; k < nk; ++k) {
                    oldcol = Q[k + k1];
                    pend = Ap[oldcol + 1];
                    for (p = Ap[oldcol]; p < pend; ++p) {
                        newrow = Pinv[Ai[p]] - k1;
                        if (newrow < 0 && poff < nzoff) {
                            Offx[poff] = Az[p];
                            ++poff;
                            continue;
                        }
                        X[newrow] = Az[p];
                    }
                    Ui = Ux = Dklu_refactor.GET_POINTER(LU, Uip, Uip_offset, Ulen, Ulen_offset, Ui_offset, Ux_offset, k, ulen);
                    for (up = 0; up < ulen[0]; ++up) {
                        j = (int)Ui[Ui_offset[0] + up];
                        ujk = X[j];
                        Dklu_refactor.CLEAR(X, j);
                        Ux[Ux_offset[0] + up] = ujk;
                        Li = Lx = Dklu_refactor.GET_POINTER(LU, Lip, Lip_offset, Llen, Llen_offset, Li_offset, Lx_offset, j, llen);
                        for (p = 0; p < llen[0]; ++p) {
                            int n2 = (int)Li[Li_offset[0] + p];
                            X[n2] = X[n2] - Lx[Lx_offset[0] + p] * ujk;
                        }
                    }
                    ukk = X[k];
                    Dklu_refactor.CLEAR(X, k);
                    if (Dklu_refactor.IS_ZERO(ukk)) {
                        Common.status = 1;
                        if (Common.numerical_rank == -1) {
                            Common.numerical_rank = k + k1;
                            Common.singular_col = Q[k + k1];
                        }
                        if (Common.halt_if_singular != 0) {
                            return 0;
                        }
                    }
                    Udiag[k + k1] = ukk;
                    Li = Lx = Dklu_refactor.GET_POINTER(LU, Lip, Lip_offset, Llen, Llen_offset, Li_offset, Lx_offset, k, llen);
                    for (p = 0; p < llen[0]; ++p) {
                        i = (int)Li[Li_offset[0] + p];
                        Lx[Lx_offset[0] + p] = X[i] / ukk;
                        Dklu_refactor.CLEAR(X, i);
                    }
                }
            }
        } else {
            for (block = 0; block < nblocks; ++block) {
                int oldrow;
                k2 = R[block + 1];
                k1 = R[block];
                nk = k2 - k1;
                if (nk == 1) {
                    oldcol = Q[k1];
                    pend = Ap[oldcol + 1];
                    s = 0.0;
                    for (p = Ap[oldcol]; p < pend; ++p) {
                        oldrow = Ai[p];
                        newrow = Pinv[oldrow] - k1;
                        if (newrow < 0 && poff < nzoff) {
                            Offx[poff] = Az[p] / Rs[oldrow];
                            ++poff;
                            continue;
                        }
                        s = Az[p] / Rs[oldrow];
                    }
                    Udiag[k1] = s;
                    continue;
                }
                Lip = Numeric.Lip;
                Lip_offset = k1;
                Llen = Numeric.Llen;
                Llen_offset = k1;
                Uip = Numeric.Uip;
                Uip_offset = k1;
                Ulen = Numeric.Ulen;
                Ulen_offset = k1;
                LU = LUbx[block];
                for (k = 0; k < nk; ++k) {
                    oldcol = Q[k + k1];
                    pend = Ap[oldcol + 1];
                    for (p = Ap[oldcol]; p < pend; ++p) {
                        oldrow = Ai[p];
                        newrow = Pinv[oldrow] - k1;
                        if (newrow < 0 && poff < nzoff) {
                            Offx[poff] = Az[p] / Rs[oldrow];
                            ++poff;
                            continue;
                        }
                        X[newrow] = Az[p] / Rs[oldrow];
                    }
                    Ui = Ux = Dklu_refactor.GET_POINTER(LU, Uip, Uip_offset, Ulen, Ulen_offset, Ui_offset, Ux_offset, k, ulen);
                    for (up = 0; up < ulen[0]; ++up) {
                        j = (int)Ui[Ui_offset[0] + up];
                        ujk = X[j];
                        Dklu_refactor.CLEAR(X, j);
                        Ux[Ux_offset[0] + up] = ujk;
                        Li = Lx = Dklu_refactor.GET_POINTER(LU, Lip, Lip_offset, Llen, Llen_offset, Li_offset, Lx_offset, j, llen);
                        for (p = 0; p < llen[0]; ++p) {
                            int n3 = (int)Li[Li_offset[0] + p];
                            X[n3] = X[n3] - Lx[Lx_offset[0] + p] * ujk;
                        }
                    }
                    ukk = X[k];
                    Dklu_refactor.CLEAR(X, k);
                    if (Dklu_refactor.IS_ZERO(ukk)) {
                        Common.status = 1;
                        if (Common.numerical_rank == -1) {
                            Common.numerical_rank = k + k1;
                            Common.singular_col = Q[k + k1];
                        }
                        if (Common.halt_if_singular != 0) {
                            return 0;
                        }
                    }
                    Udiag[k + k1] = ukk;
                    Li = Lx = Dklu_refactor.GET_POINTER(LU, Lip, Lip_offset, Llen, Llen_offset, Li_offset, Lx_offset, k, llen);
                    for (p = 0; p < llen[0]; ++p) {
                        i = (int)Li[Li_offset[0] + p];
                        Lx[Lx_offset[0] + p] = X[i] / ukk;
                        Dklu_refactor.CLEAR(X, i);
                    }
                }
            }
        }
        if (scale > 0) {
            for (k = 0; k < n; ++k) {
                X[k] = Rs[Pnum[k]];
            }
            for (k = 0; k < n; ++k) {
                Rs[k] = X[k];
            }
        }
        if (!NDEBUG) {
            Dklu_refactor.ASSERT(Offp[n] == poff);
            Dklu_refactor.ASSERT(Symbolic.nzoff == poff);
            Dklu_refactor.PRINTF("\n------------------- Off diagonal entries, new:\n", new Object[0]);
            if (!NDEBUG) {
                Dklu_refactor.ASSERT(Dklu_dump.klu_valid(n, Offp, Offi, Offx));
            }
            if (Common.status == 0) {
                Dklu_refactor.PRINTF("\n ########### KLU_BTF_REFACTOR done, nblocks %d\n", nblocks);
                for (block = 0; block < nblocks; ++block) {
                    k1 = R[block];
                    k2 = R[block + 1];
                    nk = k2 - k1;
                    Dklu_refactor.PRINTF("\n================KLU_refactor output: k1 %d k2 %d nk %d\n", k1, k2, nk);
                    if (nk == 1) {
                        Dklu_refactor.PRINTF("singleton  ", new Object[0]);
                        Dklu_refactor.PRINT_ENTRY(Udiag[k1]);
                        continue;
                    }
                    Lip = Numeric.Lip;
                    Lip_offset = k1;
                    Llen = Numeric.Llen;
                    Llen_offset = k1;
                    LU = Numeric.LUbx[block];
                    Dklu_refactor.PRINTF("\n---- L block %d\n", block);
                    if (!NDEBUG) {
                        Dklu_refactor.ASSERT(Dklu_dump.klu_valid_LU(nk, 1, Lip, Lip_offset, Llen, Llen_offset, LU));
                    }
                    Uip = Numeric.Uip;
                    Uip_offset = k1;
                    Ulen = Numeric.Ulen;
                    Ulen_offset = k1;
                    Dklu_refactor.PRINTF("\n---- U block %d\n", block);
                    if (NDEBUG) continue;
                    Dklu_refactor.ASSERT(Dklu_dump.klu_valid_LU(nk, 0, Uip, Uip_offset, Ulen, Ulen_offset, LU));
                }
            }
        }
        return 1;
    }
}

