/*
 * Decompiled with CFR 0.152.
 */
package edu.ufl.cise.klu.tdouble;

import edu.ufl.cise.btf.tdouble.Dbtf_strongcomp;
import edu.ufl.cise.klu.common.KLU_common;
import edu.ufl.cise.klu.common.KLU_symbolic;
import edu.ufl.cise.klu.tdouble.Dklu_internal;
import edu.ufl.cise.klu.tdouble.Dklu_memory;

public class Dklu_analyze_given
extends Dklu_internal {
    protected static KLU_symbolic klu_alloc_symbolic(int n, int[] Ap, int[] Ai, KLU_common Common) {
        KLU_symbolic Symbolic;
        int i;
        int j;
        if (Common == null) {
            return null;
        }
        Common.status = 0;
        if (n <= 0 || Ap == null || Ai == null) {
            Common.status = -3;
            return null;
        }
        int nz = Ap[n];
        if (Ap[0] != 0 || nz < 0) {
            Common.status = -3;
            return null;
        }
        for (j = 0; j < n; ++j) {
            if (Ap[j] <= Ap[j + 1]) continue;
            Common.status = -3;
            return null;
        }
        int[] P = Dklu_memory.klu_malloc_int(n, Common);
        if (Common.status < 0) {
            Common.status = -2;
            return null;
        }
        for (i = 0; i < n; ++i) {
            P[i] = -1;
        }
        for (j = 0; j < n; ++j) {
            int pend = Ap[j + 1];
            for (int p = Ap[j]; p < pend; ++p) {
                i = Ai[p];
                if (i < 0 || i >= n || P[i] == j) {
                    P = null;
                    Common.status = -3;
                    return null;
                }
                P[i] = j;
            }
        }
        try {
            Symbolic = new KLU_symbolic();
        }
        catch (OutOfMemoryError e) {
            P = null;
            Common.status = -2;
            return null;
        }
        int[] Q = Dklu_memory.klu_malloc_int(n, Common);
        int[] R = Dklu_memory.klu_malloc_int(n + 1, Common);
        double[] Lnz = Dklu_memory.klu_malloc_dbl(n, Common);
        Symbolic.n = n;
        Symbolic.nz = nz;
        Symbolic.P = P;
        Symbolic.Q = Q;
        Symbolic.R = R;
        Symbolic.Lnz = Lnz;
        if (Common.status < 0) {
            Symbolic = null;
            Common.status = -2;
            return null;
        }
        return Symbolic;
    }

    public static KLU_symbolic klu_analyze_given(int n, int[] Ap, int[] Ai, int[] Puser, int[] Quser, KLU_common Common) {
        int maxblock;
        int nzoff;
        int nblocks;
        int do_btf;
        int k;
        KLU_symbolic Symbolic = Dklu_analyze_given.klu_alloc_symbolic(n, Ap, Ai, Common);
        if (Symbolic == null) {
            return null;
        }
        int[] P = Symbolic.P;
        int[] Q = Symbolic.Q;
        int[] R = Symbolic.R;
        double[] Lnz = Symbolic.Lnz;
        int nz = Symbolic.nz;
        if (Quser == null) {
            for (k = 0; k < n; ++k) {
                Q[k] = k;
            }
        } else {
            for (k = 0; k < n; ++k) {
                Q[k] = Quser[k];
            }
        }
        do_btf = (do_btf = Common.btf) != 0 ? 1 : 0;
        Symbolic.ordering = 2;
        Symbolic.do_btf = do_btf;
        if (do_btf != 0) {
            int p;
            int[] Work = Dklu_memory.klu_malloc_int(4 * n, Common);
            int[] Pinv = Dklu_memory.klu_malloc_int(n, Common);
            int[] Bi = Puser != null ? Dklu_memory.klu_malloc_int(nz + 1, Common) : Ai;
            if (Common.status < 0) {
                Work = null;
                Pinv = null;
                if (Puser != null) {
                    Bi = null;
                }
                Symbolic = null;
                Common.status = -2;
                return null;
            }
            if (Puser != null) {
                for (k = 0; k < n; ++k) {
                    Pinv[Puser[k]] = k;
                }
                for (p = 0; p < nz; ++p) {
                    Bi[p] = Pinv[Ai[p]];
                }
            }
            nblocks = Dbtf_strongcomp.btf_strongcomp((int)n, (int[])Ap, (int[])Bi, (int[])Q, (int[])P, (int[])R);
            if (Puser != null) {
                for (k = 0; k < n; ++k) {
                    Work[k] = Puser[P[k]];
                }
                for (k = 0; k < n; ++k) {
                    P[k] = Work[k];
                }
            }
            for (k = 0; k < n; ++k) {
                Pinv[P[k]] = k;
            }
            nzoff = 0;
            maxblock = 1;
            for (int block = 0; block < nblocks; ++block) {
                int k1 = R[block];
                int k2 = R[block + 1];
                int nk = k2 - k1;
                Dklu_analyze_given.PRINTF("BLOCK %d, k1 %d k2-1 %d nk %d\n", block, k1, k2 - 1, nk);
                maxblock = Dklu_analyze_given.MAX(maxblock, nk);
                for (k = k1; k < k2; ++k) {
                    int oldcol = Q[k];
                    int pend = Ap[oldcol + 1];
                    for (p = Ap[oldcol]; p < pend; ++p) {
                        if (Pinv[Ai[p]] >= k1) continue;
                        ++nzoff;
                    }
                }
                Lnz[block] = -1.0;
            }
            Work = null;
            Pinv = null;
            if (Puser != null) {
                Bi = null;
            }
        } else {
            nzoff = 0;
            nblocks = 1;
            maxblock = n;
            R[0] = 0;
            R[1] = n;
            Lnz[0] = -1.0;
            for (k = 0; k < n; ++k) {
                P[k] = Puser == null ? k : Puser[k];
            }
        }
        Symbolic.nblocks = nblocks;
        Symbolic.maxblock = maxblock;
        Symbolic.lnz = -1.0;
        Symbolic.unz = -1.0;
        Symbolic.nzoff = nzoff;
        return Symbolic;
    }
}

