/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public interface Strings {
    public static final DecimalFormat decimalFormat = new DecimalFormat("#.######");

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String ordinal(int i) {
        String[] suffixes = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
        switch (i % 100) {
            case 11: 
            case 12: 
            case 13: {
                return i + "th";
            }
        }
        return i + suffixes[i % 10];
    }

    public static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        return Strings.fill(padChar, pads).concat(str);
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        return str.concat(Strings.fill(padChar, pads));
    }

    public static String fill(char ch, int len) {
        char[] chars = new char[len];
        Arrays.fill(chars, ch);
        return new String(chars);
    }

    public static String decimal(double x) {
        return decimalFormat.format(x);
    }

    public static String toString(int[] a) {
        return Arrays.stream(a).mapToObj(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
    }

    public static String toString(float[] a) {
        return IntStream.range(0, a.length).mapToObj(i -> String.valueOf(a[i])).collect(Collectors.joining(", ", "[", "]"));
    }

    public static String toString(double[] a) {
        return Arrays.stream(a).mapToObj(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
    }

    public static int[] parseIntArray(String s) {
        if (Strings.isNullOrEmpty(s)) {
            return null;
        }
        String[] tokens = s.trim().substring(1, s.length() - 1).split(",");
        return Arrays.stream(tokens).map(String::trim).mapToInt(Integer::parseInt).toArray();
    }

    public static double[] parseDoubleArray(String s) {
        if (Strings.isNullOrEmpty(s)) {
            return null;
        }
        String[] tokens = s.trim().substring(1, s.length() - 1).split(",");
        return Arrays.stream(tokens).map(String::trim).mapToDouble(Double::parseDouble).toArray();
    }
}

