/*
 * Decompiled with CFR 0.152.
 */
package smile.math.special;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.special.Gamma;

public class Beta {
    private static final Logger logger = LoggerFactory.getLogger(Beta.class);
    private static final double FPMIN = 1.0E-300;

    private Beta() {
    }

    public static double beta(double x, double y) {
        return Math.exp(Gamma.lgamma(x) + Gamma.lgamma(y) - Gamma.lgamma(x + y));
    }

    public static double regularizedIncompleteBetaFunction(double alpha, double beta, double x) {
        double EPS = 1.0E-8;
        if (Math.abs(x) < 1.0E-8) {
            return 0.0;
        }
        if (Math.abs(x - 1.0) < 1.0E-8) {
            return 1.0;
        }
        if (x < 0.0 || x > 1.0) {
            throw new IllegalArgumentException("Invalid x: " + x);
        }
        double ibeta = 0.0;
        if (x == 0.0) {
            ibeta = 0.0;
        } else if (x == 1.0) {
            ibeta = 1.0;
        } else {
            ibeta = Math.exp(Gamma.lgamma(alpha + beta) - Gamma.lgamma(alpha) - Gamma.lgamma(beta) + alpha * Math.log(x) + beta * Math.log(1.0 - x));
            ibeta = x < (alpha + 1.0) / (alpha + beta + 2.0) ? ibeta * Beta.incompleteFractionSummation(alpha, beta, x) / alpha : 1.0 - ibeta * Beta.incompleteFractionSummation(beta, alpha, 1.0 - x) / beta;
        }
        return ibeta;
    }

    private static double incompleteFractionSummation(double alpha, double beta, double x) {
        int MAXITER = 500;
        double EPS = 3.0E-7;
        double aplusb = alpha + beta;
        double aplus1 = alpha + 1.0;
        double aminus1 = alpha - 1.0;
        double c = 1.0;
        double d = 1.0 - aplusb * x / aplus1;
        if (Math.abs(d) < 1.0E-300) {
            d = 1.0E-300;
        }
        double h = d = 1.0 / d;
        double aa = 0.0;
        double del = 0.0;
        int i = 1;
        int i2 = 0;
        boolean test = true;
        while (test) {
            i2 = 2 * i;
            aa = (double)i * (beta - (double)i) * x / ((aminus1 + (double)i2) * (alpha + (double)i2));
            if (Math.abs(d = 1.0 + aa * d) < 1.0E-300) {
                d = 1.0E-300;
            }
            if (Math.abs(c = 1.0 + aa / c) < 1.0E-300) {
                c = 1.0E-300;
            }
            d = 1.0 / d;
            h *= d * c;
            aa = -(alpha + (double)i) * (aplusb + (double)i) * x / ((alpha + (double)i2) * (aplus1 + (double)i2));
            if (Math.abs(d = 1.0 + aa * d) < 1.0E-300) {
                d = 1.0E-300;
            }
            if (Math.abs(c = 1.0 + aa / c) < 1.0E-300) {
                c = 1.0E-300;
            }
            d = 1.0 / d;
            del = d * c;
            h *= del;
            ++i;
            if (Math.abs(del - 1.0) < 3.0E-7) {
                test = false;
            }
            if (i <= 500) continue;
            test = false;
            logger.error("Beta.incompleteFractionSummation: Maximum number of iterations wes exceeded");
        }
        return h;
    }

    public static double inverseRegularizedIncompleteBetaFunction(double alpha, double beta, double p) {
        double u;
        double w;
        double x;
        double t2;
        double EPS = 1.0E-8;
        double a1 = alpha - 1.0;
        double b1 = beta - 1.0;
        if (p <= 0.0) {
            return 0.0;
        }
        if (p >= 1.0) {
            return 1.0;
        }
        if (alpha >= 1.0 && beta >= 1.0) {
            double pp = p < 0.5 ? p : 1.0 - p;
            t2 = Math.sqrt(-2.0 * Math.log(pp));
            x = (2.30753 + t2 * 0.27061) / (1.0 + t2 * (0.99229 + t2 * 0.04481)) - t2;
            if (p < 0.5) {
                x = -x;
            }
            double al = (x * x - 3.0) / 6.0;
            double h = 2.0 / (1.0 / (2.0 * alpha - 1.0) + 1.0 / (2.0 * beta - 1.0));
            w = x * Math.sqrt(al + h) / h - (1.0 / (2.0 * beta - 1.0) - 1.0 / (2.0 * alpha - 1.0)) * (al + 0.8333333333333334 - 2.0 / (3.0 * h));
            x = alpha / (alpha + beta * Math.exp(2.0 * w));
        } else {
            double lna = Math.log(alpha / (alpha + beta));
            double lnb = Math.log(beta / (alpha + beta));
            t2 = Math.exp(alpha * lna) / alpha;
            x = p < t2 / (w = t2 + (u = Math.exp(beta * lnb) / beta)) ? Math.pow(alpha * w * p, 1.0 / alpha) : 1.0 - Math.pow(beta * w * (1.0 - p), 1.0 / beta);
        }
        double afac = -Gamma.lgamma(alpha) - Gamma.lgamma(beta) + Gamma.lgamma(alpha + beta);
        for (int j = 0; j < 10; ++j) {
            if (x == 0.0 || x == 1.0) {
                return x;
            }
            double err = Beta.regularizedIncompleteBetaFunction(alpha, beta, x) - p;
            t2 = Math.exp(a1 * Math.log(x) + b1 * Math.log(1.0 - x) + afac);
            u = err / t2;
            if ((x -= (t2 = u / (1.0 - 0.5 * Math.min(1.0, u * (a1 / x - b1 / (1.0 - x)))))) <= 0.0) {
                x = 0.5 * (x + t2);
            }
            if (x >= 1.0) {
                x = 0.5 * (x + t2 + 1.0);
            }
            if (Math.abs(t2) < 1.0E-8 * x && j > 0) break;
        }
        return x;
    }
}

