/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import java.util.Arrays;
import smile.math.Math;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.RowMajorMatrix;
import smile.stat.distribution.GaussianDistribution;

public class ColumnMajorMatrix
implements DenseMatrix {
    private double[] A;
    private int nrows;
    private int ncols;

    public ColumnMajorMatrix(double[][] A) {
        this.nrows = A.length;
        this.ncols = A[0].length;
        this.A = new double[this.nrows * this.ncols];
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                this.set(i, j, A[i][j]);
            }
        }
    }

    public ColumnMajorMatrix(int rows, int cols) {
        this.nrows = rows;
        this.ncols = cols;
        this.A = new double[rows * cols];
    }

    public ColumnMajorMatrix(int rows, int cols, double value) {
        this(rows, cols);
        Arrays.fill(this.A, value);
    }

    public ColumnMajorMatrix(int rows, int cols, double[] value) {
        this.nrows = rows;
        this.ncols = cols;
        this.A = value;
    }

    public ColumnMajorMatrix(double[] diag) {
        this(diag.length, diag.length);
        for (int i = 0; i < diag.length; ++i) {
            this.set(i, i, diag[i]);
        }
    }

    public ColumnMajorMatrix(int rows, int cols, double mu, double sigma) {
        this(rows, cols);
        GaussianDistribution g = new GaussianDistribution(mu, sigma);
        int n = rows * cols;
        for (int i = 0; i < n; ++i) {
            this.A[i] = g.rand();
        }
    }

    public static ColumnMajorMatrix eye(int n) {
        return ColumnMajorMatrix.eye(n, n);
    }

    public static ColumnMajorMatrix eye(int m, int n) {
        ColumnMajorMatrix matrix = new ColumnMajorMatrix(m, n);
        int l = Math.min(m, n);
        for (int i = 0; i < l; ++i) {
            matrix.set(i, i, 1.0);
        }
        return matrix;
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public ColumnMajorMatrix copy() {
        return new ColumnMajorMatrix(this.nrows, this.ncols, (double[])this.A.clone());
    }

    @Override
    public RowMajorMatrix transpose() {
        return new RowMajorMatrix(this.ncols, this.nrows, this.A);
    }

    @Override
    public int nrows() {
        return this.nrows;
    }

    @Override
    public int ncols() {
        return this.ncols;
    }

    @Override
    public double get(int i, int j) {
        return this.A[j * this.nrows + i];
    }

    @Override
    public double set(int i, int j, double x) {
        double d = x;
        this.A[j * this.nrows + i] = d;
        return d;
    }

    @Override
    public double add(int i, int j, double x) {
        int n = j * this.nrows + i;
        double d = this.A[n] + x;
        this.A[n] = d;
        return d;
    }

    @Override
    public double sub(int i, int j, double x) {
        int n = j * this.nrows + i;
        double d = this.A[n] - x;
        this.A[n] = d;
        return d;
    }

    @Override
    public double mul(int i, int j, double x) {
        int n = j * this.nrows + i;
        double d = this.A[n] * x;
        this.A[n] = d;
        return d;
    }

    @Override
    public double div(int i, int j, double x) {
        int n = j * this.nrows + i;
        double d = this.A[n] / x;
        this.A[n] = d;
        return d;
    }

    @Override
    public ColumnMajorMatrix add(DenseMatrix b) {
        if (b instanceof ColumnMajorMatrix) {
            return this.add((ColumnMajorMatrix)b);
        }
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                this.add(i, j, b.get(i, j));
            }
        }
        return this;
    }

    public ColumnMajorMatrix add(ColumnMajorMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] + b.A[i];
        }
        return this;
    }

    @Override
    public DenseMatrix add(DenseMatrix b, DenseMatrix c) {
        if (b instanceof ColumnMajorMatrix && c instanceof ColumnMajorMatrix) {
            return this.add((ColumnMajorMatrix)b, (ColumnMajorMatrix)c);
        }
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                c.set(i, j, this.get(i, j) + b.get(i, j));
            }
        }
        return c;
    }

    public ColumnMajorMatrix add(ColumnMajorMatrix b, ColumnMajorMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            c.A[i] = this.A[i] + b.A[i];
        }
        return c;
    }

    @Override
    public ColumnMajorMatrix sub(DenseMatrix b) {
        if (b instanceof ColumnMajorMatrix) {
            return this.sub((ColumnMajorMatrix)b);
        }
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                this.sub(i, j, b.get(i, j));
            }
        }
        return this;
    }

    public ColumnMajorMatrix sub(ColumnMajorMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] - b.A[i];
        }
        return this;
    }

    @Override
    public DenseMatrix sub(DenseMatrix b, DenseMatrix c) {
        if (b instanceof ColumnMajorMatrix && c instanceof ColumnMajorMatrix) {
            return this.sub((ColumnMajorMatrix)b, (ColumnMajorMatrix)c);
        }
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                c.set(i, j, this.get(i, j) - b.get(i, j));
            }
        }
        return c;
    }

    public ColumnMajorMatrix sub(ColumnMajorMatrix b, ColumnMajorMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            c.A[i] = this.A[i] - b.A[i];
        }
        return c;
    }

    @Override
    public ColumnMajorMatrix mul(DenseMatrix b) {
        if (b instanceof ColumnMajorMatrix) {
            return this.mul((ColumnMajorMatrix)b);
        }
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                this.mul(i, j, b.get(i, j));
            }
        }
        return this;
    }

    public ColumnMajorMatrix mul(ColumnMajorMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] * b.A[i];
        }
        return this;
    }

    @Override
    public DenseMatrix mul(DenseMatrix b, DenseMatrix c) {
        if (b instanceof ColumnMajorMatrix && c instanceof ColumnMajorMatrix) {
            return this.mul((ColumnMajorMatrix)b, (ColumnMajorMatrix)c);
        }
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                c.set(i, j, this.get(i, j) * b.get(i, j));
            }
        }
        return c;
    }

    public ColumnMajorMatrix mul(ColumnMajorMatrix b, ColumnMajorMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            c.A[i] = this.A[i] * b.A[i];
        }
        return c;
    }

    @Override
    public ColumnMajorMatrix div(DenseMatrix b) {
        if (b instanceof ColumnMajorMatrix) {
            return this.div((ColumnMajorMatrix)b);
        }
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                this.div(i, j, b.get(i, j));
            }
        }
        return this;
    }

    public ColumnMajorMatrix div(ColumnMajorMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] / b.A[i];
        }
        return this;
    }

    @Override
    public DenseMatrix div(DenseMatrix b, DenseMatrix c) {
        if (b instanceof ColumnMajorMatrix && c instanceof ColumnMajorMatrix) {
            return this.div((ColumnMajorMatrix)b, (ColumnMajorMatrix)c);
        }
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                c.set(i, j, this.get(i, j) / b.get(i, j));
            }
        }
        return c;
    }

    public ColumnMajorMatrix div(ColumnMajorMatrix b, ColumnMajorMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            c.A[i] = this.A[i] / b.A[i];
        }
        return c;
    }

    @Override
    public ColumnMajorMatrix add(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] + x;
        }
        return this;
    }

    @Override
    public DenseMatrix add(double x, DenseMatrix c) {
        if (c instanceof ColumnMajorMatrix) {
            return this.add(x, (ColumnMajorMatrix)c);
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int j = 0; j < this.ncols; ++j) {
            for (int i = 0; i < this.nrows; ++i) {
                c.set(i, j, this.get(i, j) + x);
            }
        }
        return c;
    }

    public ColumnMajorMatrix add(double x, ColumnMajorMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            c.A[i] = this.A[i] + x;
        }
        return c;
    }

    @Override
    public ColumnMajorMatrix sub(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] - x;
        }
        return this;
    }

    @Override
    public DenseMatrix sub(double x, DenseMatrix c) {
        if (c instanceof ColumnMajorMatrix) {
            return this.sub(x, (ColumnMajorMatrix)c);
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int j = 0; j < this.ncols; ++j) {
            for (int i = 0; i < this.nrows; ++i) {
                c.set(i, j, this.get(i, j) - x);
            }
        }
        return c;
    }

    public ColumnMajorMatrix sub(double x, ColumnMajorMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            c.A[i] = this.A[i] - x;
        }
        return c;
    }

    @Override
    public ColumnMajorMatrix mul(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] * x;
        }
        return this;
    }

    @Override
    public DenseMatrix mul(double x, DenseMatrix c) {
        if (c instanceof ColumnMajorMatrix) {
            return this.mul(x, (ColumnMajorMatrix)c);
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int j = 0; j < this.ncols; ++j) {
            for (int i = 0; i < this.nrows; ++i) {
                c.set(i, j, this.get(i, j) * x);
            }
        }
        return c;
    }

    public ColumnMajorMatrix mul(double x, ColumnMajorMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            c.A[i] = this.A[i] * x;
        }
        return c;
    }

    @Override
    public ColumnMajorMatrix div(double x) {
        int i = 0;
        while (i < this.A.length) {
            int n = i++;
            this.A[n] = this.A[n] / x;
        }
        return this;
    }

    @Override
    public DenseMatrix div(double x, DenseMatrix c) {
        if (c instanceof ColumnMajorMatrix) {
            return this.div(x, (ColumnMajorMatrix)c);
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int j = 0; j < this.ncols; ++j) {
            for (int i = 0; i < this.nrows; ++i) {
                c.set(i, j, this.get(i, j) / x);
            }
        }
        return c;
    }

    public ColumnMajorMatrix div(double x, ColumnMajorMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            c.A[i] = this.A[i] / x;
        }
        return c;
    }

    @Override
    public ColumnMajorMatrix replaceNaN(double x) {
        for (int i = 0; i < this.A.length; ++i) {
            if (!Double.isNaN(this.A[i])) continue;
            this.A[i] = x;
        }
        return this;
    }

    @Override
    public double sum() {
        double s = 0.0;
        for (int i = 0; i < this.A.length; ++i) {
            s += this.A[i];
        }
        return s;
    }

    @Override
    public ColumnMajorMatrix ata() {
        ColumnMajorMatrix C = new ColumnMajorMatrix(this.ncols, this.ncols);
        for (int i = 0; i < this.ncols; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                double v = 0.0;
                for (int k = 0; k < this.nrows; ++k) {
                    v += this.get(k, i) * this.get(k, j);
                }
                C.set(i, j, v);
            }
        }
        return C;
    }

    @Override
    public ColumnMajorMatrix aat() {
        ColumnMajorMatrix C = new ColumnMajorMatrix(this.nrows, this.nrows);
        for (int k = 0; k < this.ncols; ++k) {
            for (int i = 0; i < this.nrows; ++i) {
                for (int j = 0; j < this.nrows; ++j) {
                    C.add(i, j, this.get(i, k) * this.get(j, k));
                }
            }
        }
        return C;
    }

    @Override
    public double[] ax(double[] x, double[] y) {
        int n = Math.min(this.nrows, y.length);
        int p = Math.min(this.ncols, x.length);
        Arrays.fill(y, 0.0);
        for (int k = 0; k < p; ++k) {
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                y[n2] = y[n2] + this.get(i, k) * x[k];
            }
        }
        return y;
    }

    @Override
    public double[] axpy(double[] x, double[] y) {
        int n = Math.min(this.nrows, y.length);
        int p = Math.min(this.ncols, x.length);
        for (int k = 0; k < p; ++k) {
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                y[n2] = y[n2] + this.get(i, k) * x[k];
            }
        }
        return y;
    }

    @Override
    public double[] axpy(double[] x, double[] y, double b) {
        int n = Math.min(this.nrows, y.length);
        int p = Math.min(this.ncols, x.length);
        int i = 0;
        while (i < n) {
            int n2 = i++;
            y[n2] = y[n2] * b;
        }
        for (int k = 0; k < p; ++k) {
            for (int i2 = 0; i2 < n; ++i2) {
                int n3 = i2;
                y[n3] = y[n3] + this.get(i2, k) * x[k];
            }
        }
        return y;
    }

    @Override
    public double[] atx(double[] x, double[] y) {
        int n = Math.min(this.ncols, y.length);
        int p = Math.min(this.nrows, x.length);
        Arrays.fill(y, 0.0);
        for (int i = 0; i < n; ++i) {
            for (int k = 0; k < p; ++k) {
                int n2 = i;
                y[n2] = y[n2] + this.get(k, i) * x[k];
            }
        }
        return y;
    }

    @Override
    public double[] atxpy(double[] x, double[] y) {
        int n = Math.min(this.ncols, y.length);
        int p = Math.min(this.nrows, x.length);
        for (int i = 0; i < n; ++i) {
            for (int k = 0; k < p; ++k) {
                int n2 = i;
                y[n2] = y[n2] + this.get(k, i) * x[k];
            }
        }
        return y;
    }

    @Override
    public double[] atxpy(double[] x, double[] y, double b) {
        int n = Math.min(this.ncols, y.length);
        int p = Math.min(this.nrows, x.length);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            y[n2] = y[n2] * b;
            for (int k = 0; k < p; ++k) {
                int n3 = i;
                y[n3] = y[n3] + this.get(k, i) * x[k];
            }
        }
        return y;
    }

    @Override
    public ColumnMajorMatrix abmm(DenseMatrix B) {
        if (this.ncols() != B.nrows()) {
            throw new IllegalArgumentException(String.format("Matrix multiplication A * B: %d x %d vs %d x %d", this.nrows(), this.ncols(), B.nrows(), B.ncols()));
        }
        ColumnMajorMatrix C = new ColumnMajorMatrix(this.nrows, B.ncols());
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < B.ncols(); ++j) {
                double v = 0.0;
                for (int k = 0; k < this.ncols; ++k) {
                    v += this.get(i, k) * B.get(k, j);
                }
                C.set(i, j, v);
            }
        }
        return C;
    }

    @Override
    public ColumnMajorMatrix abtmm(DenseMatrix B) {
        if (this.ncols() != B.ncols()) {
            throw new IllegalArgumentException(String.format("Matrix multiplication A * B': %d x %d vs %d x %d", this.nrows(), this.ncols(), B.nrows(), B.ncols()));
        }
        ColumnMajorMatrix C = new ColumnMajorMatrix(this.nrows, B.nrows());
        for (int k = 0; k < this.ncols; ++k) {
            for (int i = 0; i < this.nrows; ++i) {
                for (int j = 0; j < B.nrows(); ++j) {
                    C.add(i, j, this.get(i, k) * B.get(j, k));
                }
            }
        }
        return C;
    }

    @Override
    public ColumnMajorMatrix atbmm(DenseMatrix B) {
        if (this.nrows() != B.nrows()) {
            throw new IllegalArgumentException(String.format("Matrix multiplication A' * B: %d x %d vs %d x %d", this.nrows(), this.ncols(), B.nrows(), B.ncols()));
        }
        ColumnMajorMatrix C = new ColumnMajorMatrix(this.ncols, B.ncols());
        for (int i = 0; i < this.ncols; ++i) {
            for (int j = 0; j < B.ncols(); ++j) {
                double v = 0.0;
                for (int k = 0; k < this.nrows; ++k) {
                    v += this.get(k, i) * B.get(k, j);
                }
                C.set(i, j, v);
            }
        }
        return C;
    }
}

