/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import smile.data.Tuple;
import smile.data.formula.Term;
import smile.data.measure.Measure;
import smile.data.type.DataType;
import smile.data.type.StructField;
import smile.data.type.StructType;

final class Variable
implements Term {
    private final String name;
    private DataType type;
    private Measure measure;
    private int index = -1;

    public Variable(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean isVariable() {
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Variable) {
            return this.name.equals(((Variable)o).name);
        }
        return false;
    }

    @Override
    public Set<String> variables() {
        return Collections.singleton(this.name);
    }

    @Override
    public Object apply(Tuple o) {
        return o.get(this.index);
    }

    @Override
    public int applyAsInt(Tuple o) {
        return o.getInt(this.index);
    }

    @Override
    public long applyAsLong(Tuple o) {
        return o.getLong(this.index);
    }

    @Override
    public float applyAsFloat(Tuple o) {
        return o.getFloat(this.index);
    }

    @Override
    public double applyAsDouble(Tuple o) {
        return o.getDouble(this.index);
    }

    @Override
    public DataType type() {
        if (this.type == null) {
            throw new IllegalStateException(String.format("Column(%s) is not bound to a schema yet.", this.name));
        }
        return this.type;
    }

    @Override
    public Optional<Measure> measure() {
        return Optional.ofNullable(this.measure);
    }

    @Override
    public void bind(StructType schema) {
        this.index = schema.fieldIndex(this.name);
        StructField field = schema.field(this.index);
        this.type = field.type;
        this.measure = field.measure;
    }
}

