/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import smile.data.Tuple;
import smile.data.formula.Abs;
import smile.data.formula.AbstractBiFunction;
import smile.data.formula.AbstractFunction;
import smile.data.formula.Add;
import smile.data.formula.All;
import smile.data.formula.Constant;
import smile.data.formula.Date;
import smile.data.formula.DateFeature;
import smile.data.formula.Delete;
import smile.data.formula.Div;
import smile.data.formula.DoubleFunction;
import smile.data.formula.FactorCrossing;
import smile.data.formula.FactorInteraction;
import smile.data.formula.IntFunction;
import smile.data.formula.Mul;
import smile.data.formula.OneHot;
import smile.data.formula.Round;
import smile.data.formula.Sub;
import smile.data.formula.Term;
import smile.data.formula.Variable;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.math.MathEx;

public interface Terms {
    public static Variable $(String x) {
        return new Variable(x);
    }

    public static All all() {
        return new All();
    }

    public static FactorInteraction interact(String ... factors) {
        return new FactorInteraction(factors);
    }

    public static FactorCrossing cross(String ... factors) {
        return new FactorCrossing(factors);
    }

    public static FactorCrossing cross(int order, String ... factors) {
        return new FactorCrossing(order, factors);
    }

    public static Delete delete(String x) {
        return Terms.delete(Terms.$(x));
    }

    public static Delete delete(Term x) {
        return new Delete(x);
    }

    public static OneHot onehot(String ... factors) {
        return new OneHot(factors);
    }

    public static Date date(String x, DateFeature ... features) {
        return new Date(x, features);
    }

    public static Term add(Term a, Term b) {
        return new Add(a, b);
    }

    public static Term add(String a, String b) {
        return new Add(Terms.$(a), Terms.$(b));
    }

    public static Term add(Term a, String b) {
        return new Add(a, Terms.$(b));
    }

    public static Term add(String a, Term b) {
        return new Add(Terms.$(a), b);
    }

    public static Term sub(Term a, Term b) {
        return new Sub(a, b);
    }

    public static Term sub(String a, String b) {
        return new Sub(Terms.$(a), Terms.$(b));
    }

    public static Term sub(Term a, String b) {
        return new Sub(a, Terms.$(b));
    }

    public static Term sub(String a, Term b) {
        return new Sub(Terms.$(a), b);
    }

    public static Term mul(Term a, Term b) {
        return new Mul(a, b);
    }

    public static Term mul(String a, String b) {
        return new Mul(Terms.$(a), Terms.$(b));
    }

    public static Term mul(Term a, String b) {
        return new Mul(a, Terms.$(b));
    }

    public static Term mul(String a, Term b) {
        return new Mul(Terms.$(a), b);
    }

    public static Term div(Term a, Term b) {
        return new Div(a, b);
    }

    public static Term div(String a, String b) {
        return new Div(Terms.$(a), Terms.$(b));
    }

    public static Term div(Term a, String b) {
        return new Div(a, Terms.$(b));
    }

    public static Term div(String a, Term b) {
        return new Div(Terms.$(a), b);
    }

    public static Abs abs(String x) {
        return Terms.abs(Terms.$(x));
    }

    public static Abs abs(Term x) {
        return new Abs(x);
    }

    public static DoubleFunction ceil(String x) {
        return Terms.ceil(Terms.$(x));
    }

    public static DoubleFunction ceil(Term x) {
        return new DoubleFunction("ceil", x, Math::ceil);
    }

    public static DoubleFunction floor(String x) {
        return Terms.floor(Terms.$(x));
    }

    public static DoubleFunction floor(Term x) {
        return new DoubleFunction("floor", x, Math::floor);
    }

    public static Round round(String x) {
        return Terms.round(Terms.$(x));
    }

    public static Round round(Term x) {
        return new Round(x);
    }

    public static DoubleFunction rint(String x) {
        return Terms.rint(Terms.$(x));
    }

    public static DoubleFunction rint(Term x) {
        return new DoubleFunction("rint", x, Math::rint);
    }

    public static DoubleFunction exp(String x) {
        return Terms.exp(Terms.$(x));
    }

    public static DoubleFunction exp(Term x) {
        return new DoubleFunction("exp", x, Math::exp);
    }

    public static DoubleFunction expm1(String x) {
        return Terms.expm1(Terms.$(x));
    }

    public static DoubleFunction expm1(Term x) {
        return new DoubleFunction("expm1", x, Math::expm1);
    }

    public static DoubleFunction log(String x) {
        return Terms.log(Terms.$(x));
    }

    public static DoubleFunction log(Term x) {
        return new DoubleFunction("log", x, Math::log);
    }

    public static DoubleFunction log1p(String x) {
        return Terms.log1p(Terms.$(x));
    }

    public static DoubleFunction log1p(Term x) {
        return new DoubleFunction("log1p", x, Math::log1p);
    }

    public static DoubleFunction log10(String x) {
        return Terms.log10(Terms.$(x));
    }

    public static DoubleFunction log10(Term x) {
        return new DoubleFunction("log10", x, Math::log10);
    }

    public static DoubleFunction log2(String x) {
        return Terms.log2(Terms.$(x));
    }

    public static DoubleFunction log2(Term x) {
        return new DoubleFunction("log2", x, MathEx::log2);
    }

    public static DoubleFunction signum(String x) {
        return Terms.signum(Terms.$(x));
    }

    public static DoubleFunction signum(Term x) {
        return new DoubleFunction("signum", x, Math::signum);
    }

    public static IntFunction sign(String x) {
        return Terms.sign(Terms.$(x));
    }

    public static IntFunction sign(Term x) {
        return new IntFunction("sign", x, Integer::signum);
    }

    public static DoubleFunction sqrt(String x) {
        return Terms.sqrt(Terms.$(x));
    }

    public static DoubleFunction sqrt(Term x) {
        return new DoubleFunction("sqrt", x, Math::sqrt);
    }

    public static DoubleFunction cbrt(String x) {
        return Terms.cbrt(Terms.$(x));
    }

    public static DoubleFunction cbrt(Term x) {
        return new DoubleFunction("cbrt", x, Math::cbrt);
    }

    public static DoubleFunction sin(String x) {
        return Terms.sin(Terms.$(x));
    }

    public static DoubleFunction sin(Term x) {
        return new DoubleFunction("sin", x, Math::sin);
    }

    public static DoubleFunction cos(String x) {
        return Terms.cos(Terms.$(x));
    }

    public static DoubleFunction cos(Term x) {
        return new DoubleFunction("cos", x, Math::cos);
    }

    public static DoubleFunction tan(String x) {
        return Terms.tan(Terms.$(x));
    }

    public static DoubleFunction tan(Term x) {
        return new DoubleFunction("tan", x, Math::tan);
    }

    public static DoubleFunction sinh(String x) {
        return Terms.sinh(Terms.$(x));
    }

    public static DoubleFunction sinh(Term x) {
        return new DoubleFunction("sinh", x, Math::sinh);
    }

    public static DoubleFunction cosh(String x) {
        return Terms.cosh(Terms.$(x));
    }

    public static DoubleFunction cosh(Term x) {
        return new DoubleFunction("cosh", x, Math::cosh);
    }

    public static DoubleFunction tanh(String x) {
        return Terms.tanh(Terms.$(x));
    }

    public static DoubleFunction tanh(Term x) {
        return new DoubleFunction("tanh", x, Math::tanh);
    }

    public static DoubleFunction asin(String x) {
        return Terms.asin(Terms.$(x));
    }

    public static DoubleFunction asin(Term x) {
        return new DoubleFunction("asin", x, Math::asin);
    }

    public static DoubleFunction acos(String x) {
        return Terms.acos(Terms.$(x));
    }

    public static DoubleFunction acos(Term x) {
        return new DoubleFunction("acos", x, Math::acos);
    }

    public static DoubleFunction atan(String x) {
        return Terms.atan(Terms.$(x));
    }

    public static DoubleFunction atan(Term x) {
        return new DoubleFunction("atan", x, Math::acos);
    }

    public static DoubleFunction ulp(String x) {
        return Terms.ulp(Terms.$(x));
    }

    public static DoubleFunction ulp(Term x) {
        return new DoubleFunction("ulp", x, Math::ulp);
    }

    public static Term val(final boolean x) {
        return new Constant(){

            public String toString() {
                return this.name();
            }

            @Override
            public String name() {
                return String.valueOf(x);
            }

            @Override
            public DataType type() {
                return DataTypes.BooleanType;
            }

            @Override
            public Object apply(Tuple o) {
                return x;
            }
        };
    }

    public static Term val(final char x) {
        return new Constant(){

            public String toString() {
                return this.name();
            }

            @Override
            public String name() {
                return String.valueOf(x);
            }

            @Override
            public DataType type() {
                return DataTypes.CharType;
            }

            @Override
            public int applyAsInt(Tuple o) {
                return x;
            }

            @Override
            public long applyAsLong(Tuple o) {
                return x;
            }

            @Override
            public double applyAsDouble(Tuple o) {
                return x;
            }

            @Override
            public Object apply(Tuple o) {
                return Character.valueOf(x);
            }
        };
    }

    public static Term val(final byte x) {
        return new Constant(){

            public String toString() {
                return this.name();
            }

            @Override
            public String name() {
                return String.valueOf(x);
            }

            @Override
            public DataType type() {
                return DataTypes.ByteType;
            }

            @Override
            public int applyAsInt(Tuple o) {
                return x;
            }

            @Override
            public long applyAsLong(Tuple o) {
                return x;
            }

            @Override
            public double applyAsDouble(Tuple o) {
                return x;
            }

            @Override
            public Object apply(Tuple o) {
                return x;
            }
        };
    }

    public static Term val(final short x) {
        return new Constant(){

            public String toString() {
                return this.name();
            }

            @Override
            public String name() {
                return String.valueOf(x);
            }

            @Override
            public DataType type() {
                return DataTypes.ShortType;
            }

            @Override
            public int applyAsInt(Tuple o) {
                return x;
            }

            @Override
            public long applyAsLong(Tuple o) {
                return x;
            }

            @Override
            public double applyAsDouble(Tuple o) {
                return x;
            }

            @Override
            public Object apply(Tuple o) {
                return x;
            }
        };
    }

    public static Term val(final int x) {
        return new Constant(){

            public String toString() {
                return this.name();
            }

            @Override
            public String name() {
                return String.valueOf(x);
            }

            @Override
            public DataType type() {
                return DataTypes.IntegerType;
            }

            @Override
            public int applyAsInt(Tuple o) {
                return x;
            }

            @Override
            public long applyAsLong(Tuple o) {
                return x;
            }

            @Override
            public double applyAsDouble(Tuple o) {
                return x;
            }

            @Override
            public Object apply(Tuple o) {
                return x;
            }
        };
    }

    public static Term val(final long x) {
        return new Constant(){

            public String toString() {
                return this.name();
            }

            @Override
            public String name() {
                return String.valueOf(x);
            }

            @Override
            public DataType type() {
                return DataTypes.LongType;
            }

            @Override
            public long applyAsLong(Tuple o) {
                return x;
            }

            @Override
            public double applyAsDouble(Tuple o) {
                return x;
            }

            @Override
            public Object apply(Tuple o) {
                return x;
            }
        };
    }

    public static Term val(final float x) {
        return new Constant(){

            public String toString() {
                return this.name();
            }

            @Override
            public String name() {
                return String.valueOf(x);
            }

            @Override
            public DataType type() {
                return DataTypes.FloatType;
            }

            @Override
            public float applyAsFloat(Tuple o) {
                return x;
            }

            @Override
            public double applyAsDouble(Tuple o) {
                return x;
            }

            @Override
            public Object apply(Tuple o) {
                return Float.valueOf(x);
            }
        };
    }

    public static Term val(final double x) {
        return new Constant(){

            public String toString() {
                return this.name();
            }

            @Override
            public String name() {
                return String.valueOf(x);
            }

            @Override
            public DataType type() {
                return DataTypes.DoubleType;
            }

            @Override
            public double applyAsDouble(Tuple o) {
                return x;
            }

            @Override
            public Object apply(Tuple o) {
                return x;
            }
        };
    }

    public static Term val(final Object x) {
        final DataType type = DataType.of(x.getClass());
        return new Constant(){

            public String toString() {
                return this.name();
            }

            @Override
            public String name() {
                return x.toString();
            }

            @Override
            public DataType type() {
                return type;
            }

            @Override
            public Object apply(Tuple o) {
                return x;
            }
        };
    }

    public static <T> Term of(String name, String x, ToIntFunction<T> f) {
        return Terms.of(name, (Term)Terms.$(x), f);
    }

    public static <T> Term of(String name, Term x, final ToIntFunction<T> f) {
        return new AbstractFunction(name, x){

            @Override
            public DataType type() {
                return DataTypes.IntegerType;
            }

            @Override
            public int applyAsInt(Tuple o) {
                return f.applyAsInt(this.x.apply(o));
            }

            @Override
            public long applyAsLong(Tuple o) {
                return f.applyAsInt(this.x.apply(o));
            }

            @Override
            public float applyAsFloat(Tuple o) {
                return f.applyAsInt(this.x.apply(o));
            }

            @Override
            public double applyAsDouble(Tuple o) {
                return f.applyAsInt(this.x.apply(o));
            }

            @Override
            public Object apply(Tuple o) {
                return f.applyAsInt(this.x.apply(o));
            }
        };
    }

    public static <T> Term of(String name, String x, ToLongFunction<T> f) {
        return Terms.of(name, (Term)Terms.$(x), f);
    }

    public static <T> Term of(String name, Term x, final ToLongFunction<T> f) {
        return new AbstractFunction(name, x){

            @Override
            public DataType type() {
                return DataTypes.LongType;
            }

            @Override
            public long applyAsLong(Tuple o) {
                return f.applyAsLong(this.x.apply(o));
            }

            @Override
            public float applyAsFloat(Tuple o) {
                return f.applyAsLong(this.x.apply(o));
            }

            @Override
            public double applyAsDouble(Tuple o) {
                return f.applyAsLong(this.x.apply(o));
            }

            @Override
            public Object apply(Tuple o) {
                return f.applyAsLong(this.x.apply(o));
            }
        };
    }

    public static <T> Term of(String name, String x, ToDoubleFunction<T> f) {
        return Terms.of(name, (Term)Terms.$(x), f);
    }

    public static <T> Term of(String name, Term x, final ToDoubleFunction<T> f) {
        return new AbstractFunction(name, x){

            @Override
            public DataType type() {
                return DataTypes.DoubleType;
            }

            @Override
            public double applyAsDouble(Tuple o) {
                return f.applyAsDouble(this.x.apply(o));
            }

            @Override
            public Object apply(Tuple o) {
                return f.applyAsDouble(this.x.apply(o));
            }
        };
    }

    public static <T, R> Term of(String name, String x, Class<R> clazz, Function f) {
        return Terms.of(name, (Term)Terms.$(x), clazz, f);
    }

    public static <T, R> Term of(String name, Term x, final Class<R> clazz, final Function f) {
        return new AbstractFunction(name, x){

            @Override
            public DataType type() {
                return DataTypes.object(clazz);
            }

            @Override
            public Object apply(Tuple o) {
                return f.apply(this.x.apply(o));
            }
        };
    }

    public static <T, U> Term of(String name, String x, String y, ToIntBiFunction<T, U> f) {
        return Terms.of(name, (Term)Terms.$(x), (Term)Terms.$(y), f);
    }

    public static <T, U> Term of(String name, Term x, Term y, final ToIntBiFunction<T, U> f) {
        return new AbstractBiFunction(name, x, y){

            @Override
            public DataType type() {
                return DataTypes.IntegerType;
            }

            @Override
            public int applyAsInt(Tuple o) {
                return f.applyAsInt(this.x.apply(o), this.y.apply(o));
            }

            @Override
            public Object apply(Tuple o) {
                return f.applyAsInt(this.x.apply(o), this.y.apply(o));
            }
        };
    }

    public static <T, U> Term of(String name, String x, String y, ToLongBiFunction<T, U> f) {
        return Terms.of(name, (Term)Terms.$(x), (Term)Terms.$(y), f);
    }

    public static <T, U> Term of(String name, Term x, Term y, final ToLongBiFunction<T, U> f) {
        return new AbstractBiFunction(name, x, y){

            @Override
            public DataType type() {
                return DataTypes.LongType;
            }

            @Override
            public long applyAsLong(Tuple o) {
                return f.applyAsLong(this.x.apply(o), this.y.apply(o));
            }

            @Override
            public Object apply(Tuple o) {
                return f.applyAsLong(this.x.apply(o), this.y.apply(o));
            }
        };
    }

    public static <T, U> Term of(String name, String x, String y, ToDoubleBiFunction<T, U> f) {
        return Terms.of(name, (Term)Terms.$(x), (Term)Terms.$(y), f);
    }

    public static <T, U> Term of(String name, Term x, Term y, final ToDoubleBiFunction<T, U> f) {
        return new AbstractBiFunction(name, x, y){

            @Override
            public DataType type() {
                return DataTypes.DoubleType;
            }

            @Override
            public double applyAsDouble(Tuple o) {
                return f.applyAsDouble(this.x.apply(o), this.y.apply(o));
            }

            @Override
            public Object apply(Tuple o) {
                return f.applyAsDouble(this.x.apply(o), this.y.apply(o));
            }
        };
    }

    public static <T, U, R> Term of(String name, String x, String y, Class<R> clazz, BiFunction<T, U, R> f) {
        return Terms.of(name, Terms.$(x), Terms.$(y), clazz, f);
    }

    public static <T, U, R> Term of(String name, Term x, Term y, final Class<R> clazz, final BiFunction<T, U, R> f) {
        return new AbstractBiFunction(name, x, y){

            @Override
            public DataType type() {
                return DataTypes.object(clazz);
            }

            @Override
            public Object apply(Tuple o) {
                return f.apply(this.x.apply(o), this.y.apply(o));
            }
        };
    }
}

