/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import smile.data.Tuple;
import smile.data.formula.AbstractFunction;
import smile.data.formula.Term;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructType;
import smile.math.Function;

public class DoubleFunction
extends AbstractFunction {
    private Function lambda;

    public DoubleFunction(String name, Term x, Function lambda) {
        super(name, x);
        this.lambda = lambda;
    }

    @Override
    public DataType type() {
        return this.x.type().id() == DataType.ID.Object ? DataTypes.DoubleObjectType : DataTypes.DoubleType;
    }

    @Override
    public void bind(StructType schema) {
        this.x.bind(schema);
        if (!(this.x.type().isDouble() || this.x.type().isFloat() || this.x.type().isInt() || this.x.type().isLong() || this.x.type().isShort() || this.x.type().isByte())) {
            throw new IllegalStateException(String.format("Invalid expression: %s(%s)", this.name, this.x.type()));
        }
    }

    @Override
    public double applyAsDouble(Tuple o) {
        return this.lambda.apply(this.x.applyAsDouble(o));
    }

    @Override
    public Double apply(Tuple o) {
        Object y = this.x.apply(o);
        if (y == null) {
            return null;
        }
        return this.lambda.apply(((Number)y).doubleValue());
    }
}

