/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.io.IOException;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import smile.data.Dataset;
import smile.data.Instance;
import smile.data.SparseDatasetImpl;
import smile.math.MathEx;
import smile.math.matrix.SparseMatrix;
import smile.util.SparseArray;

public interface SparseDataset
extends Dataset<SparseArray> {
    public int nz();

    public int nz(int var1);

    default public int nrows() {
        return this.size();
    }

    public int ncols();

    default public double get(int i, int j) {
        if (i < 0 || i >= this.size() || j < 0 || j >= this.ncols()) {
            throw new IllegalArgumentException("Invalid index: i = " + i + " j = " + j);
        }
        for (SparseArray.Entry e : (SparseArray)this.get(i)) {
            if (e.i != j) continue;
            return e.x;
        }
        return 0.0;
    }

    default public void unitize() {
        this.stream().forEach(x -> {
            double sum = 0.0;
            for (SparseArray.Entry e : x) {
                sum += MathEx.sqr((double)e.x);
            }
            sum = Math.sqrt(sum);
            for (SparseArray.Entry e : x) {
                e.update(e.x / sum);
            }
        });
    }

    default public void unitize1() {
        this.stream().forEach(x -> {
            double sum = 0.0;
            for (SparseArray.Entry e : x) {
                sum += Math.abs(e.x);
            }
            for (SparseArray.Entry e : x) {
                e.update(e.x / sum);
            }
        });
    }

    default public SparseMatrix toMatrix() {
        int nz = this.nz();
        int ncols = this.ncols();
        int[] pos = new int[ncols];
        int[] colIndex = new int[ncols + 1];
        for (int i = 0; i < ncols; ++i) {
            colIndex[i + 1] = colIndex[i] + this.nz(i);
        }
        int nrows = this.size();
        int[] rowIndex = new int[nz];
        double[] x = new double[nz];
        for (int i = 0; i < nrows; ++i) {
            for (SparseArray.Entry e : (SparseArray)this.get(i)) {
                int j = e.i;
                int k = colIndex[j] + pos[j];
                rowIndex[k] = i;
                x[k] = e.x;
                int n = j;
                pos[n] = pos[n] + 1;
            }
        }
        return new SparseMatrix(nrows, ncols, x, rowIndex, colIndex);
    }

    public static SparseDataset of(Stream<SparseArray> data) {
        return SparseDataset.of(data.collect(Collectors.toList()));
    }

    public static SparseDataset of(Collection<SparseArray> data) {
        return new SparseDatasetImpl(data);
    }

    public static SparseDataset of(Collection<SparseArray> data, int ncols) {
        return new SparseDatasetImpl(data, ncols);
    }

    public static SparseDataset of(Dataset<Instance<SparseArray>> data) {
        return SparseDataset.of(data.stream().map(i -> (SparseArray)i.x()).collect(Collectors.toList()));
    }

    public static SparseDataset from(Path path) throws IOException, ParseException {
        return SparseDataset.from(path, 0);
    }

    /*
     * Exception decompiling
     */
    public static SparseDataset from(Path path, int arrayIndexOrigin) throws IOException, ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

