/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.DataFrame;
import smile.data.DatasetSpliterator;
import smile.data.Tuple;
import smile.data.measure.NominalScale;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.ObjectType;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.data.vector.BaseVector;
import smile.data.vector.BooleanVector;
import smile.data.vector.ByteVector;
import smile.data.vector.CharVector;
import smile.data.vector.DoubleVector;
import smile.data.vector.FloatVector;
import smile.data.vector.IntVector;
import smile.data.vector.LongVector;
import smile.data.vector.ShortVector;
import smile.data.vector.StringVector;
import smile.data.vector.Vector;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.Matrix;

class DataFrameImpl
implements DataFrame {
    private static final Logger logger = LoggerFactory.getLogger(DataFrameImpl.class);
    private StructType schema;
    private List<BaseVector> columns;
    private final int size;

    public DataFrameImpl(Collection<BaseVector> columns) {
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("Empty collection of columns");
        }
        this.columns = new ArrayList<BaseVector>(columns);
        StructField[] fields = (StructField[])columns.stream().map(column -> column.field()).toArray(StructField[]::new);
        this.schema = DataTypes.struct(fields);
        HashSet<String> set = new HashSet<String>();
        for (BaseVector v : columns) {
            if (set.add(v.name())) continue;
            throw new IllegalArgumentException(String.format("Duplicated column name: %s", v.name()));
        }
        BaseVector first = columns.iterator().next();
        this.size = first.size();
        for (BaseVector v : columns) {
            if (v.size() == first.size()) continue;
            throw new IllegalArgumentException(String.format("Column %s size %d != %d", v.name(), v.size(), first.size()));
        }
    }

    public <T> DataFrameImpl(List<T> data, Class<T> clazz) {
        this.size = data.size();
        this.columns = new ArrayList<BaseVector>();
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            StructField[] fields = (StructField[])Arrays.stream(props).filter(prop -> !prop.getName().equals("class")).map(this::field).toArray(StructField[]::new);
            this.schema = DataTypes.struct(fields);
            for (PropertyDescriptor prop2 : props) {
                BaseVector<Integer, Integer, IntStream> vector;
                Object[] values;
                if (prop2.getName().equals("class")) continue;
                String name = prop2.getName();
                Class<?> type = prop2.getPropertyType();
                Method read = prop2.getReadMethod();
                StructField field = Arrays.stream(fields).filter(f -> f.name.equals(name)).findFirst().get();
                if (type == Integer.TYPE) {
                    values = new int[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values[i] = (Integer)read.invoke(data.get(i), new Object[0]);
                    }
                    vector = IntVector.of(field, values);
                    this.columns.add(vector);
                    continue;
                }
                if (type == Double.TYPE) {
                    values = new double[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values[i] = (int)((Double)read.invoke(data.get(i), new Object[0])).doubleValue();
                    }
                    vector = DoubleVector.of(field, (double[])values);
                    this.columns.add(vector);
                    continue;
                }
                if (type == Boolean.TYPE) {
                    values = new boolean[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values[i] = ((Boolean)read.invoke(data.get(i), new Object[0])).booleanValue() ? 1 : 0;
                    }
                    vector = BooleanVector.of(field, (boolean[])values);
                    this.columns.add(vector);
                    continue;
                }
                if (type == Short.TYPE) {
                    values = new short[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values[i] = ((Short)read.invoke(data.get(i), new Object[0])).shortValue();
                    }
                    vector = ShortVector.of(field, (short[])values);
                    this.columns.add(vector);
                    continue;
                }
                if (type == Long.TYPE) {
                    values = new long[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values[i] = (int)((Long)read.invoke(data.get(i), new Object[0])).longValue();
                    }
                    vector = LongVector.of(field, (long[])values);
                    this.columns.add(vector);
                    continue;
                }
                if (type == Float.TYPE) {
                    values = new float[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values[i] = (int)((Float)read.invoke(data.get(i), new Object[0])).floatValue();
                    }
                    vector = FloatVector.of(field, (float[])values);
                    this.columns.add(vector);
                    continue;
                }
                if (type == Byte.TYPE) {
                    values = new byte[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values[i] = ((Byte)read.invoke(data.get(i), new Object[0])).byteValue();
                    }
                    vector = ByteVector.of(field, (byte[])values);
                    this.columns.add(vector);
                    continue;
                }
                if (type == Character.TYPE) {
                    values = new char[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values[i] = ((Character)read.invoke(data.get(i), new Object[0])).charValue();
                    }
                    vector = CharVector.of(field, (char[])values);
                    this.columns.add(vector);
                    continue;
                }
                if (type == String.class) {
                    values = new String[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values[i] = (int)((String)read.invoke(data.get(i), new Object[0]));
                    }
                    vector = StringVector.of(field, (String[])values);
                    this.columns.add(vector);
                    continue;
                }
                if (type.isEnum()) {
                    BaseVector<Byte, Integer, IntStream> vector2;
                    Object[] values2;
                    ?[] levels = type.getEnumConstants();
                    if (levels.length < 128) {
                        values2 = new byte[this.size];
                        for (int i = 0; i < this.size; ++i) {
                            values2[i] = (byte)((Enum)read.invoke(data.get(i), new Object[0])).ordinal();
                        }
                        vector2 = ByteVector.of(field, values2);
                        this.columns.add(vector2);
                        continue;
                    }
                    if (levels.length < 32768) {
                        values2 = new short[this.size];
                        for (int i = 0; i < this.size; ++i) {
                            values2[i] = (short)((Enum)read.invoke(data.get(i), new Object[0])).ordinal();
                        }
                        vector2 = ShortVector.of(field, (short[])values2);
                        this.columns.add(vector2);
                        continue;
                    }
                    values2 = new int[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values2[i] = ((Enum)read.invoke(data.get(i), new Object[0])).ordinal();
                    }
                    vector2 = IntVector.of(field, (int[])values2);
                    this.columns.add(vector2);
                    continue;
                }
                values = new Object[this.size];
                for (int i = 0; i < this.size; ++i) {
                    values[i] = (int)read.invoke(data.get(i), new Object[0]);
                }
                vector = Vector.of(field, values);
                this.columns.add(vector);
            }
        }
        catch (IntrospectionException ex) {
            logger.error("Failed to introspect a bean: ", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (ReflectiveOperationException ex) {
            logger.error("Failed to call property read method: ", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private StructField field(PropertyDescriptor prop) {
        Class<?> clazz = prop.getPropertyType();
        DataType type = DataType.of(clazz);
        NominalScale scale = null;
        if (clazz.isEnum()) {
            ?[] levels = clazz.getEnumConstants();
            scale = new NominalScale((String[])Arrays.stream(levels).map(Object::toString).toArray(String[]::new));
        }
        return new StructField(prop.getName(), type, scale);
    }

    public DataFrameImpl(Stream<Tuple> data) {
        this(data.collect(Collectors.toList()));
    }

    public DataFrameImpl(Stream<Tuple> data, StructType schema) {
        this(data.collect(Collectors.toList()), schema);
    }

    public DataFrameImpl(List<Tuple> data) {
        this(data, data.get(0).schema());
    }

    public DataFrameImpl(List<Tuple> data, StructType schema) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Empty tuple collections");
        }
        this.size = data.size();
        this.schema = schema;
        StructField[] fields = schema.fields();
        this.columns = new ArrayList<BaseVector>(fields.length);
        block11: for (int j = 0; j < fields.length; ++j) {
            StructField field = fields[j];
            switch (field.type.id()) {
                case Integer: {
                    Object[] values = new int[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values[i] = data.get(i).getInt(j);
                    }
                    BaseVector<Integer, Integer, IntStream> vector = IntVector.of(field, values);
                    this.columns.add(vector);
                    continue block11;
                }
                case Long: {
                    Object[] values = new long[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values[i] = (int)data.get(i).getLong(j);
                    }
                    BaseVector<Integer, Integer, IntStream> vector = LongVector.of(field, (long[])values);
                    this.columns.add(vector);
                    continue block11;
                }
                case Double: {
                    Object[] values = new double[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values[i] = (int)data.get(i).getDouble(j);
                    }
                    BaseVector<Integer, Integer, IntStream> vector = DoubleVector.of(field, (double[])values);
                    this.columns.add(vector);
                    continue block11;
                }
                case Float: {
                    Object[] values = new float[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values[i] = (int)data.get(i).getFloat(j);
                    }
                    BaseVector<Integer, Integer, IntStream> vector = FloatVector.of(field, (float[])values);
                    this.columns.add(vector);
                    continue block11;
                }
                case Boolean: {
                    Object[] values = new boolean[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values[i] = data.get(i).getBoolean(j) ? 1 : 0;
                    }
                    BaseVector<Integer, Integer, IntStream> vector = BooleanVector.of(field, (boolean[])values);
                    this.columns.add(vector);
                    continue block11;
                }
                case Byte: {
                    Object[] values = new byte[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values[i] = data.get(i).getByte(j);
                    }
                    BaseVector<Integer, Integer, IntStream> vector = ByteVector.of(field, (byte[])values);
                    this.columns.add(vector);
                    continue block11;
                }
                case Short: {
                    Object[] values = new short[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values[i] = data.get(i).getShort(j);
                    }
                    BaseVector<Integer, Integer, IntStream> vector = ShortVector.of(field, (short[])values);
                    this.columns.add(vector);
                    continue block11;
                }
                case Char: {
                    Object[] values = new char[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values[i] = data.get(i).getChar(j);
                    }
                    BaseVector<Integer, Integer, IntStream> vector = CharVector.of(field, (char[])values);
                    this.columns.add(vector);
                    continue block11;
                }
                case String: {
                    Object[] values = new String[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values[i] = (int)data.get(i).getString(j);
                    }
                    BaseVector<Integer, Integer, IntStream> vector = StringVector.of(field, (String[])values);
                    this.columns.add(vector);
                    continue block11;
                }
                default: {
                    Object[] values = new Object[this.size];
                    for (int i = 0; i < this.size; ++i) {
                        values[i] = (int)data.get(i).get(j);
                    }
                    BaseVector<Integer, Integer, IntStream> vector = Vector.of(field, values);
                    this.columns.add(vector);
                }
            }
        }
    }

    public DataFrameImpl(BaseVector ... vectors) {
        this((Collection<BaseVector>)Arrays.asList(vectors));
    }

    @Override
    public StructType schema() {
        return this.schema;
    }

    public String toString() {
        return this.toString(10, true);
    }

    @Override
    public Iterator<BaseVector> iterator() {
        return this.columns.iterator();
    }

    @Override
    public int columnIndex(String name) {
        return this.schema.fieldIndex(name);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int ncols() {
        return this.columns.size();
    }

    @Override
    public Object get(int i, int j) {
        return this.columns.get(j).get(i);
    }

    @Override
    public Stream<Tuple> stream() {
        DatasetSpliterator<Tuple> spliterator = new DatasetSpliterator<Tuple>(this, 16);
        return StreamSupport.stream(spliterator, true);
    }

    @Override
    public BaseVector column(int i) {
        return this.columns.get(i);
    }

    @Override
    public <T> Vector<T> vector(int i) {
        return (Vector)this.columns.get(i);
    }

    @Override
    public BooleanVector booleanVector(int i) {
        return (BooleanVector)this.columns.get(i);
    }

    @Override
    public CharVector charVector(int i) {
        return (CharVector)this.columns.get(i);
    }

    @Override
    public ByteVector byteVector(int i) {
        return (ByteVector)this.columns.get(i);
    }

    @Override
    public ShortVector shortVector(int i) {
        return (ShortVector)this.columns.get(i);
    }

    @Override
    public IntVector intVector(int i) {
        return (IntVector)this.columns.get(i);
    }

    @Override
    public LongVector longVector(int i) {
        return (LongVector)this.columns.get(i);
    }

    @Override
    public FloatVector floatVector(int i) {
        return (FloatVector)this.columns.get(i);
    }

    @Override
    public DoubleVector doubleVector(int i) {
        return (DoubleVector)this.columns.get(i);
    }

    @Override
    public StringVector stringVector(int i) {
        return (StringVector)this.columns.get(i);
    }

    @Override
    public DataFrame select(int ... cols) {
        ArrayList<BaseVector> sub = new ArrayList<BaseVector>();
        for (int i = 0; i < cols.length; ++i) {
            sub.add(this.columns.get(cols[i]));
        }
        return new DataFrameImpl((Collection<BaseVector>)sub);
    }

    @Override
    public DataFrame drop(int ... cols) {
        ArrayList<BaseVector> sub = new ArrayList<BaseVector>(this.columns);
        ArrayList<BaseVector> drops = new ArrayList<BaseVector>();
        for (int i = 0; i < cols.length; ++i) {
            drops.add(this.columns.get(cols[i]));
        }
        sub.removeAll(drops);
        return new DataFrameImpl((Collection<BaseVector>)sub);
    }

    @Override
    public DataFrame merge(DataFrame ... dataframes) {
        for (DataFrame df : dataframes) {
            if (df.size() == this.size()) continue;
            throw new IllegalArgumentException("Merge data frames with different size: " + this.size() + " vs " + df.size());
        }
        ArrayList<BaseVector> all = new ArrayList<BaseVector>(this.columns);
        for (DataFrame df : dataframes) {
            for (int i = 0; i < df.ncols(); ++i) {
                all.add(df.column(i));
            }
        }
        return new DataFrameImpl((Collection<BaseVector>)all);
    }

    @Override
    public DataFrame merge(BaseVector ... vectors) {
        for (BaseVector vector : vectors) {
            if (vector.size() == this.size()) continue;
            throw new IllegalArgumentException("Merge data frames with different size: " + this.size() + " vs " + vector.size());
        }
        ArrayList<BaseVector> columns = new ArrayList<BaseVector>(this.columns);
        Collections.addAll(columns, vectors);
        return new DataFrameImpl((Collection<BaseVector>)columns);
    }

    @Override
    public DataFrame union(DataFrame ... dataframes) {
        for (DataFrame df : dataframes) {
            if (this.schema.equals(df.schema())) continue;
            throw new IllegalArgumentException("Union data frames with different schema: " + this.schema + " vs " + df.schema());
        }
        int nrows = this.nrows();
        for (DataFrame df : dataframes) {
            nrows += df.nrows();
        }
        Object[] vectors = new Object[this.ncols()];
        for (int i = 0; i < vectors.length; ++i) {
            BaseVector column = this.columns.get(i);
            switch (column.type().id()) {
                case Boolean: {
                    vectors[i] = new boolean[nrows];
                    break;
                }
                case Char: {
                    vectors[i] = new char[nrows];
                    break;
                }
                case Byte: {
                    vectors[i] = new byte[nrows];
                    break;
                }
                case Short: {
                    vectors[i] = new short[nrows];
                    break;
                }
                case Integer: {
                    vectors[i] = new int[nrows];
                    break;
                }
                case Long: {
                    vectors[i] = new long[nrows];
                    break;
                }
                case Float: {
                    vectors[i] = new float[nrows];
                    break;
                }
                case Double: {
                    vectors[i] = new double[nrows];
                    break;
                }
                default: {
                    vectors[i] = new Object[nrows];
                }
            }
            System.arraycopy(column.array(), 0, vectors[i], 0, this.nrows());
        }
        int destPos = this.nrows();
        for (DataFrame df : dataframes) {
            for (int i = 0; i < vectors.length; ++i) {
                System.arraycopy(df.column(i).array(), 0, vectors[i], destPos, df.nrows());
            }
            destPos += df.nrows();
        }
        ArrayList<BaseVector> data = new ArrayList<BaseVector>();
        block25: for (int i = 0; i < vectors.length; ++i) {
            BaseVector column = this.columns.get(i);
            switch (column.type().id()) {
                case Boolean: {
                    data.add(BooleanVector.of(column.name(), (boolean[])vectors[i]));
                    continue block25;
                }
                case Char: {
                    data.add(CharVector.of(column.name(), (char[])vectors[i]));
                    continue block25;
                }
                case Byte: {
                    data.add(ByteVector.of(column.name(), (byte[])vectors[i]));
                    continue block25;
                }
                case Short: {
                    data.add(ShortVector.of(column.name(), (short[])vectors[i]));
                    continue block25;
                }
                case Integer: {
                    data.add(IntVector.of(column.name(), (int[])vectors[i]));
                    continue block25;
                }
                case Long: {
                    data.add(LongVector.of(column.name(), (long[])vectors[i]));
                    continue block25;
                }
                case Float: {
                    data.add(FloatVector.of(column.name(), (float[])vectors[i]));
                    continue block25;
                }
                case Double: {
                    data.add(DoubleVector.of(column.name(), (double[])vectors[i]));
                    continue block25;
                }
                default: {
                    data.add(Vector.of(column.name(), column.type(), (Object[])vectors[i]));
                }
            }
        }
        return new DataFrameImpl((Collection<BaseVector>)data);
    }

    @Override
    public Tuple get(int i) {
        return new DataFrameRow(i);
    }

    @Override
    public DenseMatrix toMatrix() {
        int nrows = this.nrows();
        int ncols = this.ncols();
        DataType[] types = this.types();
        DenseMatrix m = Matrix.of((int)nrows, (int)ncols, (double)0.0);
        block12: for (int j = 0; j < ncols; ++j) {
            DataType type = types[j];
            switch (type.id()) {
                case Double: {
                    BaseVector<Double, Double, DoubleStream> v = this.doubleVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m.set(i, j, v.getDouble(i));
                    }
                    continue block12;
                }
                case Integer: {
                    BaseVector<Double, Double, DoubleStream> v = this.intVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m.set(i, j, (double)v.getInt(i));
                    }
                    continue block12;
                }
                case Float: {
                    BaseVector<Double, Double, DoubleStream> v = this.floatVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m.set(i, j, (double)v.getFloat(i));
                    }
                    continue block12;
                }
                case Long: {
                    BaseVector<Double, Double, DoubleStream> v = this.longVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m.set(i, j, (double)v.getLong(i));
                    }
                    continue block12;
                }
                case Boolean: {
                    BaseVector<Double, Double, DoubleStream> v = this.booleanVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m.set(i, j, v.getDouble(i));
                    }
                    continue block12;
                }
                case Byte: {
                    BaseVector<Double, Double, DoubleStream> v = this.byteVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m.set(i, j, (double)v.getByte(i));
                    }
                    continue block12;
                }
                case Short: {
                    BaseVector<Double, Double, DoubleStream> v = this.shortVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m.set(i, j, (double)v.getShort(i));
                    }
                    continue block12;
                }
                case Char: {
                    BaseVector<Double, Double, DoubleStream> v = this.charVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m.set(i, j, (double)v.getChar(i));
                    }
                    continue block12;
                }
                case String: {
                    BaseVector<Double, Double, DoubleStream> v = this.stringVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        String s = (String)((Object)v.get(i));
                        m.set(i, j, s == null ? Double.NaN : Double.valueOf(s));
                    }
                    continue block12;
                }
                case Object: {
                    int i;
                    Class clazz = ((ObjectType)type).getObjectClass();
                    if (clazz == Boolean.class) {
                        Vector v = this.vector(j);
                        for (i = 0; i < nrows; ++i) {
                            Boolean b = (Boolean)v.get(i);
                            if (b != null) {
                                m.set(i, j, b != false ? 1.0 : 0.0);
                                continue;
                            }
                            m.set(i, j, Double.NaN);
                        }
                        continue block12;
                    }
                    if (Number.class.isAssignableFrom(clazz)) {
                        Vector v = this.vector(j);
                        for (i = 0; i < nrows; ++i) {
                            m.set(i, j, v.getDouble(i));
                        }
                        continue block12;
                    }
                    throw new UnsupportedOperationException(String.format("DataFrame.toMatrix() doesn't support type %s", type));
                }
                default: {
                    throw new UnsupportedOperationException(String.format("DataFrame.toMatrix() doesn't support type %s", type));
                }
            }
        }
        return m;
    }

    @Override
    public double[][] toArray() {
        int nrows = this.nrows();
        int ncols = this.ncols();
        DataType[] types = this.types();
        double[][] m = new double[nrows][ncols];
        block12: for (int j = 0; j < ncols; ++j) {
            DataType type = types[j];
            switch (type.id()) {
                case Double: {
                    BaseVector<Double, Double, DoubleStream> v = this.doubleVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m[i][j] = v.getDouble(i);
                    }
                    continue block12;
                }
                case Integer: {
                    BaseVector<Double, Double, DoubleStream> v = this.intVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m[i][j] = v.getInt(i);
                    }
                    continue block12;
                }
                case Float: {
                    BaseVector<Double, Double, DoubleStream> v = this.floatVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m[i][j] = v.getFloat(i);
                    }
                    continue block12;
                }
                case Long: {
                    BaseVector<Double, Double, DoubleStream> v = this.longVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m[i][j] = v.getLong(i);
                    }
                    continue block12;
                }
                case Boolean: {
                    BaseVector<Double, Double, DoubleStream> v = this.booleanVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m[i][j] = v.getDouble(i);
                    }
                    continue block12;
                }
                case Byte: {
                    BaseVector<Double, Double, DoubleStream> v = this.byteVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m[i][j] = v.getByte(i);
                    }
                    continue block12;
                }
                case Short: {
                    BaseVector<Double, Double, DoubleStream> v = this.shortVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m[i][j] = v.getShort(i);
                    }
                    continue block12;
                }
                case Char: {
                    BaseVector<Double, Double, DoubleStream> v = this.charVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        m[i][j] = v.getChar(i);
                    }
                    continue block12;
                }
                case String: {
                    BaseVector<Double, Double, DoubleStream> v = this.stringVector(j);
                    for (int i = 0; i < nrows; ++i) {
                        String s = (String)((Object)v.get(i));
                        m[i][j] = s == null ? Double.NaN : Double.valueOf(s);
                    }
                    continue block12;
                }
                case Object: {
                    int i;
                    Class clazz = ((ObjectType)type).getObjectClass();
                    if (clazz == Boolean.class) {
                        Vector v = this.vector(j);
                        for (i = 0; i < nrows; ++i) {
                            Boolean b = (Boolean)v.get(i);
                            m[i][j] = b != null ? (b != false ? 1.0 : 0.0) : Double.NaN;
                        }
                        continue block12;
                    }
                    if (Number.class.isAssignableFrom(clazz)) {
                        Vector v = this.vector(j);
                        for (i = 0; i < nrows; ++i) {
                            m[i][j] = v.getDouble(i);
                        }
                        continue block12;
                    }
                    throw new UnsupportedOperationException(String.format("DataFrame.toMatrix() doesn't support type %s", type));
                }
                default: {
                    throw new UnsupportedOperationException(String.format("DataFrame.toMatrix() doesn't support type %s", type));
                }
            }
        }
        return m;
    }

    class DataFrameRow
    implements Tuple {
        private int i;

        DataFrameRow(int i) {
            this.i = i;
        }

        @Override
        public StructType schema() {
            return DataFrameImpl.this.schema;
        }

        @Override
        public Object get(int j) {
            return DataFrameImpl.this.get(this.i, j);
        }

        @Override
        public boolean getBoolean(int j) {
            return ((BooleanVector)DataFrameImpl.this.columns.get(j)).getBoolean(this.i);
        }

        @Override
        public char getChar(int j) {
            return ((CharVector)DataFrameImpl.this.columns.get(j)).getChar(this.i);
        }

        @Override
        public byte getByte(int j) {
            return ((BaseVector)DataFrameImpl.this.columns.get(j)).getByte(this.i);
        }

        @Override
        public short getShort(int j) {
            return ((BaseVector)DataFrameImpl.this.columns.get(j)).getShort(this.i);
        }

        @Override
        public int getInt(int j) {
            return ((BaseVector)DataFrameImpl.this.columns.get(j)).getInt(this.i);
        }

        @Override
        public long getLong(int j) {
            return ((BaseVector)DataFrameImpl.this.columns.get(j)).getLong(this.i);
        }

        @Override
        public float getFloat(int j) {
            return ((BaseVector)DataFrameImpl.this.columns.get(j)).getFloat(this.i);
        }

        @Override
        public double getDouble(int j) {
            return ((BaseVector)DataFrameImpl.this.columns.get(j)).getDouble(this.i);
        }

        public String toString() {
            return DataFrameImpl.this.schema.toString(this);
        }
    }
}

