/*
 * Decompiled with CFR 0.152.
 */
package smile.tensor;

import java.lang.foreign.MemorySegment;
import smile.linalg.arpack.arpack_h;
import smile.tensor.AtA;
import smile.tensor.DenseMatrix;
import smile.tensor.EVD;
import smile.tensor.Matrix;
import smile.tensor.SVD;
import smile.tensor.Vector;

public interface ARPACK {
    public static EVD syev(Matrix A, SymmOption which, int nev) {
        return ARPACK.syev(A, which, nev, Math.min(3 * nev, A.nrow()), 1.0E-6);
    }

    public static EVD syev(Matrix A, SymmOption which, int nev, int ncv, double tol) {
        if (A.nrow() != A.ncol()) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", A.nrow(), A.ncol()));
        }
        int n = A.nrow();
        if (nev <= 0 || nev >= n) {
            throw new IllegalArgumentException("Invalid NEV parameter k: " + nev);
        }
        int[] ido = new int[]{0};
        int[] info = new int[]{0};
        byte[] bmat = new byte[]{73};
        String swhich = which.name();
        byte[] bwhich = new byte[]{(byte)swhich.charAt(0), (byte)swhich.charAt(1)};
        int[] iparam = new int[11];
        iparam[0] = 1;
        iparam[2] = 10 * n;
        iparam[6] = 1;
        int[] ipntr = new int[11];
        Vector workd = A.vector(3 * n);
        Vector workl = A.vector(ncv * (ncv + 8));
        Vector resid = A.vector(n);
        DenseMatrix V = DenseMatrix.zeros(A.scalarType(), n, ncv);
        int ldv = V.ld;
        MemorySegment ido_ = MemorySegment.ofArray(ido);
        MemorySegment bmat_ = MemorySegment.ofArray(bmat);
        MemorySegment bwhich_ = MemorySegment.ofArray(bwhich);
        MemorySegment iparam_ = MemorySegment.ofArray(iparam);
        MemorySegment ipntr_ = MemorySegment.ofArray(ipntr);
        MemorySegment info_ = MemorySegment.ofArray(info);
        do {
            switch (A.scalarType()) {
                case Float64: {
                    arpack_h.dsaupd_c(ido_, bmat_, n, bwhich_, nev, tol, resid.memory, ncv, V.memory, ldv, iparam_, ipntr_, workd.memory, workl.memory, workl.size(), info_);
                    break;
                }
                case Float32: {
                    arpack_h.ssaupd_c(ido_, bmat_, n, bwhich_, nev, (float)tol, resid.memory, ncv, V.memory, ldv, iparam_, ipntr_, workd.memory, workl.memory, workl.size(), info_);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported scalar type: " + String.valueOf((Object)A.scalarType()));
                }
            }
            if (ido[0] != -1 && ido[0] != 1) continue;
            A.mv(workd, ipntr[0] - 1, ipntr[1] - 1);
        } while (ido[0] == -1 || ido[0] == 1);
        if (info[0] < 0) {
            throw new ArithmeticException("ARPACK DSAUPD error code: " + info[0]);
        }
        info[0] = 0;
        byte[] howmny = new byte[]{65};
        Vector d = A.vector(ncv * 2);
        int[] select = new int[ncv];
        double sigma = 0.0;
        int rvec = 1;
        MemorySegment howmny_ = MemorySegment.ofArray(howmny);
        MemorySegment select_ = MemorySegment.ofArray(select);
        switch (A.scalarType()) {
            case Float64: {
                arpack_h.dseupd_c(rvec, howmny_, select_, d.memory, V.memory, ldv, sigma, bmat_, n, bwhich_, nev, tol, resid.memory, ncv, V.memory, ldv, iparam_, ipntr_, workd.memory, workl.memory, workl.size(), info_);
                break;
            }
            case Float32: {
                arpack_h.sseupd_c(rvec, howmny_, select_, d.memory, V.memory, ldv, (float)sigma, bmat_, n, bwhich_, nev, (float)tol, resid.memory, ncv, V.memory, ldv, iparam_, ipntr_, workd.memory, workl.memory, workl.size(), info_);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported scalar type: " + String.valueOf((Object)A.scalarType()));
            }
        }
        if (info[0] != 0) {
            String error = switch (info[0]) {
                case 1 -> "ARPACK DSEUPD error: Maximum number of iterations reached.";
                case 3 -> "ARPACK DSEUPD error: No shifts could be applied during implicit Arnoldi update, try increasing NCV.";
                default -> "ARPACK DSEUPD error code: " + info[0];
            };
            throw new ArithmeticException(error);
        }
        if (iparam[4] < nev) {
            String error = String.format("ARPACK dseupd computed %d eigenvalues, expect %d", iparam[4], nev);
            throw new ArithmeticException(error);
        }
        d = d.copy(0, nev);
        V = V.submatrix(0, 0, n, nev);
        EVD eig = new EVD(d, V);
        return eig.sort();
    }

    public static EVD eigen(Matrix A, AsymmOption which, int nev) {
        return ARPACK.eigen(A, which, nev, Math.min(3 * nev, A.nrow()), 1.0E-6);
    }

    public static EVD eigen(Matrix A, AsymmOption which, int nev, int ncv, double tol) {
        if (A.nrow() != A.ncol()) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", A.nrow(), A.ncol()));
        }
        int n = A.nrow();
        if (nev <= 0 || nev >= n) {
            throw new IllegalArgumentException("Invalid NEV: " + nev);
        }
        int[] ido = new int[]{0};
        int[] info = new int[]{0};
        byte[] bmat = new byte[]{73};
        String swhich = which.name();
        byte[] bwhich = new byte[]{(byte)swhich.charAt(0), (byte)swhich.charAt(1)};
        int[] iparam = new int[11];
        iparam[0] = 1;
        iparam[2] = 10 * n;
        iparam[6] = 1;
        int[] ipntr = new int[14];
        Vector workd = A.vector(3 * n);
        Vector workev = A.vector(3 * ncv);
        Vector workl = A.vector(3 * ncv * ncv + 6 * ncv);
        Vector resid = A.vector(n);
        DenseMatrix V = DenseMatrix.zeros(A.scalarType(), n, ncv);
        int ldv = V.ld;
        MemorySegment ido_ = MemorySegment.ofArray(ido);
        MemorySegment bmat_ = MemorySegment.ofArray(bmat);
        MemorySegment bwhich_ = MemorySegment.ofArray(bwhich);
        MemorySegment iparam_ = MemorySegment.ofArray(iparam);
        MemorySegment ipntr_ = MemorySegment.ofArray(ipntr);
        MemorySegment info_ = MemorySegment.ofArray(info);
        do {
            switch (A.scalarType()) {
                case Float64: {
                    arpack_h.dnaupd_c(ido_, bmat_, n, bwhich_, nev, tol, resid.memory, ncv, V.memory, ldv, iparam_, ipntr_, workd.memory, workl.memory, workl.size(), info_);
                    break;
                }
                case Float32: {
                    arpack_h.snaupd_c(ido_, bmat_, n, bwhich_, nev, (float)tol, resid.memory, ncv, V.memory, ldv, iparam_, ipntr_, workd.memory, workl.memory, workl.size(), info_);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported scalar type: " + String.valueOf((Object)A.scalarType()));
                }
            }
            if (ido[0] != -1 && ido[0] != 1) continue;
            A.mv(workd, ipntr[0] - 1, ipntr[1] - 1);
        } while (ido[0] == -1 || ido[0] == 1);
        if (info[0] < 0) {
            throw new ArithmeticException("ARPACK DNAUPD error code: " + info[0]);
        }
        info[0] = 0;
        byte[] howmny = new byte[]{65};
        Vector wr = A.vector(ncv * 2);
        Vector wi = A.vector(ncv * 2);
        int[] select = new int[ncv];
        double sigmar = 0.0;
        double sigmai = 0.0;
        int rvec = 1;
        MemorySegment howmny_ = MemorySegment.ofArray(howmny);
        MemorySegment select_ = MemorySegment.ofArray(select);
        switch (A.scalarType()) {
            case Float64: {
                arpack_h.dneupd_c(rvec, howmny_, select_, wr.memory, wi.memory, V.memory, ldv, sigmar, sigmai, workev.memory, bmat_, n, bwhich_, nev, tol, resid.memory, ncv, V.memory, ldv, iparam_, ipntr_, workd.memory, workl.memory, workl.size(), info_);
                break;
            }
            case Float32: {
                arpack_h.sneupd_c(rvec, howmny_, select_, wr.memory, wi.memory, V.memory, ldv, (float)sigmar, (float)sigmai, workev.memory, bmat_, n, bwhich_, nev, (float)tol, resid.memory, ncv, V.memory, ldv, iparam_, ipntr_, workd.memory, workl.memory, workl.size(), info_);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported scalar type: " + String.valueOf((Object)A.scalarType()));
            }
        }
        if (info[0] != 0) {
            String error = switch (info[0]) {
                case 1 -> "ARPACK DNEUPD error: Maximum number of iterations reached.";
                case 3 -> "ARPACK DNEUPD error: No shifts could be applied during implicit Arnoldi update, try increasing NCV.";
                default -> "ARPACK DNEUPD error code: " + info[0];
            };
            throw new ArithmeticException(error);
        }
        if (iparam[4] < nev) {
            String error = String.format("ARPACK dnaupd computed %d eigenvalues, expect %d", iparam[4], nev);
            throw new ArithmeticException(error);
        }
        wr = wr.copy(0, nev);
        wi = wi.copy(0, nev);
        V = V.submatrix(0, 0, n, nev);
        EVD eig = new EVD(wr, wi, null, V);
        return eig.sort();
    }

    public static SVD svd(Matrix A, int k) {
        return ARPACK.svd(A, k, Math.min(3 * k, Math.min(A.nrow(), A.ncol())), 1.0E-6);
    }

    public static SVD svd(Matrix A, int k, int ncv, double tol) {
        int m = A.nrow();
        int n = A.ncol();
        AtA ata = new AtA(A);
        EVD eigen = ARPACK.syev(ata, SymmOption.LM, k, ncv, tol);
        Vector s = eigen.wr();
        int len = s.size();
        for (int i = 0; i < len; ++i) {
            s.set(i, Math.sqrt(s.get(i)));
        }
        if (m >= n) {
            DenseMatrix V = eigen.Vr();
            Vector Av = A.vector(m);
            DenseMatrix U = V.zeros(m, len);
            for (int j = 0; j < len; ++j) {
                Vector v = V.column(j);
                A.mv(v, Av);
                for (int i = 0; i < m; ++i) {
                    U.set(i, j, Av.get(i) / s.get(j));
                }
            }
            return new SVD(s, U, V.transpose());
        }
        DenseMatrix U = eigen.Vr();
        Vector Atu = A.vector(n);
        DenseMatrix Vt = U.zeros(len, n);
        for (int j = 0; j < len; ++j) {
            Vector u = U.column(j);
            A.tv(u, Atu);
            for (int i = 0; i < n; ++i) {
                Vt.set(j, i, Atu.get(i) / s.get(j));
            }
        }
        return new SVD(s, U, Vt);
    }

    public static enum SymmOption {
        LA,
        SA,
        LM,
        SM,
        BE;

    }

    public static enum AsymmOption {
        LM,
        SM,
        LR,
        SR,
        LI,
        SI;

    }
}

