/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import smile.math.special.Beta;
import smile.math.special.Gamma;
import smile.stat.distribution.AbstractDistribution;

public class TDistribution
extends AbstractDistribution {
    private static final long serialVersionUID = 2L;
    public final int nu;
    private final double entropy;
    private final double np;
    private final double fac;

    public TDistribution(int nu) {
        if (nu < 1) {
            throw new IllegalArgumentException("Invalid nu = " + nu);
        }
        this.nu = nu;
        this.entropy = 0.5 * (double)(nu + 1) * (Gamma.digamma((double)(nu + 1) / 2.0) - Gamma.digamma((double)nu / 2.0)) + Math.log(Math.sqrt(nu) * Beta.beta((double)nu / 2.0, 0.5));
        this.np = 0.5 * ((double)nu + 1.0);
        this.fac = Gamma.lgamma(this.np) - Gamma.lgamma(0.5 * (double)nu);
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public double mean() {
        if (this.nu == 1) {
            throw new UnsupportedOperationException("Mean is undefined for T distribution with nu = 1");
        }
        return 0.0;
    }

    @Override
    public double variance() {
        return (double)this.nu / ((double)this.nu - 2.0);
    }

    @Override
    public double sd() {
        return Math.sqrt((double)this.nu / ((double)this.nu - 2.0));
    }

    @Override
    public double entropy() {
        return this.entropy;
    }

    public String toString() {
        return String.format("t-distribution(%d)", this.nu);
    }

    @Override
    public double rand() {
        return this.inverseTransformSampling();
    }

    @Override
    public double p(double x) {
        return Math.exp(-this.np * Math.log(1.0 + x * x / (double)this.nu) + this.fac) / Math.sqrt(Math.PI * (double)this.nu);
    }

    @Override
    public double logp(double x) {
        return -this.np * Math.log(1.0 + x * x / (double)this.nu) + this.fac - Math.log(Math.sqrt(Math.PI * (double)this.nu));
    }

    @Override
    public double cdf(double x) {
        double p = 0.5 * Beta.regularizedIncompleteBetaFunction(0.5 * (double)this.nu, 0.5, (double)this.nu / ((double)this.nu + x * x));
        if (x >= 0.0) {
            return 1.0 - p;
        }
        return p;
    }

    @Override
    public double quantile(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + p);
        }
        double x = Beta.inverseRegularizedIncompleteBetaFunction(0.5 * (double)this.nu, 0.5, 2.0 * Math.min(p, 1.0 - p));
        x = Math.sqrt((double)this.nu * (1.0 - x) / x);
        return p >= 0.5 ? x : -x;
    }

    public double cdf2tailed(double x) {
        if (x < 0.0) {
            throw new IllegalArgumentException("Invalid x: " + x);
        }
        return 1.0 - Beta.regularizedIncompleteBetaFunction(0.5 * (double)this.nu, 0.5, (double)this.nu / ((double)this.nu + x * x));
    }

    public double quantile2tailed(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + p);
        }
        double x = Beta.inverseRegularizedIncompleteBetaFunction(0.5 * (double)this.nu, 0.5, 1.0 - p);
        return Math.sqrt((double)this.nu * (1.0 - x) / x);
    }
}

