/*
 * Decompiled with CFR 0.152.
 */
package smile.sort;

import java.util.Comparator;
import smile.sort.Sort;

public class QuickSort {
    private static final int M = 7;
    private static final int NSTACK = 64;

    private QuickSort() {
    }

    public static int[] sort(int[] x) {
        int[] order = new int[x.length];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        QuickSort.sort(x, order);
        return order;
    }

    public static void sort(int[] x, int[] y) {
        QuickSort.sort(x, y, x.length);
    }

    public static void sort(int[] x, int[] y, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            int b;
            int a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = x[j];
                    b = y[j];
                    for (i = j - 1; i >= l && x[i] > a; --i) {
                        x[i + 1] = x[i];
                        y[i + 1] = y[i];
                    }
                    x[i + 1] = a;
                    y[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            Sort.swap(x, k, l + 1);
            Sort.swap(y, k, l + 1);
            if (x[l] > x[ir]) {
                Sort.swap(x, l, ir);
                Sort.swap(y, l, ir);
            }
            if (x[l + 1] > x[ir]) {
                Sort.swap(x, l + 1, ir);
                Sort.swap(y, l + 1, ir);
            }
            if (x[l] > x[l + 1]) {
                Sort.swap(x, l, l + 1);
                Sort.swap(y, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = x[l + 1];
            b = y[l + 1];
            while (true) {
                if (x[++i] < a) {
                    continue;
                }
                while (x[--j] > a) {
                }
                if (j < i) break;
                Sort.swap(x, i, j);
                Sort.swap(y, i, j);
            }
            x[l + 1] = x[j];
            x[j] = a;
            y[l + 1] = y[j];
            y[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static void sort(int[] x, double[] y) {
        QuickSort.sort(x, y, x.length);
    }

    public static void sort(int[] x, double[] y, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            double b;
            int a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = x[j];
                    b = y[j];
                    for (i = j - 1; i >= l && x[i] > a; --i) {
                        x[i + 1] = x[i];
                        y[i + 1] = y[i];
                    }
                    x[i + 1] = a;
                    y[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            Sort.swap(x, k, l + 1);
            Sort.swap(y, k, l + 1);
            if (x[l] > x[ir]) {
                Sort.swap(x, l, ir);
                Sort.swap(y, l, ir);
            }
            if (x[l + 1] > x[ir]) {
                Sort.swap(x, l + 1, ir);
                Sort.swap(y, l + 1, ir);
            }
            if (x[l] > x[l + 1]) {
                Sort.swap(x, l, l + 1);
                Sort.swap(y, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = x[l + 1];
            b = y[l + 1];
            while (true) {
                if (x[++i] < a) {
                    continue;
                }
                while (x[--j] > a) {
                }
                if (j < i) break;
                Sort.swap(x, i, j);
                Sort.swap(y, i, j);
            }
            x[l + 1] = x[j];
            x[j] = a;
            y[l + 1] = y[j];
            y[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static void sort(int[] x, Object[] y) {
        QuickSort.sort(x, y, x.length);
    }

    public static void sort(int[] x, Object[] y, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            Object b;
            int a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = x[j];
                    b = y[j];
                    for (i = j - 1; i >= l && x[i] > a; --i) {
                        x[i + 1] = x[i];
                        y[i + 1] = y[i];
                    }
                    x[i + 1] = a;
                    y[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            Sort.swap(x, k, l + 1);
            Sort.swap(y, k, l + 1);
            if (x[l] > x[ir]) {
                Sort.swap(x, l, ir);
                Sort.swap(y, l, ir);
            }
            if (x[l + 1] > x[ir]) {
                Sort.swap(x, l + 1, ir);
                Sort.swap(y, l + 1, ir);
            }
            if (x[l] > x[l + 1]) {
                Sort.swap(x, l, l + 1);
                Sort.swap(y, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = x[l + 1];
            b = y[l + 1];
            while (true) {
                if (x[++i] < a) {
                    continue;
                }
                while (x[--j] > a) {
                }
                if (j < i) break;
                Sort.swap(x, i, j);
                Sort.swap(y, i, j);
            }
            x[l + 1] = x[j];
            x[j] = a;
            y[l + 1] = y[j];
            y[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static int[] sort(float[] x) {
        int[] order = new int[x.length];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        QuickSort.sort(x, order);
        return order;
    }

    public static void sort(float[] x, int[] y) {
        QuickSort.sort(x, y, x.length);
    }

    public static void sort(float[] x, int[] y, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            int b;
            float a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = x[j];
                    b = y[j];
                    for (i = j - 1; i >= l && !(x[i] <= a); --i) {
                        x[i + 1] = x[i];
                        y[i + 1] = y[i];
                    }
                    x[i + 1] = a;
                    y[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            Sort.swap(x, k, l + 1);
            Sort.swap(y, k, l + 1);
            if (x[l] > x[ir]) {
                Sort.swap(x, l, ir);
                Sort.swap(y, l, ir);
            }
            if (x[l + 1] > x[ir]) {
                Sort.swap(x, l + 1, ir);
                Sort.swap(y, l + 1, ir);
            }
            if (x[l] > x[l + 1]) {
                Sort.swap(x, l, l + 1);
                Sort.swap(y, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = x[l + 1];
            b = y[l + 1];
            while (true) {
                if (x[++i] < a) {
                    continue;
                }
                while (x[--j] > a) {
                }
                if (j < i) break;
                Sort.swap(x, i, j);
                Sort.swap(y, i, j);
            }
            x[l + 1] = x[j];
            x[j] = a;
            y[l + 1] = y[j];
            y[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static void sort(float[] x, float[] y) {
        QuickSort.sort(x, y, x.length);
    }

    public static void sort(float[] x, float[] y, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            float b;
            float a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = x[j];
                    b = y[j];
                    for (i = j - 1; i >= l && !(x[i] <= a); --i) {
                        x[i + 1] = x[i];
                        y[i + 1] = y[i];
                    }
                    x[i + 1] = a;
                    y[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            Sort.swap(x, k, l + 1);
            Sort.swap(y, k, l + 1);
            if (x[l] > x[ir]) {
                Sort.swap(x, l, ir);
                Sort.swap(y, l, ir);
            }
            if (x[l + 1] > x[ir]) {
                Sort.swap(x, l + 1, ir);
                Sort.swap(y, l + 1, ir);
            }
            if (x[l] > x[l + 1]) {
                Sort.swap(x, l, l + 1);
                Sort.swap(y, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = x[l + 1];
            b = y[l + 1];
            while (true) {
                if (x[++i] < a) {
                    continue;
                }
                while (x[--j] > a) {
                }
                if (j < i) break;
                Sort.swap(x, i, j);
                Sort.swap(y, i, j);
            }
            x[l + 1] = x[j];
            x[j] = a;
            y[l + 1] = y[j];
            y[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static void sort(float[] x, Object[] y) {
        QuickSort.sort(x, y, x.length);
    }

    public static void sort(float[] x, Object[] y, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            Object b;
            float a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = x[j];
                    b = y[j];
                    for (i = j - 1; i >= l && !(x[i] <= a); --i) {
                        x[i + 1] = x[i];
                        y[i + 1] = y[i];
                    }
                    x[i + 1] = a;
                    y[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            Sort.swap(x, k, l + 1);
            Sort.swap(y, k, l + 1);
            if (x[l] > x[ir]) {
                Sort.swap(x, l, ir);
                Sort.swap(y, l, ir);
            }
            if (x[l + 1] > x[ir]) {
                Sort.swap(x, l + 1, ir);
                Sort.swap(y, l + 1, ir);
            }
            if (x[l] > x[l + 1]) {
                Sort.swap(x, l, l + 1);
                Sort.swap(y, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = x[l + 1];
            b = y[l + 1];
            while (true) {
                if (x[++i] < a) {
                    continue;
                }
                while (x[--j] > a) {
                }
                if (j < i) break;
                Sort.swap(x, i, j);
                Sort.swap(y, i, j);
            }
            x[l + 1] = x[j];
            x[j] = a;
            y[l + 1] = y[j];
            y[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static int[] sort(double[] x) {
        int[] order = new int[x.length];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        QuickSort.sort(x, order);
        return order;
    }

    public static void sort(double[] x, int[] y) {
        QuickSort.sort(x, y, x.length);
    }

    public static void sort(double[] x, int[] y, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            int b;
            double a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = x[j];
                    b = y[j];
                    for (i = j - 1; i >= l && !(x[i] <= a); --i) {
                        x[i + 1] = x[i];
                        y[i + 1] = y[i];
                    }
                    x[i + 1] = a;
                    y[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            Sort.swap(x, k, l + 1);
            Sort.swap(y, k, l + 1);
            if (x[l] > x[ir]) {
                Sort.swap(x, l, ir);
                Sort.swap(y, l, ir);
            }
            if (x[l + 1] > x[ir]) {
                Sort.swap(x, l + 1, ir);
                Sort.swap(y, l + 1, ir);
            }
            if (x[l] > x[l + 1]) {
                Sort.swap(x, l, l + 1);
                Sort.swap(y, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = x[l + 1];
            b = y[l + 1];
            while (true) {
                if (x[++i] < a) {
                    continue;
                }
                while (x[--j] > a) {
                }
                if (j < i) break;
                Sort.swap(x, i, j);
                Sort.swap(y, i, j);
            }
            x[l + 1] = x[j];
            x[j] = a;
            y[l + 1] = y[j];
            y[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static void sort(double[] x, double[] y) {
        QuickSort.sort(x, y, x.length);
    }

    public static void sort(double[] x, double[] y, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            double b;
            double a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = x[j];
                    b = y[j];
                    for (i = j - 1; i >= l && !(x[i] <= a); --i) {
                        x[i + 1] = x[i];
                        y[i + 1] = y[i];
                    }
                    x[i + 1] = a;
                    y[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            Sort.swap(x, k, l + 1);
            Sort.swap(y, k, l + 1);
            if (x[l] > x[ir]) {
                Sort.swap(x, l, ir);
                Sort.swap(y, l, ir);
            }
            if (x[l + 1] > x[ir]) {
                Sort.swap(x, l + 1, ir);
                Sort.swap(y, l + 1, ir);
            }
            if (x[l] > x[l + 1]) {
                Sort.swap(x, l, l + 1);
                Sort.swap(y, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = x[l + 1];
            b = y[l + 1];
            while (true) {
                if (x[++i] < a) {
                    continue;
                }
                while (x[--j] > a) {
                }
                if (j < i) break;
                Sort.swap(x, i, j);
                Sort.swap(y, i, j);
            }
            x[l + 1] = x[j];
            x[j] = a;
            y[l + 1] = y[j];
            y[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static void sort(double[] x, Object[] y) {
        QuickSort.sort(x, y, x.length);
    }

    public static void sort(double[] x, Object[] y, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            Object b;
            double a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = x[j];
                    b = y[j];
                    for (i = j - 1; i >= l && !(x[i] <= a); --i) {
                        x[i + 1] = x[i];
                        y[i + 1] = y[i];
                    }
                    x[i + 1] = a;
                    y[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            Sort.swap(x, k, l + 1);
            Sort.swap(y, k, l + 1);
            if (x[l] > x[ir]) {
                Sort.swap(x, l, ir);
                Sort.swap(y, l, ir);
            }
            if (x[l + 1] > x[ir]) {
                Sort.swap(x, l + 1, ir);
                Sort.swap(y, l + 1, ir);
            }
            if (x[l] > x[l + 1]) {
                Sort.swap(x, l, l + 1);
                Sort.swap(y, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = x[l + 1];
            b = y[l + 1];
            while (true) {
                if (x[++i] < a) {
                    continue;
                }
                while (x[--j] > a) {
                }
                if (j < i) break;
                Sort.swap(x, i, j);
                Sort.swap(y, i, j);
            }
            x[l + 1] = x[j];
            x[j] = a;
            y[l + 1] = y[j];
            y[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static <T extends Comparable<? super T>> int[] sort(T[] x) {
        int[] order = new int[x.length];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        QuickSort.sort(x, (int[])order);
        return order;
    }

    public static <T extends Comparable<? super T>> void sort(T[] x, int[] y) {
        QuickSort.sort(x, (int[])y, (int)x.length);
    }

    public static <T extends Comparable<? super T>> void sort(T[] x, int[] y, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            int b;
            T a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = x[j];
                    b = y[j];
                    for (i = j - 1; i >= l && x[i].compareTo(a) > 0; --i) {
                        x[i + 1] = x[i];
                        y[i + 1] = y[i];
                    }
                    x[i + 1] = a;
                    y[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            Sort.swap(x, k, l + 1);
            Sort.swap(y, k, l + 1);
            if (x[l].compareTo(x[ir]) > 0) {
                Sort.swap(x, l, ir);
                Sort.swap(y, l, ir);
            }
            if (x[l + 1].compareTo(x[ir]) > 0) {
                Sort.swap(x, l + 1, ir);
                Sort.swap(y, l + 1, ir);
            }
            if (x[l].compareTo(x[l + 1]) > 0) {
                Sort.swap(x, l, l + 1);
                Sort.swap(y, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = x[l + 1];
            b = y[l + 1];
            while (true) {
                if (x[++i].compareTo(a) < 0) {
                    continue;
                }
                while (x[--j].compareTo(a) > 0) {
                }
                if (j < i) break;
                Sort.swap(x, i, j);
                Sort.swap(y, i, j);
            }
            x[l + 1] = x[j];
            x[j] = a;
            y[l + 1] = y[j];
            y[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static <T> void sort(T[] x, int[] y, int n, Comparator<T> comparator) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            int b;
            T a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = x[j];
                    b = y[j];
                    for (i = j - 1; i >= l && comparator.compare(x[i], a) > 0; --i) {
                        x[i + 1] = x[i];
                        y[i + 1] = y[i];
                    }
                    x[i + 1] = a;
                    y[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            Sort.swap(x, k, l + 1);
            Sort.swap(y, k, l + 1);
            if (comparator.compare(x[l], x[ir]) > 0) {
                Sort.swap(x, l, ir);
                Sort.swap(y, l, ir);
            }
            if (comparator.compare(x[l + 1], x[ir]) > 0) {
                Sort.swap(x, l + 1, ir);
                Sort.swap(y, l + 1, ir);
            }
            if (comparator.compare(x[l], x[l + 1]) > 0) {
                Sort.swap(x, l, l + 1);
                Sort.swap(y, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = x[l + 1];
            b = y[l + 1];
            while (true) {
                if (comparator.compare(x[++i], a) < 0) {
                    continue;
                }
                while (comparator.compare(x[--j], a) > 0) {
                }
                if (j < i) break;
                Sort.swap(x, i, j);
                Sort.swap(y, i, j);
            }
            x[l + 1] = x[j];
            x[j] = a;
            y[l + 1] = y[j];
            y[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }

    public static <T extends Comparable<? super T>> void sort(T[] x, Object[] y) {
        QuickSort.sort(x, (Object[])y, (int)x.length);
    }

    public static <T extends Comparable<? super T>> void sort(T[] x, Object[] y, int n) {
        int jstack = -1;
        int l = 0;
        int[] istack = new int[64];
        int ir = n - 1;
        while (true) {
            int i;
            Object b;
            T a;
            int j;
            if (ir - l < 7) {
                for (j = l + 1; j <= ir; ++j) {
                    a = x[j];
                    b = y[j];
                    for (i = j - 1; i >= l && x[i].compareTo(a) > 0; --i) {
                        x[i + 1] = x[i];
                        y[i + 1] = y[i];
                    }
                    x[i + 1] = a;
                    y[i + 1] = b;
                }
                if (jstack < 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            Sort.swap(x, k, l + 1);
            Sort.swap(y, k, l + 1);
            if (x[l].compareTo(x[ir]) > 0) {
                Sort.swap(x, l, ir);
                Sort.swap(y, l, ir);
            }
            if (x[l + 1].compareTo(x[ir]) > 0) {
                Sort.swap(x, l + 1, ir);
                Sort.swap(y, l + 1, ir);
            }
            if (x[l].compareTo(x[l + 1]) > 0) {
                Sort.swap(x, l, l + 1);
                Sort.swap(y, l, l + 1);
            }
            i = l + 1;
            j = ir;
            a = x[l + 1];
            b = y[l + 1];
            while (true) {
                if (x[++i].compareTo(a) < 0) {
                    continue;
                }
                while (x[--j].compareTo(a) > 0) {
                }
                if (j < i) break;
                Sort.swap(x, i, j);
                Sort.swap(y, i, j);
            }
            x[l + 1] = x[j];
            x[j] = a;
            y[l + 1] = y[j];
            y[j] = b;
            if ((jstack += 2) >= 64) {
                throw new IllegalStateException("NSTACK too small in sort.");
            }
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
    }
}

