/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.MathEx;
import smile.math.kernel.Gaussian;
import smile.math.kernel.MercerKernel;
import smile.util.SparseArray;

public class SparseGaussianKernel
extends Gaussian
implements MercerKernel<SparseArray> {
    public SparseGaussianKernel(double sigma) {
        this(sigma, 1.0E-5, 100000.0);
    }

    public SparseGaussianKernel(double sigma, double lo, double hi) {
        super(sigma, lo, hi);
    }

    @Override
    public double k(SparseArray x, SparseArray y) {
        return this.k(MathEx.distance(x, y));
    }

    @Override
    public double[] kg(SparseArray x, SparseArray y) {
        return this.kg(MathEx.distance(x, y));
    }

    public SparseGaussianKernel of(double[] params) {
        return new SparseGaussianKernel(params[0], this.lo, this.hi);
    }

    @Override
    public double[] hyperparameters() {
        return new double[]{this.sigma};
    }

    @Override
    public double[] lo() {
        return new double[]{this.lo};
    }

    @Override
    public double[] hi() {
        return new double[]{this.hi};
    }
}

