/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.BaseVector;
import smile.data.vector.CharVectorImpl;

public interface CharVector
extends BaseVector<Character, Integer, IntStream> {
    @Override
    default public DataType type() {
        return DataTypes.CharType;
    }

    public char[] array();

    public CharVector get(int ... var1);

    public char getChar(int var1);

    @Override
    default public byte getByte(int i) {
        throw new UnsupportedOperationException("cast char to byte");
    }

    @Override
    default public short getShort(int i) {
        throw new UnsupportedOperationException("cast char to byte");
    }

    @Override
    default public int getInt(int i) {
        return this.getChar(i);
    }

    @Override
    default public long getLong(int i) {
        return this.getChar(i);
    }

    @Override
    default public float getFloat(int i) {
        return this.getChar(i);
    }

    @Override
    default public double getDouble(int i) {
        return this.getChar(i);
    }

    default public String toString(int n) {
        String suffix = n >= this.size() ? "]" : String.format(", ... %,d more]", this.size() - n);
        return ((IntStream)this.stream()).limit(n).mapToObj(String::valueOf).collect(Collectors.joining(", ", "[", suffix));
    }

    public static CharVector of(String name, char[] vector) {
        return new CharVectorImpl(name, vector);
    }

    public static CharVector of(StructField field, char[] vector) {
        return new CharVectorImpl(field, vector);
    }
}

