/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.mojo;

import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.github.eirslett.maven.plugins.frontend.mojo.AbstractFrontendMojo;
import com.github.eirslett.maven.plugins.frontend.mojo.MojoUtils;
import com.github.eirslett.maven.plugins.frontend.mojo.YarnUtils;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="install-node-and-yarn", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public final class InstallNodeAndYarnMojo
extends AbstractFrontendMojo {
    private static final String YARNRC_YAML_FILE_NAME = ".yarnrc.yml";
    @Parameter(property="nodeDownloadRoot", required=false)
    private String nodeDownloadRoot;
    @Parameter(property="yarnDownloadRoot", required=false, defaultValue="https://github.com/yarnpkg/yarn/releases/download/")
    private String yarnDownloadRoot;
    @Parameter(property="nodeVersion", required=true)
    private String nodeVersion;
    @Parameter(property="yarnVersion", required=true)
    private String yarnVersion;
    @Parameter(property="serverId", defaultValue="")
    private String serverId;
    @Parameter(property="session", defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="skip.installyarn", alias="skip.installyarn", defaultValue="${skip.installyarn}")
    private boolean skip;
    @Component(role=SettingsDecrypter.class)
    private SettingsDecrypter decrypter;

    @Override
    protected boolean skipExecution() {
        return this.skip;
    }

    @Override
    public void execute(FrontendPluginFactory factory) throws InstallationException {
        ProxyConfig proxyConfig = MojoUtils.getProxyConfig(this.session, this.decrypter);
        Server server = MojoUtils.decryptServer(this.serverId, this.session, this.decrypter);
        boolean isYarnYamlFilePresent = YarnUtils.isYarnrcYamlFilePresent(this.session, this.workingDirectory);
        if (null != server) {
            Map<String, String> httpHeaders = this.getHttpHeaders(server);
            factory.getNodeInstaller(proxyConfig).setNodeDownloadRoot(this.nodeDownloadRoot).setNodeVersion(this.nodeVersion).setUserName(server.getUsername()).setPassword(server.getPassword()).setHttpHeaders(httpHeaders).install();
            factory.getYarnInstaller(proxyConfig).setYarnDownloadRoot(this.yarnDownloadRoot).setYarnVersion(this.yarnVersion).setUserName(server.getUsername()).setPassword(server.getPassword()).setHttpHeaders(httpHeaders).setIsYarnBerry(isYarnYamlFilePresent).install();
        } else {
            factory.getNodeInstaller(proxyConfig).setNodeDownloadRoot(this.nodeDownloadRoot).setNodeVersion(this.nodeVersion).install();
            factory.getYarnInstaller(proxyConfig).setYarnDownloadRoot(this.yarnDownloadRoot).setYarnVersion(this.yarnVersion).setIsYarnBerry(isYarnYamlFilePresent).install();
        }
    }
}

