/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.persistence.entity;

import com.franciaflex.magalie.persistence.entity.Company;
import com.franciaflex.magalie.persistence.entity.Location;
import com.franciaflex.magalie.persistence.entity.Supplier;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import org.nuiton.jpa.api.AbstractJpaEntity;
import org.nuiton.jpa.api.JpaEntities;
import org.nuiton.jpa.api.JpaEntity;
import org.nuiton.jpa.api.JpaEntityIdFactoryResolver;

@MappedSuperclass
public abstract class AbstractJpaArticle
extends AbstractJpaEntity
implements Serializable {
    private static final long serialVersionUID = 7161904709017940788L;
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_CODE = "code";
    public static final String PROPERTY_UNIT = "unit";
    public static final String PROPERTY_FIXED_LOCATIONS_FIRST = "fixedLocationsFirst";
    public static final String PROPERTY_DIRECT_WITHDRAW_ALLOWED = "directWithdrawAllowed";
    public static final String PROPERTY_FIXED_LOCATIONS = "fixedLocations";
    public static final String PROPERTY_SUPPLIER = "supplier";
    public static final String PROPERTY_COMPANY = "company";
    @Id
    protected String id;
    protected String description;
    protected String code;
    protected String unit;
    protected boolean fixedLocationsFirst;
    protected boolean directWithdrawAllowed;
    @ManyToMany
    protected Set<Location> fixedLocations;
    @ManyToOne
    protected Supplier supplier;
    @ManyToOne
    protected Company company;

    @PrePersist
    public void prePersist() {
        if (this.id == null) {
            this.id = new JpaEntityIdFactoryResolver().newId((JpaEntity)this);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public boolean isFixedLocationsFirst() {
        return this.fixedLocationsFirst;
    }

    public void setFixedLocationsFirst(boolean fixedLocationsFirst) {
        this.fixedLocationsFirst = fixedLocationsFirst;
    }

    public boolean isDirectWithdrawAllowed() {
        return this.directWithdrawAllowed;
    }

    public void setDirectWithdrawAllowed(boolean directWithdrawAllowed) {
        this.directWithdrawAllowed = directWithdrawAllowed;
    }

    public Location getFixedLocations(int index) {
        Location o = this.getChild(this.fixedLocations, index);
        return o;
    }

    public Location getFixedLocationsById(String id) {
        Location o = (Location)JpaEntities.findById(this.fixedLocations, (String)id);
        return o;
    }

    public boolean isFixedLocationsEmpty() {
        return this.fixedLocations == null || this.fixedLocations.isEmpty();
    }

    public int sizeFixedLocations() {
        return this.fixedLocations == null ? 0 : this.fixedLocations.size();
    }

    public void addFixedLocations(Location fixedLocations) {
        if (this.getFixedLocations() == null) {
            this.setFixedLocations(new HashSet<Location>());
        }
        this.getFixedLocations().add(fixedLocations);
    }

    public void addAllFixedLocations(Collection<Location> fixedLocations) {
        if (this.getFixedLocations() == null) {
            this.setFixedLocations(new HashSet<Location>());
        }
        this.getFixedLocations().addAll(fixedLocations);
    }

    public boolean removeFixedLocations(Location fixedLocations) {
        boolean removed = this.getFixedLocations() != null && this.getFixedLocations().remove(fixedLocations);
        return removed;
    }

    public boolean removeAllFixedLocations(Collection<Location> fixedLocations) {
        boolean removed = this.getFixedLocations() != null && this.getFixedLocations().removeAll(fixedLocations);
        return removed;
    }

    public boolean containsFixedLocations(Location fixedLocations) {
        boolean contains = this.getFixedLocations() != null && this.getFixedLocations().contains(fixedLocations);
        return contains;
    }

    public boolean containsFixedLocationsById(String id) {
        boolean contains = this.getFixedLocations() != null && this.getFixedLocationsById(id) != null;
        return contains;
    }

    public boolean containsAllFixedLocations(Collection<Location> fixedLocations) {
        boolean contains = this.getFixedLocations() != null && this.getFixedLocations().containsAll(fixedLocations);
        return contains;
    }

    public Set<Location> getFixedLocations() {
        return this.fixedLocations;
    }

    public void setFixedLocations(Set<Location> fixedLocations) {
        this.fixedLocations = fixedLocations;
    }

    public Supplier getSupplier() {
        return this.supplier;
    }

    public void setSupplier(Supplier supplier) {
        this.supplier = supplier;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    protected <T> T getChild(Collection<T> childs, int index) {
        T result = null;
        if (childs != null) {
            if (childs instanceof List) {
                if (index < childs.size()) {
                    result = (T)((List)childs).get(index);
                }
            } else {
                int i = 0;
                for (T o : childs) {
                    if (index == i) {
                        result = o;
                        break;
                    }
                    ++i;
                }
            }
        }
        return result;
    }
}

