/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.persistence.dao;

import com.franciaflex.magalie.persistence.Locations;
import com.franciaflex.magalie.persistence.dao.AbstractLocationJpaDao;
import com.franciaflex.magalie.persistence.entity.Building;
import com.franciaflex.magalie.persistence.entity.Location;
import com.franciaflex.magalie.persistence.entity.Warehouse;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;

public class LocationJpaDao
extends AbstractLocationJpaDao {
    public LocationJpaDao(EntityManager entityManager) {
        super(entityManager);
    }

    @Override
    public Location find(String code, Warehouse warehouse) {
        TypedQuery query = this.createQuery("from Location l where l.code = :code and l.warehouse = :warehouse");
        query.setParameter("code", (Object)code);
        query.setParameter("warehouse", (Object)warehouse);
        return (Location)this.findUnique(query);
    }

    @Override
    public List<Location> findAllWithoutReception(Warehouse warehouse, boolean limitExtraLocationsTo50) {
        String hql = " from Location l where";
        hql = hql + " l.warehouse = :warehouse and  l.code != :codeForReceptionLocations and  l.code != :codeForWarehouseWithoutLocations and  l.fullLocation = false  order by l.warehouse.building.code, l.warehouse.code, l.code";
        TypedQuery query = this.createQuery(hql);
        query.setParameter("warehouse", (Object)warehouse);
        query.setParameter("codeForReceptionLocations", (Object)Locations.codeForReceptionLocations());
        query.setParameter("codeForWarehouseWithoutLocations", (Object)Locations.codeForWarehouseWithoutLocations());
        if (limitExtraLocationsTo50) {
            query.setMaxResults(50);
        }
        return this.findAll(query);
    }

    @Override
    public Location findByBarcode(String barcode, Building building) {
        TypedQuery query = this.createQuery("from Location l where CONCAT(l.warehouse.code, l.code) = :barcode and l.warehouse.building = :building");
        query.setParameter("barcode", (Object)barcode);
        query.setParameter("building", (Object)building);
        return (Location)this.findUniqueOrNull(query);
    }
}

