/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.magalie.persistence;

import com.franciaflex.magalie.persistence.entity.RequestedList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import org.apache.commons.collections.comparators.BooleanComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestedLists {
    private static final Log log = LogFactory.getLog(RequestedLists.class);

    public static Comparator<RequestedList> urgentFirstComparator() {
        return new UrgentFirstComparator();
    }

    public static Comparator<RequestedList> requestDateFirstComparator() {
        return new RequestDateFistComparator();
    }

    public static Comparator<RequestedList> givenRequestListFirst(RequestedList requestedList) {
        return new GivenRequestListFirst(requestedList);
    }

    public static Comparator<RequestedList> comparator() {
        Ordering comparator = Ordering.compound((Iterable)Lists.newArrayList((Object[])new Comparator[]{RequestedLists.urgentFirstComparator(), RequestedLists.requestDateFirstComparator()}));
        return comparator;
    }

    protected static class RequestDateFistComparator
    implements Comparator<RequestedList> {
        protected RequestDateFistComparator() {
        }

        @Override
        public int compare(RequestedList x, RequestedList y) {
            int compare = x.getRequestDate().compareTo(y.getRequestDate());
            return compare;
        }
    }

    protected static class UrgentFirstComparator
    implements Comparator<RequestedList> {
        protected UrgentFirstComparator() {
        }

        @Override
        public int compare(RequestedList x, RequestedList y) {
            int compare = BooleanComparator.getTrueFirstComparator().compare(Boolean.valueOf(x.isUrgent()), Boolean.valueOf(y.isUrgent()));
            return compare;
        }
    }

    protected static class GivenRequestListFirst
    implements Comparator<RequestedList> {
        protected RequestedList requestedList;

        public GivenRequestListFirst(RequestedList requestedList) {
            this.requestedList = requestedList;
        }

        @Override
        public int compare(RequestedList x, RequestedList y) {
            return BooleanComparator.getTrueFirstComparator().compare(Boolean.valueOf(x.equals(this.requestedList)), Boolean.valueOf(y.equals(this.requestedList)));
        }
    }
}

