/* The following code was generated by JFlex 1.4.1 on 3/1/12 7:38 PM */

/*
 * 02/05/2012
 *
 * JavaScriptTokenMaker.java - Parses a document into JavaScript tokens.
 * 
 * This library is distributed under a modified BSD license.  See the included
 * RSyntaxTextArea.License.txt file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for JavaScript files.  Its states could be simplified, but are
 * kept the way they are to keep a degree of similarity (i.e. copy/paste)
 * between it and HTML/JSP/PHPTokenMaker.  This should cause no difference in
 * performance.<p>
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated JavaScriptTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.8
 *
 */

public class JavaScriptTokenMaker extends AbstractJFlexCTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int JS_STRING = 1;
  public static final int JS_CHAR = 2;
  public static final int JS_EOL_COMMENT = 4;
  public static final int YYINITIAL = 0;
  public static final int JS_MLC = 3;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\1\1\2\1\0\1\1\1\11\22\0\1\1\1\34\1\74"+
    "\1\12\1\3\1\34\1\36\1\42\2\41\1\16\1\27\1\26\1\23"+
    "\1\24\1\15\1\5\7\7\2\4\1\37\1\26\1\30\1\31\1\33"+
    "\1\35\1\12\3\6\1\21\1\22\1\73\2\3\1\72\2\3\1\20"+
    "\1\3\1\71\11\3\1\17\2\3\1\41\1\13\1\41\1\32\1\14"+
    "\1\0\1\56\1\54\1\60\1\63\1\52\1\47\1\66\1\43\1\50"+
    "\1\3\1\57\1\51\1\40\1\62\1\61\1\45\1\3\1\55\1\46"+
    "\1\44\1\10\1\65\1\53\1\67\1\64\1\70\1\25\1\32\1\25"+
    "\1\35\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\5\0\1\1\1\2\1\3\1\4\2\5\1\4\1\1"+
    "\3\6\1\4\1\7\1\4\5\6\1\10\22\4\1\11"+
    "\1\12\1\13\1\14\1\15\1\12\1\16\1\17\1\20"+
    "\1\12\1\21\5\12\1\22\1\1\1\23\1\5\1\24"+
    "\1\23\1\24\1\23\1\25\1\23\1\4\2\0\1\26"+
    "\1\27\1\6\1\0\1\6\22\4\2\30\25\4\1\30"+
    "\4\4\1\31\1\32\1\33\1\34\4\0\1\1\1\24"+
    "\1\0\2\25\1\4\1\35\1\0\26\4\1\36\35\4"+
    "\6\0\1\1\1\37\1\4\1\40\21\4\1\36\1\4"+
    "\1\41\16\4\1\0\1\12\2\0\1\42\1\1\1\30"+
    "\10\4\1\30\15\4\2\0\1\1\14\4\1\43\17\4";

  private static int [] zzUnpackAction() {
    int [] result = new int[295];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\75\0\172\0\267\0\364\0\u0131\0\u016e\0\u01ab"+
    "\0\u01e8\0\u0225\0\u0262\0\u029f\0\u01ab\0\u02dc\0\u0319\0\u0356"+
    "\0\u0393\0\u01ab\0\u01ab\0\u03d0\0\u040d\0\u044a\0\u01ab\0\u0487"+
    "\0\u01ab\0\u04c4\0\u0501\0\u053e\0\u057b\0\u05b8\0\u05f5\0\u0632"+
    "\0\u066f\0\u06ac\0\u06e9\0\u0726\0\u0763\0\u07a0\0\u07dd\0\u081a"+
    "\0\u0857\0\u0894\0\u08d1\0\u01ab\0\u090e\0\u01ab\0\u094b\0\u01ab"+
    "\0\u0988\0\u01ab\0\u094b\0\u01ab\0\u09c5\0\u01ab\0\u0a02\0\u0a3f"+
    "\0\u0a7c\0\u0ab9\0\u0af6\0\u01ab\0\u0b33\0\u0b70\0\u0b70\0\u0b70"+
    "\0\u0bad\0\u0bea\0\u0c27\0\u0c64\0\u0ca1\0\u0cde\0\u0d1b\0\u0d58"+
    "\0\u01ab\0\u0d95\0\u0d1b\0\u0319\0\u0dd2\0\u0e0f\0\u0e4c\0\u0e89"+
    "\0\u0ec6\0\u0f03\0\u0f40\0\u0f7d\0\u0fba\0\u0ff7\0\u1034\0\u1071"+
    "\0\u10ae\0\u10eb\0\u1128\0\u1165\0\u11a2\0\u11df\0\u121c\0\u01e8"+
    "\0\u1259\0\u1296\0\u12d3\0\u1310\0\u134d\0\u138a\0\u13c7\0\u1404"+
    "\0\u1441\0\u147e\0\u14bb\0\u14f8\0\u1535\0\u1572\0\u15af\0\u15ec"+
    "\0\u1629\0\u1666\0\u16a3\0\u16e0\0\u171d\0\u175a\0\u1797\0\u17d4"+
    "\0\u1811\0\u184e\0\u188b\0\u01ab\0\u18c8\0\u1905\0\u01ab\0\u1942"+
    "\0\u197f\0\u19bc\0\u19f9\0\u1a36\0\u1a73\0\u1ab0\0\u0b70\0\u1aed"+
    "\0\u1b2a\0\u1b67\0\u1ba4\0\u1be1\0\u1c1e\0\u1c5b\0\u1c98\0\u1cd5"+
    "\0\u1d12\0\u1d4f\0\u1d8c\0\u1dc9\0\u1e06\0\u1e43\0\u1e80\0\u1ebd"+
    "\0\u1efa\0\u1f37\0\u1f74\0\u1fb1\0\u1fee\0\u202b\0\u2068\0\u20a5"+
    "\0\u20e2\0\u211f\0\u215c\0\u2199\0\u21d6\0\u2213\0\u2250\0\u228d"+
    "\0\u22ca\0\u2307\0\u2344\0\u2381\0\u23be\0\u23fb\0\u2438\0\u2475"+
    "\0\u24b2\0\u24ef\0\u252c\0\u2569\0\u25a6\0\u25e3\0\u2620\0\u265d"+
    "\0\u269a\0\u26d7\0\u2714\0\u2751\0\u278e\0\u27cb\0\u2808\0\u2845"+
    "\0\u2882\0\u28bf\0\u28fc\0\u2939\0\u2976\0\u29b3\0\u01ab\0\u29f0"+
    "\0\u01e8\0\u2a2d\0\u2a6a\0\u2aa7\0\u2ae4\0\u2b21\0\u2b5e\0\u2b9b"+
    "\0\u2bd8\0\u2c15\0\u2c52\0\u2c8f\0\u2ccc\0\u2d09\0\u2d46\0\u2d83"+
    "\0\u2dc0\0\u2dfd\0\u01e8\0\u2e3a\0\u01e8\0\u2e77\0\u2eb4\0\u2ef1"+
    "\0\u2f2e\0\u2f6b\0\u2fa8\0\u2fe5\0\u3022\0\u305f\0\u309c\0\u30d9"+
    "\0\u3116\0\u3153\0\u3190\0\u1905\0\u01ab\0\u31cd\0\u320a\0\u3247"+
    "\0\u3284\0\u1be1\0\u32c1\0\u32fe\0\u333b\0\u3378\0\u33b5\0\u33f2"+
    "\0\u342f\0\u346c\0\u34a9\0\u34e6\0\u3523\0\u3560\0\u359d\0\u35da"+
    "\0\u3617\0\u3654\0\u3691\0\u36ce\0\u370b\0\u3748\0\u3785\0\u37c2"+
    "\0\u37ff\0\u3247\0\u383c\0\u3879\0\u38b6\0\u38f3\0\u3930\0\u396d"+
    "\0\u39aa\0\u39e7\0\u3a24\0\u3a61\0\u3a9e\0\u3adb\0\u3b18\0\u01e8"+
    "\0\u3b55\0\u3b92\0\u3bcf\0\u3c0c\0\u3c49\0\u3c86\0\u3cc3\0\u3d00"+
    "\0\u3d3d\0\u3d7a\0\u3db7\0\u3df4\0\u3e31\0\u3e6e\0\u3eab";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[295];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\6\1\7\1\10\1\11\1\12\1\13\1\11\1\12"+
    "\1\14\1\15\2\6\1\11\1\16\1\17\4\11\1\20"+
    "\1\21\1\22\1\23\1\24\1\25\2\17\1\26\1\17"+
    "\1\27\1\30\1\27\1\11\1\22\1\31\1\11\1\32"+
    "\1\33\1\34\1\35\1\36\1\37\1\40\1\41\1\42"+
    "\1\43\1\44\1\11\1\45\1\11\1\46\1\47\1\11"+
    "\1\50\1\51\2\11\1\52\1\53\1\11\1\54\2\55"+
    "\1\56\10\55\1\57\60\55\1\60\2\61\1\62\10\61"+
    "\1\63\26\61\1\64\32\61\2\65\1\66\13\65\1\67"+
    "\24\65\1\70\3\65\1\71\3\65\1\72\21\65\2\73"+
    "\1\74\40\73\1\70\3\73\1\71\3\73\1\72\21\73"+
    "\1\6\2\0\6\6\1\0\3\6\2\0\4\6\15\0"+
    "\1\6\2\0\31\6\2\0\1\7\170\0\1\6\2\0"+
    "\6\11\1\0\1\6\1\75\1\11\2\0\4\11\15\0"+
    "\1\11\2\0\31\11\1\0\1\76\2\0\1\76\2\12"+
    "\1\76\1\12\1\76\1\0\3\76\2\0\1\76\1\77"+
    "\1\100\1\101\1\0\1\102\13\0\1\76\2\0\4\76"+
    "\1\100\1\76\1\77\1\101\10\76\1\100\7\76\1\100"+
    "\1\0\1\76\2\0\1\76\1\103\1\104\1\76\1\104"+
    "\1\76\1\0\3\76\2\0\1\105\1\77\1\100\1\101"+
    "\1\0\1\102\13\0\1\76\2\0\4\76\1\100\1\76"+
    "\1\77\1\101\10\76\1\100\3\76\1\105\3\76\1\100"+
    "\1\0\1\6\2\0\6\11\1\0\1\6\1\75\1\11"+
    "\2\0\4\11\15\0\1\11\2\0\17\11\1\106\11\11"+
    "\1\0\13\107\1\110\1\107\1\111\1\112\12\107\1\113"+
    "\43\107\31\0\1\27\66\0\1\27\5\0\1\27\47\0"+
    "\2\102\1\0\1\102\114\0\1\27\1\0\1\27\73\0"+
    "\1\114\1\27\74\0\1\27\1\0\1\115\72\0\1\27"+
    "\4\0\1\27\36\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\1\116"+
    "\11\11\1\117\6\11\1\120\7\11\1\0\1\6\2\0"+
    "\5\11\1\121\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\12\11\1\122\1\123\15\11\1\0"+
    "\1\6\2\0\5\11\1\124\1\0\1\6\1\75\1\11"+
    "\2\0\4\11\15\0\1\11\2\0\1\125\1\126\6\11"+
    "\1\127\10\11\1\130\7\11\1\0\1\6\2\0\5\11"+
    "\1\131\1\0\1\6\1\75\1\11\2\0\4\11\15\0"+
    "\1\11\2\0\5\11\1\132\1\133\4\11\1\134\2\11"+
    "\1\135\12\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\136\2\0\3\11"+
    "\1\137\1\140\12\11\1\141\11\11\1\0\1\6\2\0"+
    "\6\11\1\0\1\6\1\75\1\11\2\0\4\11\15\0"+
    "\1\11\2\0\16\11\1\142\12\11\1\0\1\6\2\0"+
    "\6\11\1\0\1\6\1\75\1\11\2\0\4\11\15\0"+
    "\1\11\2\0\3\11\1\143\2\11\1\144\10\11\1\145"+
    "\2\11\1\146\1\11\1\147\4\11\1\0\1\6\2\0"+
    "\6\11\1\0\1\6\1\75\1\11\2\0\4\11\15\0"+
    "\1\11\2\0\1\150\4\11\1\151\23\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\12\11\1\152\3\11\1\153\2\11"+
    "\1\154\7\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\7\11"+
    "\1\155\21\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\11\11"+
    "\1\156\17\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\1\157"+
    "\5\11\1\160\4\11\1\161\2\11\1\162\12\11\1\0"+
    "\1\6\2\0\5\11\1\163\1\0\1\6\1\75\1\11"+
    "\2\0\4\11\15\0\1\11\2\0\7\11\1\164\3\11"+
    "\1\165\15\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\7\11"+
    "\1\166\6\11\1\167\12\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\13\11\1\135\2\11\1\170\12\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\16\11\1\171\12\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\13\11\1\172\15\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\17\11\1\173\11\11\1\0\2\55"+
    "\1\0\10\55\1\0\60\55\1\0\2\174\1\0\5\174"+
    "\1\175\56\174\1\176\5\174\2\61\1\0\10\61\1\0"+
    "\26\61\1\0\32\61\2\65\1\0\13\65\1\0\24\65"+
    "\1\0\3\65\1\0\3\65\1\0\21\65\15\0\1\177"+
    "\123\0\1\200\74\0\1\201\3\0\1\202\77\0\1\203"+
    "\21\0\2\73\1\0\40\73\1\0\3\73\1\0\3\73"+
    "\1\0\21\73\1\6\2\0\5\6\1\204\1\0\3\6"+
    "\2\0\4\6\15\0\1\6\2\0\31\6\1\0\1\76"+
    "\2\0\6\76\1\0\3\76\2\0\4\76\15\0\1\76"+
    "\2\0\31\76\1\0\1\76\2\0\1\76\2\205\1\76"+
    "\1\205\1\76\1\0\3\76\2\0\4\76\1\206\3\0"+
    "\1\206\10\0\1\76\2\0\31\76\1\0\1\76\2\0"+
    "\1\76\2\102\1\76\1\102\1\76\1\0\3\76\2\0"+
    "\2\76\1\100\1\101\15\0\1\76\2\0\4\76\1\100"+
    "\2\76\1\101\10\76\1\100\7\76\1\100\1\0\1\76"+
    "\2\0\1\76\2\103\1\76\1\103\1\76\1\0\3\76"+
    "\2\0\2\76\1\100\1\101\1\0\1\102\13\0\1\76"+
    "\2\0\4\76\1\100\2\76\1\101\10\76\1\100\7\76"+
    "\1\100\1\0\1\76\2\0\1\76\1\103\1\104\1\76"+
    "\1\104\1\76\1\0\3\76\2\0\1\76\1\207\1\100"+
    "\1\101\1\0\1\102\13\0\1\76\2\0\4\76\1\100"+
    "\1\76\1\207\1\101\10\76\1\100\7\76\1\100\1\0"+
    "\1\76\2\0\1\76\4\210\1\76\1\0\3\76\2\0"+
    "\2\76\2\210\15\0\1\76\2\0\4\76\1\210\2\76"+
    "\1\210\1\76\1\210\1\76\1\210\1\76\1\210\2\76"+
    "\1\210\7\76\1\210\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\7\11\1\211\21\11\1\0\13\107\1\110\1\107\1\212"+
    "\61\107\1\0\72\107\16\0\1\213\107\0\1\27\1\0"+
    "\1\17\41\0\1\6\2\0\6\11\1\0\1\6\1\75"+
    "\1\11\2\0\4\11\15\0\1\11\2\0\5\11\1\214"+
    "\4\11\1\215\16\11\1\0\1\6\2\0\5\11\1\216"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\13\11\1\217\5\11\1\140\7\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\2\11\1\220\26\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\11\11\1\221\17\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\5\11\1\222\10\11\1\223\12\11"+
    "\1\0\1\6\2\0\6\11\1\0\1\6\1\75\1\11"+
    "\2\0\4\11\15\0\1\11\2\0\12\11\1\224\2\11"+
    "\1\225\13\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\2\11"+
    "\1\226\26\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\16\11"+
    "\1\227\12\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\13\11"+
    "\1\230\15\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\5\11"+
    "\1\231\23\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\17\11"+
    "\1\232\11\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\17\11"+
    "\1\233\11\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\17\11"+
    "\1\234\11\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\16\11"+
    "\1\235\12\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\6\11"+
    "\1\236\22\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\12\11"+
    "\1\140\16\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\2\11"+
    "\1\237\26\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\26\11"+
    "\1\240\1\11\1\241\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\1\11\1\242\1\11\1\243\25\11\1\0\1\6\2\0"+
    "\6\11\1\0\1\6\1\75\1\11\2\0\4\11\15\0"+
    "\1\11\2\0\17\11\1\244\11\11\1\0\1\6\2\0"+
    "\6\11\1\0\1\6\1\75\1\11\2\0\4\11\15\0"+
    "\1\11\2\0\15\11\1\245\13\11\1\0\1\6\2\0"+
    "\6\11\1\0\1\6\1\75\1\11\2\0\4\11\15\0"+
    "\1\11\2\0\3\11\1\246\25\11\1\0\1\6\2\0"+
    "\5\11\1\247\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\31\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\13\11\1\250\15\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\1\11\1\251\1\252\26\11\1\0\1\6\2\0"+
    "\6\11\1\0\1\6\1\75\1\11\2\0\4\11\15\0"+
    "\1\11\2\0\5\11\1\253\23\11\1\0\1\6\2\0"+
    "\6\11\1\0\1\6\1\75\1\11\2\0\4\11\15\0"+
    "\1\11\2\0\1\11\1\254\27\11\1\0\1\6\2\0"+
    "\6\11\1\0\1\6\1\75\1\11\2\0\4\11\15\0"+
    "\1\11\2\0\7\11\1\255\21\11\1\0\1\6\2\0"+
    "\6\11\1\0\1\6\1\75\1\11\2\0\4\11\15\0"+
    "\1\11\2\0\16\11\1\256\12\11\1\0\1\6\2\0"+
    "\6\11\1\0\1\6\1\75\1\11\2\0\4\11\15\0"+
    "\1\11\2\0\1\11\1\257\27\11\1\0\1\6\2\0"+
    "\6\11\1\0\1\6\1\75\1\11\2\0\4\11\15\0"+
    "\1\11\2\0\1\11\1\260\27\11\1\0\1\6\2\0"+
    "\6\11\1\0\1\6\1\75\1\11\2\0\4\11\15\0"+
    "\1\11\2\0\3\11\1\261\25\11\1\0\1\6\2\0"+
    "\6\11\1\0\1\6\1\75\1\11\2\0\4\11\15\0"+
    "\1\11\2\0\13\11\1\262\15\11\1\0\1\6\2\0"+
    "\6\11\1\0\1\6\1\75\1\11\2\0\4\11\15\0"+
    "\1\11\2\0\13\11\1\263\15\11\1\0\1\6\2\0"+
    "\6\11\1\0\1\6\1\75\1\11\2\0\4\11\15\0"+
    "\1\11\2\0\1\11\1\264\1\11\1\246\25\11\1\0"+
    "\1\6\2\0\6\11\1\0\1\6\1\75\1\11\2\0"+
    "\4\11\15\0\1\11\2\0\17\11\1\265\11\11\1\0"+
    "\1\6\2\0\6\11\1\0\1\6\1\75\1\11\2\0"+
    "\4\11\15\0\1\11\2\0\6\11\1\266\22\11\1\0"+
    "\1\6\2\0\6\11\1\0\1\6\1\75\1\11\2\0"+
    "\4\11\15\0\1\11\2\0\10\11\1\140\20\11\1\0"+
    "\1\6\2\0\6\11\1\0\1\6\1\75\1\11\2\0"+
    "\4\11\15\0\1\11\2\0\1\11\1\267\27\11\1\0"+
    "\1\6\2\0\6\11\1\0\1\6\1\75\1\11\2\0"+
    "\4\11\15\0\1\11\2\0\4\11\1\270\1\11\1\271"+
    "\2\11\1\272\17\11\1\0\1\6\2\0\5\11\1\273"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\31\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\5\11"+
    "\1\274\1\275\22\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\1\11\1\276\27\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\26\11\1\140\2\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\4\11\1\277\24\11\5\0\4\300\11\0\2\300\24\0"+
    "\1\300\2\0\1\300\1\0\1\300\1\0\1\300\1\0"+
    "\1\300\2\0\1\300\7\0\1\300\5\0\4\301\11\0"+
    "\2\301\24\0\1\301\2\0\1\301\1\0\1\301\1\0"+
    "\1\301\1\0\1\301\2\0\1\301\7\0\1\301\45\0"+
    "\1\302\75\0\1\303\100\0\1\304\76\0\1\305\21\0"+
    "\1\6\2\0\1\6\4\306\1\6\1\0\3\6\2\0"+
    "\2\6\2\306\15\0\1\6\2\0\4\6\1\306\2\6"+
    "\1\306\1\6\1\306\1\6\1\306\1\6\1\306\2\6"+
    "\1\306\7\6\1\306\1\0\1\76\2\0\1\76\2\205"+
    "\1\76\1\205\1\76\1\0\3\76\2\0\2\76\1\100"+
    "\1\76\15\0\1\76\2\0\4\76\1\100\13\76\1\100"+
    "\7\76\1\100\5\0\2\205\1\0\1\205\65\0\1\76"+
    "\2\0\1\76\4\210\1\76\1\0\3\76\2\0\1\76"+
    "\1\207\2\210\15\0\1\76\2\0\4\76\1\210\1\76"+
    "\1\207\1\210\1\76\1\210\1\76\1\210\1\76\1\210"+
    "\2\76\1\210\7\76\1\210\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\3\11\1\143\25\11\41\0\1\212\7\0\1\212"+
    "\15\0\1\212\23\0\1\307\57\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\3\11\1\140\25\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\16\11\1\310\12\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\7\11\1\311\21\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\17\11\1\312\11\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\7\11\1\313\21\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\6\11\1\314\22\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\22\11\1\315\6\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\1\11\1\316\27\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\3\11\1\317\25\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\14\11\1\320\14\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\7\11\1\135\21\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\12\11\1\321\16\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\1\11\1\314\27\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\1\11\1\264\27\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\15\11\1\322\13\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\15\11\1\323\13\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\13\11\1\324\15\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\13\11\1\321\15\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\3\11\1\216\25\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\6\11\1\325\7\11\1\326\12\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\13\11\1\327\15\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\5\11\1\330\23\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\7\11\1\331\21\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\1\11\1\332\27\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\23\11\1\333\5\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\13\11\1\334\15\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\7\11\1\140\21\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\140\2\0\31\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\6\11\1\335\22\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\7\11\1\336\21\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\16\11\1\326\12\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\6\11\1\246\22\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\1\140\30\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\13\11\1\337\15\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\6\11\1\340\22\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\7\11\1\333\21\11\1\0\1\6\2\0\5\11\1\341"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\31\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\1\11"+
    "\1\342\27\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\12\11"+
    "\1\333\16\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\3\11"+
    "\1\214\25\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\15\11"+
    "\1\254\13\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\1\11"+
    "\1\343\1\11\1\344\25\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\6\11\1\140\22\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\5\11\1\345\23\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\13\11\1\346\15\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\7\11\1\347\21\11\1\0\1\6\2\0\5\11"+
    "\1\350\1\0\1\6\1\75\1\11\2\0\4\11\15\0"+
    "\1\11\2\0\31\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\11\11\1\351\17\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\20\11\1\140\10\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\13\11\1\352\15\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\16\11\1\140\12\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\5\11\1\353\23\11\5\0\4\354\11\0\2\354\24\0"+
    "\1\354\2\0\1\354\1\0\1\354\1\0\1\354\1\0"+
    "\1\354\2\0\1\354\7\0\1\354\5\0\4\355\11\0"+
    "\2\355\24\0\1\355\2\0\1\355\1\0\1\355\1\0"+
    "\1\355\1\0\1\355\2\0\1\355\7\0\1\355\46\0"+
    "\1\356\66\0\1\357\107\0\1\303\46\0\1\360\50\0"+
    "\1\6\2\0\1\6\4\361\1\6\1\0\3\6\2\0"+
    "\2\6\2\361\15\0\1\6\2\0\4\6\1\361\2\6"+
    "\1\361\1\6\1\361\1\6\1\361\1\6\1\361\2\6"+
    "\1\361\7\6\1\361\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\10\11\1\362\20\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\3\11\1\363\25\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\16\11\1\364\12\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\5\11\1\365\23\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\13\11\1\347\15\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\7\11\1\366\21\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\7\11\1\367\21\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\13\11\1\370\15\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\1\11\1\333\27\11\1\0\1\6\2\0\6\11\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\1\371\30\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\1\11"+
    "\1\372\27\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\6\11"+
    "\1\373\22\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\7\11"+
    "\1\374\21\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\12\11"+
    "\1\344\16\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\26\11"+
    "\1\335\2\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\17\11"+
    "\1\375\11\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\12\11"+
    "\1\376\16\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\13\11"+
    "\1\377\15\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\2\11"+
    "\1\u0100\26\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\17\11"+
    "\1\u0101\11\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\14\11"+
    "\1\140\14\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\7\11"+
    "\1\u0102\21\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\12\11"+
    "\1\u0103\16\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\12\11"+
    "\1\u0104\16\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\5\11"+
    "\1\u0105\23\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\1\11"+
    "\1\140\27\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\22\11"+
    "\1\246\6\11\1\0\1\6\2\0\5\11\1\u0106\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\31\11\1\0\1\6\2\0\6\11\1\0\1\6\1\75"+
    "\1\11\2\0\4\11\15\0\1\11\2\0\1\11\1\246"+
    "\27\11\1\0\1\6\2\0\6\11\1\0\1\6\1\75"+
    "\1\11\2\0\4\11\15\0\1\11\2\0\23\11\1\u0107"+
    "\5\11\1\0\1\6\2\0\6\11\1\0\1\6\1\75"+
    "\1\11\2\0\4\11\15\0\1\11\2\0\6\11\1\257"+
    "\22\11\1\0\1\6\2\0\6\11\1\0\1\6\1\75"+
    "\1\11\2\0\4\11\15\0\1\11\2\0\1\11\1\150"+
    "\27\11\1\0\1\6\2\0\6\11\1\0\1\6\1\75"+
    "\1\11\2\0\4\11\15\0\1\11\2\0\17\11\1\u0108"+
    "\11\11\40\0\1\357\6\0\1\303\43\0\1\u0109\62\0"+
    "\6\360\1\0\1\u010a\1\0\1\u010a\1\360\1\u010a\4\360"+
    "\2\u010a\1\0\2\u010a\1\0\1\u010a\2\0\4\u010a\1\360"+
    "\2\u010a\31\360\1\0\1\6\2\0\1\6\4\u010b\1\6"+
    "\1\0\3\6\2\0\2\6\2\u010b\15\0\1\6\2\0"+
    "\4\6\1\u010b\2\6\1\u010b\1\6\1\u010b\1\6\1\u010b"+
    "\1\6\1\u010b\2\6\1\u010b\7\6\1\u010b\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\5\11\1\u010c\23\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\4\11\1\140\24\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\15\11\1\140\13\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\15\11\1\u010d\13\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\27\11\1\u010e\1\u010f\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\23\11\1\246\5\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\12\11\1\u0110\16\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\5\11\1\u0111\23\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\11\2\0\6\11\1\u0112\22\11\1\0\1\6"+
    "\2\0\6\11\1\0\1\6\1\75\1\11\2\0\4\11"+
    "\15\0\1\u0113\2\0\31\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\5\11\1\u0114\23\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\4\11\1\u0115\24\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\17\11\1\u0116\11\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\7\11\1\335\21\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\20\11\1\214\10\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\13\11\1\u0117\15\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\17\11\1\u0118\11\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\13\11\1\u0119\15\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\17\11\1\u011a\11\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\6\11\1\344\22\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\23\11\1\226\5\11\1\0\1\6\2\0\6\11"+
    "\1\0\1\6\1\75\1\11\2\0\4\11\15\0\1\11"+
    "\2\0\5\11\1\u011b\23\11\16\0\1\360\57\0\1\6"+
    "\2\0\1\6\4\11\1\6\1\0\3\6\2\0\2\6"+
    "\2\11\15\0\1\6\2\0\4\6\1\11\2\6\1\11"+
    "\1\6\1\11\1\6\1\11\1\6\1\11\2\6\1\11"+
    "\7\6\1\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\7\11"+
    "\1\u011c\21\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\1\11"+
    "\1\u011d\27\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\17\11"+
    "\1\u011e\11\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\6\11"+
    "\1\u011f\22\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\16\11"+
    "\1\u0120\12\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\16\11"+
    "\1\u0121\12\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\21\11"+
    "\1\140\7\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\7\11"+
    "\1\u0122\21\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\1\11"+
    "\1\u0100\27\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\13\11"+
    "\1\u0123\15\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\15\11"+
    "\1\220\13\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\17\11"+
    "\1\333\11\11\1\0\1\6\2\0\6\11\1\0\1\6"+
    "\1\75\1\11\2\0\4\11\15\0\1\11\2\0\15\11"+
    "\1\344\13\11\1\0\1\6\2\0\5\11\1\246\1\0"+
    "\1\6\1\75\1\11\2\0\4\11\15\0\1\11\2\0"+
    "\31\11\1\0\1\6\2\0\6\11\1\0\1\6\1\75"+
    "\1\11\2\0\4\11\15\0\1\11\2\0\1\11\1\u0112"+
    "\27\11\1\0\1\6\2\0\6\11\1\0\1\6\1\75"+
    "\1\11\2\0\4\11\15\0\1\11\2\0\17\11\1\344"+
    "\11\11\1\0\1\6\2\0\6\11\1\0\1\6\1\75"+
    "\1\11\2\0\4\11\15\0\1\11\2\0\7\11\1\274"+
    "\21\11\1\0\1\6\2\0\6\11\1\0\1\6\1\75"+
    "\1\11\2\0\4\11\15\0\1\11\2\0\1\11\1\335"+
    "\27\11\1\0\1\6\2\0\6\11\1\0\1\6\1\75"+
    "\1\11\2\0\4\11\15\0\1\11\2\0\16\11\1\u0124"+
    "\12\11\1\0\1\6\2\0\6\11\1\0\1\6\1\75"+
    "\1\11\2\0\4\11\15\0\1\11\2\0\17\11\1\u0125"+
    "\11\11\1\0\1\6\2\0\6\11\1\0\1\6\1\75"+
    "\1\11\2\0\4\11\15\0\1\11\2\0\17\11\1\140"+
    "\11\11\1\0\1\6\2\0\6\11\1\0\1\6\1\75"+
    "\1\11\2\0\4\11\15\0\1\11\2\0\17\11\1\u0126"+
    "\11\11\1\0\1\6\2\0\6\11\1\0\1\6\1\75"+
    "\1\11\2\0\4\11\15\0\1\11\2\0\15\11\1\246"+
    "\13\11\1\0\1\6\2\0\6\11\1\0\1\6\1\75"+
    "\1\11\2\0\4\11\15\0\1\11\2\0\13\11\1\u011e"+
    "\15\11\1\0\1\6\2\0\6\11\1\0\1\6\1\75"+
    "\1\11\2\0\4\11\15\0\1\11\2\0\5\11\1\u0127"+
    "\23\11\1\0\1\6\2\0\6\11\1\0\1\6\1\75"+
    "\1\11\2\0\4\11\15\0\1\11\2\0\1\11\1\214"+
    "\27\11\1\0\1\6\2\0\6\11\1\0\1\6\1\75"+
    "\1\11\2\0\4\11\15\0\1\11\2\0\25\11\1\u011d"+
    "\3\11\1\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[16104];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\0\2\1\1\11\4\1\1\11\4\1\2\11\3\1"+
    "\1\11\1\1\1\11\22\1\1\11\1\1\1\11\1\1"+
    "\1\11\1\1\1\11\1\1\1\11\1\1\1\11\5\1"+
    "\1\11\12\1\2\0\1\11\2\1\1\0\57\1\1\11"+
    "\2\1\1\11\4\0\2\1\1\0\4\1\1\0\64\1"+
    "\6\0\1\1\1\11\44\1\1\0\1\11\2\0\31\1"+
    "\2\0\35\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[295];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */

	/**
	 * Token type specifying we're in a JavaScript multiline comment.
	 */
	public static final int INTERNAL_IN_JS_MLC				= -8;

	/**
	 * Token type specifying we're in an invalid multi-line JS string.
	 */
	public static final int INTERNAL_IN_JS_STRING_INVALID	= -9;

	/**
	 * Token type specifying we're in a valid multi-line JS string.
	 */
	public static final int INTERNAL_IN_JS_STRING_VALID		= -10;

	/**
	 * Token type specifying we're in an invalid multi-line JS single-quoted string.
	 */
	public static final int INTERNAL_IN_JS_CHAR_INVALID	= -11;

	/**
	 * Token type specifying we're in a valid multi-line JS single-quoted string.
	 */
	public static final int INTERNAL_IN_JS_CHAR_VALID		= -12;

	/**
	 * When in the JS_STRING state, whether the current string is valid.
	 */
	private boolean validJSString;


	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public JavaScriptTokenMaker() {
		super();
	}


	/**
	 * Adds the token specified to the current linked list of tokens as an
	 * "end token;" that is, at <code>zzMarkedPos</code>.
	 *
	 * @param tokenType The token's type.
	 */
	private void addEndToken(int tokenType) {
		addToken(zzMarkedPos,zzMarkedPos, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addToken(int, int, int)
	 */
	private void addHyperlinkToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, true);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * {@inheritDoc}
	 */
	public String[] getLineCommentStartAndEnd() {
		return new String[] { "//", null };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state = Token.NULL;
		switch (initialTokenType) {
			case INTERNAL_IN_JS_MLC:
				state = JS_MLC;
				start = text.offset;
				break;
			case INTERNAL_IN_JS_STRING_INVALID:
				state = JS_STRING;
				validJSString = false;
				start = text.offset;
				break;
			case INTERNAL_IN_JS_STRING_VALID:
				state = JS_STRING;
				validJSString = true;
				start = text.offset;
				break;
			case INTERNAL_IN_JS_CHAR_INVALID:
				state = JS_CHAR;
				validJSString = false;
				start = text.offset;
				break;
			case INTERNAL_IN_JS_CHAR_VALID:
				state = JS_CHAR;
				validJSString = true;
				start = text.offset;
				break;
			default:
				state = Token.NULL;
		}

		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new DefaultToken();
		}

	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream 
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream 
	 */
	public final void yyreset(java.io.Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public JavaScriptTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public JavaScriptTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 164) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 27: 
          { /* Invalid latin-1 character \xXX */ validJSString = false;
          }
        case 36: break;
        case 3: 
          { addNullToken(); return firstToken;
          }
        case 37: break;
        case 8: 
          { start = zzMarkedPos-1; validJSString = true; yybegin(JS_CHAR);
          }
        case 38: break;
        case 28: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.COMMENT_MULTILINE);
          }
        case 39: break;
        case 14: 
          { addToken(start,zzStartRead-1, Token.ERROR_CHAR); addNullToken(); return firstToken;
          }
        case 40: break;
        case 23: 
          { start = zzMarkedPos-2; yybegin(JS_MLC);
          }
        case 41: break;
        case 31: 
          { addToken(Token.COMMENT_MULTILINE);
          }
        case 42: break;
        case 26: 
          { /* Invalid Unicode character \\uXXXX */ validJSString = false;
          }
        case 43: break;
        case 2: 
          { addToken(Token.WHITESPACE);
          }
        case 44: break;
        case 21: 
          { addToken(Token.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 45: break;
        case 12: 
          { /* Line ending in '\' => continue to next line. */
								if (validJSString) {
									addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE);
									addEndToken(INTERNAL_IN_JS_STRING_VALID);
								}
								else {
									addToken(start,zzStartRead, Token.ERROR_STRING_DOUBLE);
									addEndToken(INTERNAL_IN_JS_STRING_INVALID);
								}
								return firstToken;
          }
        case 46: break;
        case 9: 
          { start = zzMarkedPos-1; validJSString = true; yybegin(JS_STRING);
          }
        case 47: break;
        case 20: 
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 48: break;
        case 24: 
          { addToken(Token.RESERVED_WORD);
          }
        case 49: break;
        case 7: 
          { addToken(Token.SEPARATOR);
          }
        case 50: break;
        case 4: 
          { addToken(Token.IDENTIFIER);
          }
        case 51: break;
        case 18: 
          { addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 52: break;
        case 16: 
          { int type = validJSString ? Token.LITERAL_CHAR : Token.ERROR_CHAR; addToken(start,zzStartRead, type); yybegin(YYINITIAL);
          }
        case 53: break;
        case 33: 
          { addToken(Token.FUNCTION);
          }
        case 54: break;
        case 30: 
          { addToken(Token.DATA_TYPE);
          }
        case 55: break;
        case 1: 
          { addToken(Token.ERROR_IDENTIFIER);
          }
        case 56: break;
        case 13: 
          { int type = validJSString ? Token.LITERAL_STRING_DOUBLE_QUOTE : Token.ERROR_STRING_DOUBLE; addToken(start,zzStartRead, type); yybegin(YYINITIAL);
          }
        case 57: break;
        case 32: 
          { addToken(Token.LITERAL_BOOLEAN);
          }
        case 58: break;
        case 15: 
          { /* Line ending in '\' => continue to next line. */
								if (validJSString) {
									addToken(start,zzStartRead, Token.LITERAL_CHAR);
									addEndToken(INTERNAL_IN_JS_CHAR_VALID);
								}
								else {
									addToken(start,zzStartRead, Token.ERROR_CHAR);
									addEndToken(INTERNAL_IN_JS_CHAR_INVALID);
								}
								return firstToken;
          }
        case 59: break;
        case 25: 
          { /* Skip all escaped chars. */
          }
        case 60: break;
        case 29: 
          { boolean highlightedAsRegex = false;
										if (firstToken==null) {
											addToken(Token.REGEX);
											highlightedAsRegex = true;
										}
										else {
											// If this is *likely* to be a regex, based on
											// the previous token, highlight it as such.
											Token t = firstToken.getLastNonCommentNonWhitespaceToken();
											if (RSyntaxUtilities.regexCanFollowInJavaScript(t)) {
												addToken(Token.REGEX);
												highlightedAsRegex = true;
											}
										}
										// If it doesn't *appear* to be a regex, highlight it as
										// individual tokens.
										if (!highlightedAsRegex) {
											int temp = zzStartRead + 1;
											addToken(zzStartRead, zzStartRead, Token.OPERATOR);
											zzStartRead = zzCurrentPos = zzMarkedPos = temp;
										}
          }
        case 61: break;
        case 34: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_EOL); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_EOL); start = zzMarkedPos;
          }
        case 62: break;
        case 35: 
          { addToken(Token.RESERVED_WORD_2);
          }
        case 63: break;
        case 19: 
          { addToken(Token.ERROR_NUMBER_FORMAT);
          }
        case 64: break;
        case 5: 
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 65: break;
        case 6: 
          { addToken(Token.OPERATOR);
          }
        case 66: break;
        case 22: 
          { start = zzMarkedPos-2; yybegin(JS_EOL_COMMENT);
          }
        case 67: break;
        case 17: 
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_JS_MLC); return firstToken;
          }
        case 68: break;
        case 10: 
          { 
          }
        case 69: break;
        case 11: 
          { addToken(start,zzStartRead-1, Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
          }
        case 70: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case JS_STRING: {
              addToken(start,zzStartRead-1, Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
            }
            case 296: break;
            case JS_CHAR: {
              addToken(start,zzStartRead-1, Token.ERROR_CHAR); addNullToken(); return firstToken;
            }
            case 297: break;
            case JS_EOL_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
            }
            case 298: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 299: break;
            case JS_MLC: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_JS_MLC); return firstToken;
            }
            case 300: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
