/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.versioning;

import io.github.bucket4j.distributed.versioning.UsageOfObsoleteApiException;
import io.github.bucket4j.distributed.versioning.UsageOfUnsupportedApiException;
import io.github.bucket4j.distributed.versioning.Version;

public enum Versions implements Version
{
    v_7_0_0(1),
    v_8_1_0(2);

    private final int number;

    private Versions(int number) {
        this.number = number;
    }

    public static void check(int formatNumber, Version min, Version max) {
        if (formatNumber < min.getNumber()) {
            throw new UsageOfObsoleteApiException(formatNumber, min.getNumber());
        }
        if (formatNumber > max.getNumber()) {
            throw new UsageOfUnsupportedApiException(formatNumber, max.getNumber());
        }
    }

    public static Version max(Version first, Version second) {
        return first.getNumber() >= second.getNumber() ? first : second;
    }

    public static Version max(Version first, Version second, Version third) {
        Version max = first.getNumber() >= second.getNumber() ? first : second;
        max = third.getNumber() >= max.getNumber() ? third : max;
        return max;
    }

    public static void checkMin(int formatNumber, Versions min) {
        if (formatNumber < min.getNumber()) {
            throw new UsageOfObsoleteApiException(formatNumber, min.number);
        }
    }

    public static void checkMax(int formatNumber, Versions max) {
        if (formatNumber > max.getNumber()) {
            throw new UsageOfUnsupportedApiException(formatNumber, max.number);
        }
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    public static Version getLatest() {
        return v_8_1_0;
    }

    public static Version getOldest() {
        return v_7_0_0;
    }

    public static Version byNumber(int number) {
        for (Versions version : Versions.values()) {
            if (version.number != number) continue;
            return version;
        }
        return new UnknownVersion(number);
    }

    public static class UnknownVersion
    implements Version {
        private final int number;

        public UnknownVersion(int number) {
            this.number = number;
        }

        @Override
        public int getNumber() {
            return this.number;
        }
    }
}

