/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.util;

import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.BrowseRequest;
import com.browseengine.bobo.api.FacetAccessible;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.api.MappedFacetAccessible;
import com.browseengine.bobo.facets.impl.FacetHitcountComparatorFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.PriorityQueue;

public class ListMerger {
    public static final Comparator<BrowseFacet> FACET_VAL_COMPARATOR = new Comparator<BrowseFacet>(){

        @Override
        public int compare(BrowseFacet o1, BrowseFacet o2) {
            return o1.getValue().compareTo(o2.getValue());
        }
    };

    private ListMerger() {
    }

    public static <T> Iterator<T> mergeLists(Iterator<T>[] iterators, Comparator<T> comparator) {
        return new MergedIterator<T>(iterators, comparator);
    }

    public static <T> Iterator<T> mergeLists(List<Iterator<T>> iterators, Comparator<T> comparator) {
        return new MergedIterator<T>(iterators, comparator);
    }

    public static <T> ArrayList<T> mergeLists(int offset, int count, Iterator<T>[] iterators, Comparator<T> comparator) {
        return ListMerger.mergeLists(offset, count, new MergedIterator<T>(iterators, comparator));
    }

    public static <T> ArrayList<T> mergeLists(int offset, int count, List<Iterator<T>> iterators, Comparator<T> comparator) {
        return ListMerger.mergeLists(offset, count, new MergedIterator<T>(iterators, comparator));
    }

    private static <T> ArrayList<T> mergeLists(int offset, int count, Iterator<T> mergedIter) {
        if (count == 0) {
            return new ArrayList();
        }
        for (int c = 0; c < offset && mergedIter.hasNext(); ++c) {
            mergedIter.next();
        }
        ArrayList<T> mergedList = new ArrayList<T>();
        for (int c = 0; c < count && mergedIter.hasNext(); ++c) {
            mergedList.add(mergedIter.next());
        }
        return mergedList;
    }

    public static Map<String, FacetAccessible> mergeSimpleFacetContainers(Collection<Map<String, FacetAccessible>> subMaps, BrowseRequest req) {
        HashMap counts = new HashMap();
        for (Map<String, FacetAccessible> subMap : subMaps) {
            for (Map.Entry<String, FacetAccessible> entry : subMap.entrySet()) {
                HashMap<String, BrowseFacet> count = (HashMap<String, BrowseFacet>)counts.get(entry.getKey());
                if (count == null) {
                    count = new HashMap<String, BrowseFacet>();
                    counts.put(entry.getKey(), count);
                }
                for (BrowseFacet facet : entry.getValue().getFacets()) {
                    String val = facet.getValue();
                    BrowseFacet oldValue = (BrowseFacet)count.get(val);
                    if (oldValue == null) {
                        count.put(val, new BrowseFacet(val, facet.getHitCount()));
                        continue;
                    }
                    oldValue.setHitCount(oldValue.getHitCount() + facet.getHitCount());
                }
            }
        }
        HashMap<String, FacetAccessible> mergedFacetMap = new HashMap<String, FacetAccessible>();
        for (String facet : counts.keySet()) {
            BrowseFacet[] facets;
            int maxCount;
            FacetSpec fspec;
            FacetSpec fs = req.getFacetSpec(facet);
            FacetSpec.FacetSortSpec sortSpec = fs.getOrderBy();
            Comparator<BrowseFacet> comparator = FacetSpec.FacetSortSpec.OrderValueAsc.equals((Object)sortSpec) ? FACET_VAL_COMPARATOR : (FacetSpec.FacetSortSpec.OrderHitsDesc.equals((Object)sortSpec) ? FacetHitcountComparatorFactory.FACET_HITS_COMPARATOR : fs.getCustomComparatorFactory().newComparator());
            Map facetValueCounts = (Map)counts.get(facet);
            BrowseFacet[] facetArray = facetValueCounts.values().toArray(new BrowseFacet[facetValueCounts.size()]);
            Arrays.sort(facetArray, comparator);
            int numToShow = facetArray.length;
            if (req != null && (fspec = req.getFacetSpec(facet)) != null && (maxCount = fspec.getMaxCount()) > 0) {
                numToShow = Math.min(maxCount, numToShow);
            }
            if (numToShow == facetArray.length) {
                facets = facetArray;
            } else {
                facets = new BrowseFacet[numToShow];
                System.arraycopy(facetArray, 0, facets, 0, numToShow);
            }
            MappedFacetAccessible mergedFacetAccessible = new MappedFacetAccessible(facets);
            mergedFacetMap.put(facet, mergedFacetAccessible);
        }
        return mergedFacetMap;
    }

    public static class MergedIterator<T>
    implements Iterator<T> {
        private final PriorityQueue _queue;

        private MergedIterator(final int length, final Comparator<T> comparator) {
            this._queue = new PriorityQueue(){
                {
                    this.initialize(length);
                }

                protected boolean lessThan(Object o1, Object o2) {
                    Object v1 = ((IteratorNode)o1)._curVal;
                    Object v2 = ((IteratorNode)o2)._curVal;
                    return comparator.compare(v1, v2) < 0;
                }
            };
        }

        public MergedIterator(List<Iterator<T>> iterators, Comparator<T> comparator) {
            this(iterators.size(), comparator);
            for (Iterator<T> iterator : iterators) {
                IteratorNode ctx = new IteratorNode(iterator);
                if (!ctx.fetch()) continue;
                this._queue.add((Object)ctx);
            }
        }

        public MergedIterator(Iterator<T>[] iterators, Comparator<T> comparator) {
            this(iterators.length, comparator);
            for (Iterator<T> iterator : iterators) {
                IteratorNode ctx = new IteratorNode(iterator);
                if (!ctx.fetch()) continue;
                this._queue.add((Object)ctx);
            }
        }

        @Override
        public boolean hasNext() {
            return this._queue.size() > 0;
        }

        @Override
        public T next() {
            IteratorNode ctx = (IteratorNode)this._queue.top();
            Object val = ctx._curVal;
            if (ctx.fetch()) {
                this._queue.updateTop();
            } else {
                this._queue.pop();
            }
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private class IteratorNode {
            public Iterator<T> _iterator;
            public T _curVal;

            public IteratorNode(Iterator<T> iterator) {
                this._iterator = iterator;
                this._curVal = null;
            }

            public boolean fetch() {
                if (this._iterator.hasNext()) {
                    this._curVal = this._iterator.next();
                    return true;
                }
                this._curVal = null;
                return false;
            }
        }
    }
}

