/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.networking.baseurls;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class BaseUrls {
    @JsonProperty(value="base_url")
    protected String baseUrl = "https://api.box.com";
    @JsonProperty(value="upload_url")
    protected String uploadUrl = "https://upload.box.com/api";
    @JsonProperty(value="oauth2_url")
    protected String oauth2Url = "https://account.box.com/api/oauth2";

    public BaseUrls() {
    }

    protected BaseUrls(Builder builder) {
        this.baseUrl = builder.baseUrl;
        this.uploadUrl = builder.uploadUrl;
        this.oauth2Url = builder.oauth2Url;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public String getOauth2Url() {
        return this.oauth2Url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseUrls casted = (BaseUrls)o;
        return Objects.equals(this.baseUrl, casted.baseUrl) && Objects.equals(this.uploadUrl, casted.uploadUrl) && Objects.equals(this.oauth2Url, casted.oauth2Url);
    }

    public int hashCode() {
        return Objects.hash(this.baseUrl, this.uploadUrl, this.oauth2Url);
    }

    public String toString() {
        return "BaseUrls{baseUrl='" + this.baseUrl + '\'' + ", uploadUrl='" + this.uploadUrl + '\'' + ", oauth2Url='" + this.oauth2Url + '\'' + "}";
    }

    public static class Builder {
        protected String baseUrl = "https://api.box.com";
        protected String uploadUrl = "https://upload.box.com/api";
        protected String oauth2Url = "https://account.box.com/api/oauth2";

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder uploadUrl(String uploadUrl) {
            this.uploadUrl = uploadUrl;
            return this;
        }

        public Builder oauth2Url(String oauth2Url) {
            this.oauth2Url = oauth2Url;
            return this;
        }

        public BaseUrls build() {
            return new BaseUrls(this);
        }
    }
}

