/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.AreaTable;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.EdgeTable;
import com.bbn.openmap.layer.vpf.FeatureCacheGraphicList;
import com.bbn.openmap.layer.vpf.FeatureDrawingAttributes;
import com.bbn.openmap.layer.vpf.NodeTable;
import com.bbn.openmap.layer.vpf.PrimitiveTable;
import com.bbn.openmap.layer.vpf.TextTable;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.VPFFeatureCache;
import com.bbn.openmap.layer.vpf.VPFFeatureGraphicWarehouse;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPFCachedFeatureGraphicWarehouse
extends VPFFeatureGraphicWarehouse {
    protected VPFFeatureCache featureCache = null;
    protected FeatureCacheGraphicList cacheList;

    public VPFCachedFeatureGraphicWarehouse() {
    }

    public VPFCachedFeatureGraphicWarehouse(VPFFeatureCache vfc) {
        this();
        this.setFeatureCache(vfc);
    }

    public void setFeatureCache(VPFFeatureCache vfc) {
        this.featureCache = vfc;
    }

    public VPFFeatureCache getFeatureCache() {
        return this.featureCache;
    }

    @Override
    public OMGraphic createArea(CoverageTable covtable, AreaTable areatable, List<Object> facevec, LatLonPoint ll1, LatLonPoint ll2, double dpplat, double dpplon, String featureType) {
        ArrayList<CoordFloatString> ipts = new ArrayList<CoordFloatString>();
        int totalSize = 0;
        try {
            totalSize = areatable.computeEdgePoints(facevec, ipts);
        }
        catch (FormatException f) {
            Debug.output("FormatException in computeEdgePoints: " + f);
            return null;
        }
        if (totalSize == 0) {
            return null;
        }
        OMPoly py = VPFCachedFeatureGraphicWarehouse.createAreaOMPoly(ipts, totalSize, ll1, ll2, dpplat, dpplon, covtable.doAntarcticaWorkaround);
        FeatureDrawingAttributes da = this.getAttributesForFeature(featureType);
        da.setTo(py);
        py.setLinePaint(da.getFillPaint());
        py.setSelectPaint(da.getFillPaint());
        this.addToCachedList(py, featureType, areatable, "Area");
        return py;
    }

    @Override
    public OMGraphic createEdge(CoverageTable c, EdgeTable edgetable, List<Object> edgevec, LatLonPoint ll1, LatLonPoint ll2, double dpplat, double dpplon, CoordFloatString coords, String featureType) {
        OMPoly py = VPFCachedFeatureGraphicWarehouse.createEdgeOMPoly(coords, ll1, ll2, dpplat, dpplon);
        FeatureDrawingAttributes da = this.getAttributesForFeature(featureType);
        da.setTo(py);
        py.setFillPaint(OMColor.clear);
        py.setIsPolygon(false);
        this.addToCachedList(py, featureType, edgetable, "Edge");
        return py;
    }

    @Override
    public OMGraphic createText(CoverageTable c, TextTable texttable, List<Object> textvec, double latitude, double longitude, String text, String featureType) {
        OMText txt = VPFCachedFeatureGraphicWarehouse.createOMText(text, latitude, longitude);
        this.getAttributesForFeature(featureType).setTo(txt);
        this.addToCachedList(txt, featureType, texttable, "Text");
        return txt;
    }

    @Override
    public OMGraphic createNode(CoverageTable c, NodeTable t, List<Object> nodeprim, double latitude, double longitude, boolean isEntityNode, String featureType) {
        OMPoint pt = VPFCachedFeatureGraphicWarehouse.createOMPoint(latitude, longitude);
        this.getAttributesForFeature(featureType).setTo(pt);
        this.addToCachedList(pt, featureType, t, isEntityNode ? "EPoint" : "CPoint");
        return pt;
    }

    protected synchronized void addToCachedList(OMGraphic omg, String featureType, PrimitiveTable pt, String type) {
        if (this.featureCache != null && this.cacheList != null) {
            this.cacheList.add(omg);
        } else if (type == "Area") {
            this.addArea(omg);
        } else if (type == "Edge") {
            this.addEdge(omg);
        } else if (type == "Text") {
            this.addText(omg);
        } else {
            this.addPoint(omg);
        }
    }

    @Override
    public boolean needToFetchTileContents(String libraryName, String currentFeature, TileDirectory currentTile) {
        if (this.featureCache != null) {
            this.cacheList = this.featureCache.needToFetchTileContents(libraryName, currentFeature, currentTile, this.graphics);
            return this.cacheList != null;
        }
        return super.needToFetchTileContents(libraryName, currentFeature, currentTile);
    }

    @Override
    public synchronized OMGraphicList getGraphics() {
        if (this.featureCache != null) {
            OMGraphicList ret = new OMGraphicList();
            ret.setTraverseMode(0);
            logger.fine("checking for cached lists");
            for (OMGraphic omg : this.graphics) {
                if (omg instanceof FeatureCacheGraphicList) {
                    FeatureCacheGraphicList fcgl = (FeatureCacheGraphicList)((FeatureCacheGraphicList)omg).clone();
                    fcgl.setDrawingAttributes(this);
                    if (fcgl instanceof FeatureCacheGraphicList.AREA) {
                        this.addArea(fcgl);
                        continue;
                    }
                    if (fcgl instanceof FeatureCacheGraphicList.EDGE) {
                        this.addEdge(fcgl);
                        continue;
                    }
                    if (fcgl instanceof FeatureCacheGraphicList.TEXT) {
                        this.addText(fcgl);
                        continue;
                    }
                    this.addPoint(fcgl);
                    continue;
                }
                this.addPoint(omg);
            }
            this.getGraphics(ret);
            return ret;
        }
        return super.getGraphics();
    }
}

