/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.ClientLink;
import com.bbn.openmap.layer.link.LinkListener;
import com.bbn.openmap.util.Debug;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;

public class LinkManager {
    protected String host;
    protected int port;
    protected boolean obeyCommandToExit;
    protected volatile ClientLink link;

    protected LinkManager() {
    }

    public LinkManager(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void setObeyCommandToExit(boolean value) {
        this.obeyCommandToExit = value;
    }

    public boolean getObeyCommandToExit() {
        return this.obeyCommandToExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientLink getLink(boolean waitForLock) throws IOException {
        if (this.link == null) {
            LinkManager linkManager = this;
            synchronized (linkManager) {
                if (this.link == null) {
                    this.link = this.getLink();
                    this.link.setObeyCommandToExit(this.obeyCommandToExit);
                }
            }
        }
        try {
            while (!this.link.setLocked(true)) {
                if (!waitForLock) {
                    return null;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException ie) {}
            }
        }
        catch (NullPointerException npe) {
            return null;
        }
        return this.link;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientLink getLink(LinkListener ll) throws IOException {
        if (this.link == null) {
            LinkManager linkManager = this;
            synchronized (linkManager) {
                if (this.link == null) {
                    this.link = this.getLink();
                    this.link.setObeyCommandToExit(this.obeyCommandToExit);
                }
            }
        }
        return this.link;
    }

    protected ClientLink getLink() throws IOException {
        ClientLink tmplink = null;
        try {
            if (Debug.debugging("link")) {
                Debug.output("LinkManager.getLink(): establishing link to " + this.host + " on port " + this.port);
            }
            Socket socket = new Socket(this.host, this.port);
            tmplink = new ClientLink(socket);
        }
        catch (UnknownHostException uhe) {
            Debug.error("LinkLayer: error trying to contact host:" + this.host);
            tmplink = null;
            throw new IOException("No Contact with host:" + this.host + " on port:" + this.port);
        }
        return tmplink;
    }

    public void finLink() throws IOException {
        if (this.link.isCloseLink()) {
            Debug.message("link", "LinkManager.finLink: closing Link");
            this.link.close();
            this.link = null;
        } else {
            Debug.message("link", "LinkManager.finLink: releasing lock on Link");
            this.link.setLocked(false);
        }
    }

    public void resetLink() {
        if (this.link != null) {
            try {
                this.link.cleanUp();
                this.link.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.link = null;
    }
}

