/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.EncryptionIdentity;
import com.azure.resourcemanager.storage.models.EncryptionServices;
import com.azure.resourcemanager.storage.models.KeySource;
import com.azure.resourcemanager.storage.models.KeyVaultProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class Encryption {
    @JsonProperty(value="services")
    private EncryptionServices services;
    @JsonProperty(value="keySource", required=true)
    private KeySource keySource;
    @JsonProperty(value="requireInfrastructureEncryption")
    private Boolean requireInfrastructureEncryption;
    @JsonProperty(value="keyvaultproperties")
    private KeyVaultProperties keyVaultProperties;
    @JsonProperty(value="identity")
    private EncryptionIdentity encryptionIdentity;
    private static final ClientLogger LOGGER = new ClientLogger(Encryption.class);

    public EncryptionServices services() {
        return this.services;
    }

    public Encryption withServices(EncryptionServices services) {
        this.services = services;
        return this;
    }

    public KeySource keySource() {
        return this.keySource;
    }

    public Encryption withKeySource(KeySource keySource) {
        this.keySource = keySource;
        return this;
    }

    public Boolean requireInfrastructureEncryption() {
        return this.requireInfrastructureEncryption;
    }

    public Encryption withRequireInfrastructureEncryption(Boolean requireInfrastructureEncryption) {
        this.requireInfrastructureEncryption = requireInfrastructureEncryption;
        return this;
    }

    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    public Encryption withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    public EncryptionIdentity encryptionIdentity() {
        return this.encryptionIdentity;
    }

    public Encryption withEncryptionIdentity(EncryptionIdentity encryptionIdentity) {
        this.encryptionIdentity = encryptionIdentity;
        return this;
    }

    public void validate() {
        if (this.services() != null) {
            this.services().validate();
        }
        if (this.keySource() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property keySource in model Encryption"));
        }
        if (this.keyVaultProperties() != null) {
            this.keyVaultProperties().validate();
        }
        if (this.encryptionIdentity() != null) {
            this.encryptionIdentity().validate();
        }
    }
}

