/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.SiteSourceControlInner;
import com.azure.resourcemanager.appservice.fluent.models.SourceControlInner;
import com.azure.resourcemanager.appservice.implementation.WebAppBaseImpl;
import com.azure.resourcemanager.appservice.models.RepositoryType;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.appservice.models.WebAppSourceControl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import reactor.core.publisher.Mono;

class WebAppSourceControlImpl<FluentT extends WebAppBase, FluentImplT extends WebAppBaseImpl<FluentT, FluentImplT>>
extends IndexableWrapperImpl<SiteSourceControlInner>
implements WebAppSourceControl,
WebAppSourceControl.Definition<WebAppBase.DefinitionStages.WithCreate<FluentT>>,
WebAppSourceControl.UpdateDefinition<WebAppBase.Update<FluentT>> {
    private final WebAppBaseImpl<FluentT, FluentImplT> parent;
    private String githubAccessToken;

    WebAppSourceControlImpl(SiteSourceControlInner inner, WebAppBaseImpl<FluentT, FluentImplT> parent) {
        super((Object)inner);
        this.parent = parent;
    }

    public String name() {
        return ((SiteSourceControlInner)((Object)this.innerModel())).name();
    }

    @Override
    public String repositoryUrl() {
        return ((SiteSourceControlInner)((Object)this.innerModel())).repoUrl();
    }

    @Override
    public String branch() {
        return ((SiteSourceControlInner)((Object)this.innerModel())).branch();
    }

    @Override
    public boolean isManualIntegration() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((SiteSourceControlInner)((Object)this.innerModel())).isManualIntegration());
    }

    @Override
    public boolean deploymentRollbackEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean((Boolean)((SiteSourceControlInner)((Object)this.innerModel())).deploymentRollbackEnabled());
    }

    @Override
    public RepositoryType repositoryType() {
        if (((SiteSourceControlInner)((Object)this.innerModel())).isMercurial() == null) {
            return null;
        }
        return ((SiteSourceControlInner)((Object)this.innerModel())).isMercurial() != false ? RepositoryType.MERCURIAL : RepositoryType.GIT;
    }

    public FluentImplT attach() {
        ((WebAppBaseImpl)this.parent()).withSourceControl(this);
        return (FluentImplT)this.parent();
    }

    public FluentImplT parent() {
        return (FluentImplT)this.parent;
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> withBranch(String branch) {
        ((SiteSourceControlInner)((Object)this.innerModel())).withBranch(branch);
        return this;
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> withPublicGitRepository(String url) {
        ((SiteSourceControlInner)((Object)this.innerModel())).withIsManualIntegration(true).withIsMercurial(false).withRepoUrl(url);
        return this;
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> withPublicMercurialRepository(String url) {
        ((SiteSourceControlInner)((Object)this.innerModel())).withIsManualIntegration(true).withIsMercurial(true).withRepoUrl(url);
        return this;
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> withContinuouslyIntegratedGitHubRepository(String organization, String repository) {
        return this.withContinuouslyIntegratedGitHubRepository(String.format("https://github.com/%s/%s", organization, repository));
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> withContinuouslyIntegratedGitHubRepository(String url) {
        ((SiteSourceControlInner)((Object)this.innerModel())).withRepoUrl(url).withIsMercurial(false).withIsManualIntegration(false);
        return this;
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> withGitHubAccessToken(String personalAccessToken) {
        this.githubAccessToken = personalAccessToken;
        return this;
    }

    Mono<SourceControlInner> registerGithubAccessToken() {
        if (this.githubAccessToken == null) {
            return Mono.empty();
        }
        SourceControlInner sourceControlInner = new SourceControlInner().withToken(this.githubAccessToken);
        return ((WebSiteManagementClient)((AppServiceManager)this.parent().manager()).serviceClient()).getResourceProviders().updateSourceControlAsync("Github", sourceControlInner);
    }
}

