/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;

public final class SyncToken {
    private static final String CANNOT_EMPTY_OR_NULL = "sync-token cannot be null or empty.";
    private static final String EQUAL = "=";
    private static final String SEMICOLON = ";";
    private static final String SEQUENCE_NUMBER_CANNOT_PARSED = "Sequence number cannot be parsed to long.";
    private static final String VALID_FORMAT_ERROR_MESSAGE = "Expected sync-token valid format should be <id>=<value>;sn=<sn>. For multiple sync tokens, <id>=<value>;sn=<sn>,<id>=<value>;sn=<sn>.";
    private static final ClientLogger LOGGER = new ClientLogger(SyncToken.class);
    private String id;
    private String value;
    private long sequenceNumber;

    public static SyncToken createSyncToken(String syncToken) {
        SyncToken token = new SyncToken();
        if (CoreUtils.isNullOrEmpty((CharSequence)syncToken)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(CANNOT_EMPTY_OR_NULL));
        }
        String[] syncTokenParts = syncToken.split(SEMICOLON, 2);
        if (syncTokenParts.length != 2) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(VALID_FORMAT_ERROR_MESSAGE));
        }
        String[] idParts = syncTokenParts[0].split(EQUAL, 2);
        String[] snParts = syncTokenParts[1].split(EQUAL, 2);
        if (idParts.length != 2 || snParts.length != 2 || idParts[0].isEmpty() || idParts[1].isEmpty() || snParts[0].isEmpty() || snParts[1].isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(VALID_FORMAT_ERROR_MESSAGE));
        }
        try {
            token.sequenceNumber = Long.parseLong(snParts[1]);
        }
        catch (NumberFormatException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(SEQUENCE_NUMBER_CANNOT_PARSED));
        }
        token.id = idParts[0];
        token.value = idParts[1];
        return token;
    }

    public String getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }
}

