// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.appconfiguration.implementation.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The Key model.
 */
@Immutable
public final class Key implements JsonSerializable<Key> {
    /*
     * The name of the key.
     */
    private String name;

    /**
     * Creates an instance of Key class.
     */
    public Key() {
    }

    /**
     * Get the name property: The name of the key.
     * 
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Key from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Key if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Key.
     */
    public static Key fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Key deserializedKey = new Key();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedKey.name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKey;
        });
    }
}
