/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.List;
import lombok.ast.BinaryExpression;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Expression;
import lombok.ast.MethodInvocation;
import lombok.ast.Position;
import lombok.ast.UnaryExpression;

class ExpressionMixin {
    List<Position> parensPositions;

    ExpressionMixin() {
    }

    static int getParens(Expression self) {
        return self.astParensPositions() == null ? 0 : self.astParensPositions().size();
    }

    static int getIntendedParens(Expression self) {
        return Math.max(ExpressionMixin.needsParentheses(self) ? 1 : 0, self.getParens());
    }

    static boolean needsParentheses(Expression self) {
        return false;
    }

    static boolean isStatementExpression(Expression self) {
        if (self instanceof MethodInvocation) {
            return true;
        }
        if (self instanceof ConstructorInvocation) {
            return true;
        }
        if (self instanceof BinaryExpression) {
            try {
                return ((BinaryExpression)self).astOperator().isAssignment();
            }
            catch (Exception e) {
                return false;
            }
        }
        if (self instanceof UnaryExpression) {
            try {
                switch (((UnaryExpression)self).astOperator()) {
                    case POSTFIX_DECREMENT: 
                    case POSTFIX_INCREMENT: 
                    case PREFIX_DECREMENT: 
                    case PREFIX_INCREMENT: {
                        return true;
                    }
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }
}

