/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.CommentTemplate;
import lombok.ast.Node;

public class Comment
extends AbstractNode {
    private boolean blockComment = false;
    private String content = "";

    public boolean astBlockComment() {
        return this.blockComment;
    }

    public Comment astBlockComment(boolean blockComment) {
        this.blockComment = blockComment;
        return this;
    }

    public String astContent() {
        return this.content;
    }

    public Comment astContent(String content) {
        this.content = content == null ? "" : content;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        return false;
    }

    @Override
    public boolean detach(Node child) {
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitComment(this)) {
            return;
        }
        visitor.afterVisitComment(this);
        visitor.endVisit(this);
    }

    @Override
    public Comment copy() {
        Comment result = new Comment();
        result.blockComment = this.blockComment;
        result.content = this.content;
        return result;
    }

    public boolean isJavadoc() {
        return CommentTemplate.isJavadoc(this);
    }

    public boolean isMarkedDeprecated() {
        return CommentTemplate.isMarkedDeprecated(this);
    }
}

