/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

public enum BinaryOperator {
    PLUS_ASSIGN("+=", 14),
    MINUS_ASSIGN("-=", 14),
    MULTIPLY_ASSIGN("*=", 14),
    DIVIDE_ASSIGN("/=", 14),
    REMAINDER_ASSIGN("%=", 14),
    AND_ASSIGN("&=", 14),
    XOR_ASSIGN("^=", 14),
    OR_ASSIGN("|=", 14),
    SHIFT_LEFT_ASSIGN("<<=", 14),
    SHIFT_RIGHT_ASSIGN(">>=", 14),
    BITWISE_SHIFT_RIGHT_ASSIGN(">>>=", 14),
    ASSIGN("=", 14),
    LOGICAL_OR("||", 12),
    LOGICAL_AND("&&", 11),
    BITWISE_OR("|", 10),
    BITWISE_XOR("^", 9),
    BITWISE_AND("&", 8),
    EQUALS("==", 7),
    NOT_EQUALS("!=", 7),
    GREATER(">", 6),
    GREATER_OR_EQUAL(">=", 6),
    LESS("<", 6),
    LESS_OR_EQUAL("<=", 6),
    SHIFT_LEFT("<<", 5),
    SHIFT_RIGHT(">>", 5),
    BITWISE_SHIFT_RIGHT(">>>", 5),
    PLUS("+", 4),
    MINUS("-", 4),
    MULTIPLY("*", 3),
    DIVIDE("/", 3),
    REMAINDER("%", 3);

    private final String symbol;
    private final int pLevel;

    private BinaryOperator(String symbol, int pLevel) {
        this.symbol = symbol;
        this.pLevel = pLevel;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean isAssignment() {
        return this.pLevel == BinaryOperator.ASSIGN.pLevel;
    }

    public static BinaryOperator fromSymbol(String symbol) {
        for (BinaryOperator op : BinaryOperator.values()) {
            if (!op.symbol.equals(symbol)) continue;
            return op;
        }
        return null;
    }

    int pLevel() {
        return this.pLevel;
    }
}

