/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.Architecture;
import com.amazonaws.services.opsworks.model.AutoScalingType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateInstanceRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String instanceId;
    private ListWithAutoConstructFlag<String> layerIds;
    private String instanceType;
    private String autoScalingType;
    private String hostname;
    private String os;
    private String amiId;
    private String sshKeyName;
    private String architecture;
    private Boolean installUpdatesOnBoot;
    private Boolean ebsOptimized;

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public UpdateInstanceRequest withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public List<String> getLayerIds() {
        if (this.layerIds == null) {
            this.layerIds = new ListWithAutoConstructFlag();
            this.layerIds.setAutoConstruct(true);
        }
        return this.layerIds;
    }

    public void setLayerIds(Collection<String> layerIds) {
        if (layerIds == null) {
            this.layerIds = null;
            return;
        }
        ListWithAutoConstructFlag layerIdsCopy = new ListWithAutoConstructFlag(layerIds.size());
        layerIdsCopy.addAll(layerIds);
        this.layerIds = layerIdsCopy;
    }

    public UpdateInstanceRequest withLayerIds(String ... layerIds) {
        if (this.getLayerIds() == null) {
            this.setLayerIds(new ArrayList<String>(layerIds.length));
        }
        for (String value : layerIds) {
            this.getLayerIds().add(value);
        }
        return this;
    }

    public UpdateInstanceRequest withLayerIds(Collection<String> layerIds) {
        if (layerIds == null) {
            this.layerIds = null;
        } else {
            ListWithAutoConstructFlag layerIdsCopy = new ListWithAutoConstructFlag(layerIds.size());
            layerIdsCopy.addAll(layerIds);
            this.layerIds = layerIdsCopy;
        }
        return this;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public UpdateInstanceRequest withInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return this;
    }

    public String getAutoScalingType() {
        return this.autoScalingType;
    }

    public void setAutoScalingType(String autoScalingType) {
        this.autoScalingType = autoScalingType;
    }

    public UpdateInstanceRequest withAutoScalingType(String autoScalingType) {
        this.autoScalingType = autoScalingType;
        return this;
    }

    public void setAutoScalingType(AutoScalingType autoScalingType) {
        this.autoScalingType = autoScalingType.toString();
    }

    public UpdateInstanceRequest withAutoScalingType(AutoScalingType autoScalingType) {
        this.autoScalingType = autoScalingType.toString();
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public UpdateInstanceRequest withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public UpdateInstanceRequest withOs(String os) {
        this.os = os;
        return this;
    }

    public String getAmiId() {
        return this.amiId;
    }

    public void setAmiId(String amiId) {
        this.amiId = amiId;
    }

    public UpdateInstanceRequest withAmiId(String amiId) {
        this.amiId = amiId;
        return this;
    }

    public String getSshKeyName() {
        return this.sshKeyName;
    }

    public void setSshKeyName(String sshKeyName) {
        this.sshKeyName = sshKeyName;
    }

    public UpdateInstanceRequest withSshKeyName(String sshKeyName) {
        this.sshKeyName = sshKeyName;
        return this;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public UpdateInstanceRequest withArchitecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    public void setArchitecture(Architecture architecture) {
        this.architecture = architecture.toString();
    }

    public UpdateInstanceRequest withArchitecture(Architecture architecture) {
        this.architecture = architecture.toString();
        return this;
    }

    public Boolean isInstallUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
        this.installUpdatesOnBoot = installUpdatesOnBoot;
    }

    public UpdateInstanceRequest withInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
        this.installUpdatesOnBoot = installUpdatesOnBoot;
        return this;
    }

    public Boolean getInstallUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public Boolean isEbsOptimized() {
        return this.ebsOptimized;
    }

    public void setEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
    }

    public UpdateInstanceRequest withEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
        return this;
    }

    public Boolean getEbsOptimized() {
        return this.ebsOptimized;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: " + this.getInstanceId() + ",");
        }
        if (this.getLayerIds() != null) {
            sb.append("LayerIds: " + this.getLayerIds() + ",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: " + this.getInstanceType() + ",");
        }
        if (this.getAutoScalingType() != null) {
            sb.append("AutoScalingType: " + this.getAutoScalingType() + ",");
        }
        if (this.getHostname() != null) {
            sb.append("Hostname: " + this.getHostname() + ",");
        }
        if (this.getOs() != null) {
            sb.append("Os: " + this.getOs() + ",");
        }
        if (this.getAmiId() != null) {
            sb.append("AmiId: " + this.getAmiId() + ",");
        }
        if (this.getSshKeyName() != null) {
            sb.append("SshKeyName: " + this.getSshKeyName() + ",");
        }
        if (this.getArchitecture() != null) {
            sb.append("Architecture: " + this.getArchitecture() + ",");
        }
        if (this.isInstallUpdatesOnBoot() != null) {
            sb.append("InstallUpdatesOnBoot: " + this.isInstallUpdatesOnBoot() + ",");
        }
        if (this.isEbsOptimized() != null) {
            sb.append("EbsOptimized: " + this.isEbsOptimized());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getLayerIds() == null ? 0 : this.getLayerIds().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingType() == null ? 0 : this.getAutoScalingType().hashCode());
        hashCode = 31 * hashCode + (this.getHostname() == null ? 0 : this.getHostname().hashCode());
        hashCode = 31 * hashCode + (this.getOs() == null ? 0 : this.getOs().hashCode());
        hashCode = 31 * hashCode + (this.getAmiId() == null ? 0 : this.getAmiId().hashCode());
        hashCode = 31 * hashCode + (this.getSshKeyName() == null ? 0 : this.getSshKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getArchitecture() == null ? 0 : this.getArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.isInstallUpdatesOnBoot() == null ? 0 : this.isInstallUpdatesOnBoot().hashCode());
        hashCode = 31 * hashCode + (this.isEbsOptimized() == null ? 0 : this.isEbsOptimized().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInstanceRequest)) {
            return false;
        }
        UpdateInstanceRequest other = (UpdateInstanceRequest)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getLayerIds() == null ^ this.getLayerIds() == null) {
            return false;
        }
        if (other.getLayerIds() != null && !other.getLayerIds().equals(this.getLayerIds())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getAutoScalingType() == null ^ this.getAutoScalingType() == null) {
            return false;
        }
        if (other.getAutoScalingType() != null && !other.getAutoScalingType().equals(this.getAutoScalingType())) {
            return false;
        }
        if (other.getHostname() == null ^ this.getHostname() == null) {
            return false;
        }
        if (other.getHostname() != null && !other.getHostname().equals(this.getHostname())) {
            return false;
        }
        if (other.getOs() == null ^ this.getOs() == null) {
            return false;
        }
        if (other.getOs() != null && !other.getOs().equals(this.getOs())) {
            return false;
        }
        if (other.getAmiId() == null ^ this.getAmiId() == null) {
            return false;
        }
        if (other.getAmiId() != null && !other.getAmiId().equals(this.getAmiId())) {
            return false;
        }
        if (other.getSshKeyName() == null ^ this.getSshKeyName() == null) {
            return false;
        }
        if (other.getSshKeyName() != null && !other.getSshKeyName().equals(this.getSshKeyName())) {
            return false;
        }
        if (other.getArchitecture() == null ^ this.getArchitecture() == null) {
            return false;
        }
        if (other.getArchitecture() != null && !other.getArchitecture().equals(this.getArchitecture())) {
            return false;
        }
        if (other.isInstallUpdatesOnBoot() == null ^ this.isInstallUpdatesOnBoot() == null) {
            return false;
        }
        if (other.isInstallUpdatesOnBoot() != null && !other.isInstallUpdatesOnBoot().equals(this.isInstallUpdatesOnBoot())) {
            return false;
        }
        if (other.isEbsOptimized() == null ^ this.isEbsOptimized() == null) {
            return false;
        }
        return other.isEbsOptimized() == null || other.isEbsOptimized().equals(this.isEbsOptimized());
    }
}

