/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elastictranscoder.model.ListPipelinesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPipelinesRequestMarshaller
implements Marshaller<Request<ListPipelinesRequest>, ListPipelinesRequest> {
    @Override
    public Request<ListPipelinesRequest> marshall(ListPipelinesRequest listPipelinesRequest) {
        if (listPipelinesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListPipelinesRequest> request = new DefaultRequest<ListPipelinesRequest>(listPipelinesRequest, "AmazonElasticTranscoder");
        String target = "EtsCustomerService.ListPipelines";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "2012-09-25/pipelines?Ascending={Ascending};PageToken={PageToken}";
        uriResourcePath = uriResourcePath.replace("{Ascending}", listPipelinesRequest.getAscending() == null ? "" : StringUtils.fromString(listPipelinesRequest.getAscending()));
        uriResourcePath = uriResourcePath.replace("{PageToken}", listPipelinesRequest.getPageToken() == null ? "" : StringUtils.fromString(listPipelinesRequest.getPageToken()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        return request;
    }
}

