/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateVolumePermission;
import com.amazonaws.services.ec2.model.CreateVolumePermissionModifications;
import com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifySnapshotAttributeRequestMarshaller
implements Marshaller<Request<ModifySnapshotAttributeRequest>, ModifySnapshotAttributeRequest> {
    @Override
    public Request<ModifySnapshotAttributeRequest> marshall(ModifySnapshotAttributeRequest modifySnapshotAttributeRequest) {
        if (modifySnapshotAttributeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifySnapshotAttributeRequest> request = new DefaultRequest<ModifySnapshotAttributeRequest>(modifySnapshotAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifySnapshotAttribute");
        request.addParameter("Version", "2014-05-01");
        if (modifySnapshotAttributeRequest.getSnapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString(modifySnapshotAttributeRequest.getSnapshotId()));
        }
        if (modifySnapshotAttributeRequest.getAttribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString(modifySnapshotAttributeRequest.getAttribute()));
        }
        if (modifySnapshotAttributeRequest.getOperationType() != null) {
            request.addParameter("OperationType", StringUtils.fromString(modifySnapshotAttributeRequest.getOperationType()));
        }
        List<String> userIdsList = modifySnapshotAttributeRequest.getUserIds();
        int userIdsListIndex = 1;
        for (String userIdsListValue : userIdsList) {
            if (userIdsListValue != null) {
                request.addParameter("UserId." + userIdsListIndex, StringUtils.fromString(userIdsListValue));
            }
            ++userIdsListIndex;
        }
        List<String> groupNamesList = modifySnapshotAttributeRequest.getGroupNames();
        int groupNamesListIndex = 1;
        for (String groupNamesListValue : groupNamesList) {
            if (groupNamesListValue != null) {
                request.addParameter("UserGroup." + groupNamesListIndex, StringUtils.fromString(groupNamesListValue));
            }
            ++groupNamesListIndex;
        }
        CreateVolumePermissionModifications createVolumePermissionModificationsCreateVolumePermission = modifySnapshotAttributeRequest.getCreateVolumePermission();
        if (createVolumePermissionModificationsCreateVolumePermission != null) {
            List<CreateVolumePermission> addList = createVolumePermissionModificationsCreateVolumePermission.getAdd();
            int addListIndex = 1;
            for (CreateVolumePermission addListValue : addList) {
                CreateVolumePermission createVolumePermissionMember = addListValue;
                if (createVolumePermissionMember != null) {
                    if (createVolumePermissionMember.getUserId() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".UserId", StringUtils.fromString(createVolumePermissionMember.getUserId()));
                    }
                    if (createVolumePermissionMember.getGroup() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".Group", StringUtils.fromString(createVolumePermissionMember.getGroup()));
                    }
                }
                ++addListIndex;
            }
            List<CreateVolumePermission> removeList = createVolumePermissionModificationsCreateVolumePermission.getRemove();
            int removeListIndex = 1;
            for (CreateVolumePermission removeListValue : removeList) {
                CreateVolumePermission createVolumePermissionMember = removeListValue;
                if (createVolumePermissionMember != null) {
                    if (createVolumePermissionMember.getUserId() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".UserId", StringUtils.fromString(createVolumePermissionMember.getUserId()));
                    }
                    if (createVolumePermissionMember.getGroup() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".Group", StringUtils.fromString(createVolumePermissionMember.getGroup()));
                    }
                }
                ++removeListIndex;
            }
        }
        return request;
    }
}

