/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeSnapshotsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeSnapshotsRequest>, DescribeSnapshotsRequest> {
    @Override
    public Request<DescribeSnapshotsRequest> marshall(DescribeSnapshotsRequest describeSnapshotsRequest) {
        if (describeSnapshotsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeSnapshotsRequest> request = new DefaultRequest<DescribeSnapshotsRequest>(describeSnapshotsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeSnapshots");
        request.addParameter("Version", "2014-05-01");
        List<String> snapshotIdsList = describeSnapshotsRequest.getSnapshotIds();
        int snapshotIdsListIndex = 1;
        for (String snapshotIdsListValue : snapshotIdsList) {
            if (snapshotIdsListValue != null) {
                request.addParameter("SnapshotId." + snapshotIdsListIndex, StringUtils.fromString(snapshotIdsListValue));
            }
            ++snapshotIdsListIndex;
        }
        List<String> ownerIdsList = describeSnapshotsRequest.getOwnerIds();
        int ownerIdsListIndex = 1;
        for (String ownerIdsListValue : ownerIdsList) {
            if (ownerIdsListValue != null) {
                request.addParameter("Owner." + ownerIdsListIndex, StringUtils.fromString(ownerIdsListValue));
            }
            ++ownerIdsListIndex;
        }
        List<String> restorableByUserIdsList = describeSnapshotsRequest.getRestorableByUserIds();
        int restorableByUserIdsListIndex = 1;
        for (String restorableByUserIdsListValue : restorableByUserIdsList) {
            if (restorableByUserIdsListValue != null) {
                request.addParameter("RestorableBy." + restorableByUserIdsListIndex, StringUtils.fromString(restorableByUserIdsListValue));
            }
            ++restorableByUserIdsListIndex;
        }
        List<Filter> filtersList = describeSnapshotsRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        return request;
    }
}

