/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudsearchv2.model.ScalingParameters;
import com.amazonaws.services.cloudsearchv2.model.UpdateScalingParametersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateScalingParametersRequestMarshaller
implements Marshaller<Request<UpdateScalingParametersRequest>, UpdateScalingParametersRequest> {
    @Override
    public Request<UpdateScalingParametersRequest> marshall(UpdateScalingParametersRequest updateScalingParametersRequest) {
        ScalingParameters scalingParametersScalingParameters;
        if (updateScalingParametersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateScalingParametersRequest> request = new DefaultRequest<UpdateScalingParametersRequest>(updateScalingParametersRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "UpdateScalingParameters");
        request.addParameter("Version", "2013-01-01");
        if (updateScalingParametersRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(updateScalingParametersRequest.getDomainName()));
        }
        if ((scalingParametersScalingParameters = updateScalingParametersRequest.getScalingParameters()) != null) {
            if (scalingParametersScalingParameters.getDesiredInstanceType() != null) {
                request.addParameter("ScalingParameters.DesiredInstanceType", StringUtils.fromString(scalingParametersScalingParameters.getDesiredInstanceType()));
            }
            if (scalingParametersScalingParameters.getDesiredReplicationCount() != null) {
                request.addParameter("ScalingParameters.DesiredReplicationCount", StringUtils.fromInteger(scalingParametersScalingParameters.getDesiredReplicationCount()));
            }
            if (scalingParametersScalingParameters.getDesiredPartitionCount() != null) {
                request.addParameter("ScalingParameters.DesiredPartitionCount", StringUtils.fromInteger(scalingParametersScalingParameters.getDesiredPartitionCount()));
            }
        }
        return request;
    }
}

