/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeImagesRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeImagesRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<DescribeImagesRequest> {
    private ListWithAutoConstructFlag<String> imageIds;
    private ListWithAutoConstructFlag<String> owners;
    private ListWithAutoConstructFlag<String> executableUsers;
    private ListWithAutoConstructFlag<Filter> filters;

    public List<String> getImageIds() {
        if (this.imageIds == null) {
            this.imageIds = new ListWithAutoConstructFlag();
            this.imageIds.setAutoConstruct(true);
        }
        return this.imageIds;
    }

    public void setImageIds(Collection<String> imageIds) {
        if (imageIds == null) {
            this.imageIds = null;
            return;
        }
        ListWithAutoConstructFlag imageIdsCopy = new ListWithAutoConstructFlag(imageIds.size());
        imageIdsCopy.addAll(imageIds);
        this.imageIds = imageIdsCopy;
    }

    public DescribeImagesRequest withImageIds(String ... imageIds) {
        if (this.getImageIds() == null) {
            this.setImageIds(new ArrayList<String>(imageIds.length));
        }
        for (String value : imageIds) {
            this.getImageIds().add(value);
        }
        return this;
    }

    public DescribeImagesRequest withImageIds(Collection<String> imageIds) {
        if (imageIds == null) {
            this.imageIds = null;
        } else {
            ListWithAutoConstructFlag imageIdsCopy = new ListWithAutoConstructFlag(imageIds.size());
            imageIdsCopy.addAll(imageIds);
            this.imageIds = imageIdsCopy;
        }
        return this;
    }

    public List<String> getOwners() {
        if (this.owners == null) {
            this.owners = new ListWithAutoConstructFlag();
            this.owners.setAutoConstruct(true);
        }
        return this.owners;
    }

    public void setOwners(Collection<String> owners) {
        if (owners == null) {
            this.owners = null;
            return;
        }
        ListWithAutoConstructFlag ownersCopy = new ListWithAutoConstructFlag(owners.size());
        ownersCopy.addAll(owners);
        this.owners = ownersCopy;
    }

    public DescribeImagesRequest withOwners(String ... owners) {
        if (this.getOwners() == null) {
            this.setOwners(new ArrayList<String>(owners.length));
        }
        for (String value : owners) {
            this.getOwners().add(value);
        }
        return this;
    }

    public DescribeImagesRequest withOwners(Collection<String> owners) {
        if (owners == null) {
            this.owners = null;
        } else {
            ListWithAutoConstructFlag ownersCopy = new ListWithAutoConstructFlag(owners.size());
            ownersCopy.addAll(owners);
            this.owners = ownersCopy;
        }
        return this;
    }

    public List<String> getExecutableUsers() {
        if (this.executableUsers == null) {
            this.executableUsers = new ListWithAutoConstructFlag();
            this.executableUsers.setAutoConstruct(true);
        }
        return this.executableUsers;
    }

    public void setExecutableUsers(Collection<String> executableUsers) {
        if (executableUsers == null) {
            this.executableUsers = null;
            return;
        }
        ListWithAutoConstructFlag executableUsersCopy = new ListWithAutoConstructFlag(executableUsers.size());
        executableUsersCopy.addAll(executableUsers);
        this.executableUsers = executableUsersCopy;
    }

    public DescribeImagesRequest withExecutableUsers(String ... executableUsers) {
        if (this.getExecutableUsers() == null) {
            this.setExecutableUsers(new ArrayList<String>(executableUsers.length));
        }
        for (String value : executableUsers) {
            this.getExecutableUsers().add(value);
        }
        return this;
    }

    public DescribeImagesRequest withExecutableUsers(Collection<String> executableUsers) {
        if (executableUsers == null) {
            this.executableUsers = null;
        } else {
            ListWithAutoConstructFlag executableUsersCopy = new ListWithAutoConstructFlag(executableUsers.size());
            executableUsersCopy.addAll(executableUsers);
            this.executableUsers = executableUsersCopy;
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeImagesRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeImagesRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    @Override
    public Request<DescribeImagesRequest> getDryRunRequest() {
        Request<DescribeImagesRequest> request = new DescribeImagesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImageIds() != null) {
            sb.append("ImageIds: " + this.getImageIds() + ",");
        }
        if (this.getOwners() != null) {
            sb.append("Owners: " + this.getOwners() + ",");
        }
        if (this.getExecutableUsers() != null) {
            sb.append("ExecutableUsers: " + this.getExecutableUsers() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImageIds() == null ? 0 : this.getImageIds().hashCode());
        hashCode = 31 * hashCode + (this.getOwners() == null ? 0 : this.getOwners().hashCode());
        hashCode = 31 * hashCode + (this.getExecutableUsers() == null ? 0 : this.getExecutableUsers().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesRequest)) {
            return false;
        }
        DescribeImagesRequest other = (DescribeImagesRequest)obj;
        if (other.getImageIds() == null ^ this.getImageIds() == null) {
            return false;
        }
        if (other.getImageIds() != null && !other.getImageIds().equals(this.getImageIds())) {
            return false;
        }
        if (other.getOwners() == null ^ this.getOwners() == null) {
            return false;
        }
        if (other.getOwners() != null && !other.getOwners().equals(this.getOwners())) {
            return false;
        }
        if (other.getExecutableUsers() == null ^ this.getExecutableUsers() == null) {
            return false;
        }
        if (other.getExecutableUsers() != null && !other.getExecutableUsers().equals(this.getExecutableUsers())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || other.getFilters().equals(this.getFilters());
    }
}

