/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateNetworkInterfaceRequestMarshaller
implements Marshaller<Request<CreateNetworkInterfaceRequest>, CreateNetworkInterfaceRequest> {
    @Override
    public Request<CreateNetworkInterfaceRequest> marshall(CreateNetworkInterfaceRequest createNetworkInterfaceRequest) {
        if (createNetworkInterfaceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateNetworkInterfaceRequest> request = new DefaultRequest<CreateNetworkInterfaceRequest>(createNetworkInterfaceRequest, "AmazonEC2");
        request.addParameter("Action", "CreateNetworkInterface");
        request.addParameter("Version", "2012-06-15");
        if (createNetworkInterfaceRequest.getSubnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString(createNetworkInterfaceRequest.getSubnetId()));
        }
        if (createNetworkInterfaceRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createNetworkInterfaceRequest.getDescription()));
        }
        if (createNetworkInterfaceRequest.getPrivateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString(createNetworkInterfaceRequest.getPrivateIpAddress()));
        }
        List<String> groupsList = createNetworkInterfaceRequest.getGroups();
        int groupsListIndex = 1;
        for (String groupsListValue : groupsList) {
            if (groupsListValue != null) {
                request.addParameter("SecurityGroupId." + groupsListIndex, StringUtils.fromString(groupsListValue));
            }
            ++groupsListIndex;
        }
        List<PrivateIpAddressSpecification> privateIpAddressesList = createNetworkInterfaceRequest.getPrivateIpAddresses();
        int privateIpAddressesListIndex = 1;
        for (PrivateIpAddressSpecification privateIpAddressesListValue : privateIpAddressesList) {
            PrivateIpAddressSpecification privateIpAddressSpecificationMember = privateIpAddressesListValue;
            if (privateIpAddressSpecificationMember != null) {
                if (privateIpAddressSpecificationMember.getPrivateIpAddress() != null) {
                    request.addParameter("PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString(privateIpAddressSpecificationMember.getPrivateIpAddress()));
                }
                if (privateIpAddressSpecificationMember.isPrimary() != null) {
                    request.addParameter("PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean(privateIpAddressSpecificationMember.isPrimary()));
                }
            }
            ++privateIpAddressesListIndex;
        }
        if (createNetworkInterfaceRequest.getSecondaryPrivateIpAddressCount() != null) {
            request.addParameter("SecondaryPrivateIpAddressCount", StringUtils.fromInteger(createNetworkInterfaceRequest.getSecondaryPrivateIpAddressCount()));
        }
        return request;
    }
}

