/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearch.model;

import com.amazonaws.services.cloudsearch.model.IndexFieldType;
import com.amazonaws.services.cloudsearch.model.LiteralOptions;
import com.amazonaws.services.cloudsearch.model.SourceAttribute;
import com.amazonaws.services.cloudsearch.model.TextOptions;
import com.amazonaws.services.cloudsearch.model.UIntOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexField {
    private String indexFieldName;
    private String indexFieldType;
    private UIntOptions uIntOptions;
    private LiteralOptions literalOptions;
    private TextOptions textOptions;
    private List<SourceAttribute> sourceAttributes;

    public String getIndexFieldName() {
        return this.indexFieldName;
    }

    public void setIndexFieldName(String indexFieldName) {
        this.indexFieldName = indexFieldName;
    }

    public IndexField withIndexFieldName(String indexFieldName) {
        this.indexFieldName = indexFieldName;
        return this;
    }

    public String getIndexFieldType() {
        return this.indexFieldType;
    }

    public void setIndexFieldType(String indexFieldType) {
        this.indexFieldType = indexFieldType;
    }

    public IndexField withIndexFieldType(String indexFieldType) {
        this.indexFieldType = indexFieldType;
        return this;
    }

    public void setIndexFieldType(IndexFieldType indexFieldType) {
        this.indexFieldType = indexFieldType.toString();
    }

    public IndexField withIndexFieldType(IndexFieldType indexFieldType) {
        this.indexFieldType = indexFieldType.toString();
        return this;
    }

    public UIntOptions getUIntOptions() {
        return this.uIntOptions;
    }

    public void setUIntOptions(UIntOptions uIntOptions) {
        this.uIntOptions = uIntOptions;
    }

    public IndexField withUIntOptions(UIntOptions uIntOptions) {
        this.uIntOptions = uIntOptions;
        return this;
    }

    public LiteralOptions getLiteralOptions() {
        return this.literalOptions;
    }

    public void setLiteralOptions(LiteralOptions literalOptions) {
        this.literalOptions = literalOptions;
    }

    public IndexField withLiteralOptions(LiteralOptions literalOptions) {
        this.literalOptions = literalOptions;
        return this;
    }

    public TextOptions getTextOptions() {
        return this.textOptions;
    }

    public void setTextOptions(TextOptions textOptions) {
        this.textOptions = textOptions;
    }

    public IndexField withTextOptions(TextOptions textOptions) {
        this.textOptions = textOptions;
        return this;
    }

    public List<SourceAttribute> getSourceAttributes() {
        if (this.sourceAttributes == null) {
            this.sourceAttributes = new ArrayList<SourceAttribute>();
        }
        return this.sourceAttributes;
    }

    public void setSourceAttributes(Collection<SourceAttribute> sourceAttributes) {
        if (sourceAttributes == null) {
            this.sourceAttributes = null;
            return;
        }
        ArrayList<SourceAttribute> sourceAttributesCopy = new ArrayList<SourceAttribute>(sourceAttributes.size());
        sourceAttributesCopy.addAll(sourceAttributes);
        this.sourceAttributes = sourceAttributesCopy;
    }

    public IndexField withSourceAttributes(SourceAttribute ... sourceAttributes) {
        if (this.getSourceAttributes() == null) {
            this.setSourceAttributes(new ArrayList<SourceAttribute>(sourceAttributes.length));
        }
        for (SourceAttribute value : sourceAttributes) {
            this.getSourceAttributes().add(value);
        }
        return this;
    }

    public IndexField withSourceAttributes(Collection<SourceAttribute> sourceAttributes) {
        if (sourceAttributes == null) {
            this.sourceAttributes = null;
        } else {
            ArrayList<SourceAttribute> sourceAttributesCopy = new ArrayList<SourceAttribute>(sourceAttributes.size());
            sourceAttributesCopy.addAll(sourceAttributes);
            this.sourceAttributes = sourceAttributesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.indexFieldName != null) {
            sb.append("IndexFieldName: " + this.indexFieldName + ", ");
        }
        if (this.indexFieldType != null) {
            sb.append("IndexFieldType: " + this.indexFieldType + ", ");
        }
        if (this.uIntOptions != null) {
            sb.append("UIntOptions: " + this.uIntOptions + ", ");
        }
        if (this.literalOptions != null) {
            sb.append("LiteralOptions: " + this.literalOptions + ", ");
        }
        if (this.textOptions != null) {
            sb.append("TextOptions: " + this.textOptions + ", ");
        }
        if (this.sourceAttributes != null) {
            sb.append("SourceAttributes: " + this.sourceAttributes + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIndexFieldName() == null ? 0 : this.getIndexFieldName().hashCode());
        hashCode = 31 * hashCode + (this.getIndexFieldType() == null ? 0 : this.getIndexFieldType().hashCode());
        hashCode = 31 * hashCode + (this.getUIntOptions() == null ? 0 : this.getUIntOptions().hashCode());
        hashCode = 31 * hashCode + (this.getLiteralOptions() == null ? 0 : this.getLiteralOptions().hashCode());
        hashCode = 31 * hashCode + (this.getTextOptions() == null ? 0 : this.getTextOptions().hashCode());
        hashCode = 31 * hashCode + (this.getSourceAttributes() == null ? 0 : ((Object)this.getSourceAttributes()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexField)) {
            return false;
        }
        IndexField other = (IndexField)obj;
        if (other.getIndexFieldName() == null ^ this.getIndexFieldName() == null) {
            return false;
        }
        if (other.getIndexFieldName() != null && !other.getIndexFieldName().equals(this.getIndexFieldName())) {
            return false;
        }
        if (other.getIndexFieldType() == null ^ this.getIndexFieldType() == null) {
            return false;
        }
        if (other.getIndexFieldType() != null && !other.getIndexFieldType().equals(this.getIndexFieldType())) {
            return false;
        }
        if (other.getUIntOptions() == null ^ this.getUIntOptions() == null) {
            return false;
        }
        if (other.getUIntOptions() != null && !other.getUIntOptions().equals(this.getUIntOptions())) {
            return false;
        }
        if (other.getLiteralOptions() == null ^ this.getLiteralOptions() == null) {
            return false;
        }
        if (other.getLiteralOptions() != null && !other.getLiteralOptions().equals(this.getLiteralOptions())) {
            return false;
        }
        if (other.getTextOptions() == null ^ this.getTextOptions() == null) {
            return false;
        }
        if (other.getTextOptions() != null && !other.getTextOptions().equals(this.getTextOptions())) {
            return false;
        }
        if (other.getSourceAttributes() == null ^ this.getSourceAttributes() == null) {
            return false;
        }
        return other.getSourceAttributes() == null || ((Object)other.getSourceAttributes()).equals(this.getSourceAttributes());
    }
}

